/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.SourceFactory;
import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.mediator.InteractionLoader;
import de.berlin.hu.ppi.mediator.LoaderException;
import de.berlin.hu.ppi.net.Downloader;
import de.berlin.hu.ppi.net.FTPStreamSourceFactory;
import de.berlin.hu.ppi.net.StreamSource;
import de.berlin.hu.ppi.net.StreamSourceFactory;
import de.berlin.hu.ppi.net.URLStreamSourceFactory;
import de.berlin.hu.ppi.tool.Extract;
import de.berlin.hu.ppi.tool.InputStreamTool;
import de.berlin.hu.ppi.tool.StreamCopy;
import de.berlin.hu.ppi.tool.Timer;
import de.berlin.hu.ppi.tool.WgetDownloader;
import de.berlin.hu.ppi.update.LockingManager;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.management.InstanceNotFoundException;
import org.apache.log4j.Logger;

public abstract class AbstractUpdatePlugin
implements UpdatePlugin,
Runnable,
PpiConstants {
    private static final String QUERY_DELETE = "delete from %s";
    public static final int IDLE = -1;
    public static final String KEY_LAST_UPDATE = "lastUpdate";
    public static final String KEY_INTERACTION_COUNT = "interactionCount";
    public static final String KEY_TARGET_PATH = "targetPath";
    protected static final String KEY_DATA_COUNT = "dataCount";
    protected static final String KEY_UPDATE_HASH = "updateHash";
    protected static final String KEY_UPDATE_DURATION = "updateDuration";
    protected Logger log = Logger.getLogger(AbstractUpdatePlugin.class);
    private int task = -1;
    protected boolean isUpdateAvailable = false;
    protected boolean isInterrupted = false;
    protected boolean banCancel = false;
    protected int taskCount = 1;
    protected int hashingBufferSize = 20480;
    protected int updateHash = 0;
    private long counterCurrent = 0L;
    private long counterFinish = 0L;
    protected long taskStartTime = -1L;
    protected long updateStartTime;
    private long downloadLengthHint;
    private double taskProgress = 0.0;
    private double fakeProgress;
    protected PpiConstants.DB_ID sourceId;
    protected String[] taskDescriptions;
    protected String[] tableNames;
    protected String taskDescription;
    protected String description = "";
    protected String pluginName = "";
    protected Downloader downloader;
    protected Connection connection;
    protected BufferedReader reader;
    protected LockingManager lockingManager;
    private String FormatPattern = "yyyy.MM.dd|HH:mm:ss";
    private SimpleDateFormat dateFormat;
    private File targetDirectory;
    private UpdatePlugin.State state;
    private String lockId = this.getClass().getName();
    protected Exception exception;
    private Thread progressThread;
    private long oldRemainingTime = Long.MAX_VALUE;
    private Thread myThread;
    private Date lastUpdateTime;
    private int processedInteractions;
    private int countedInteractions;

    public AbstractUpdatePlugin() throws InstanceNotFoundException, UpdatePluginException {
        this.log = Logger.getLogger(this.getClass());
        this.lockingManager = LockingManager.getInstance();
        this.dateFormat = new SimpleDateFormat(this.FormatPattern);
        this.state = UpdatePlugin.State.RESET;
        this.reset();
    }

    @Override
    public void join() {
        if (this.myThread != null) {
            try {
                this.myThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void checkForUpdates() {
        if (!this.isUpdateAvailable()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        int oldUpdateHash = AbstractUpdatePlugin.this.getOldUpdateHash();
                        int currentUpdateHash = AbstractUpdatePlugin.this.getCurrentUpdateHash();
                        AbstractUpdatePlugin.this.isUpdateAvailable = oldUpdateHash != currentUpdateHash;
                        AbstractUpdatePlugin.this.updateHash = currentUpdateHash;
                    }
                    catch (Exception e) {
                        AbstractUpdatePlugin.this.log.warn("", e);
                        AbstractUpdatePlugin.this.isUpdateAvailable = true;
                    }
                }
            }.start();
        }
    }

    protected abstract int getCurrentUpdateHash() throws Exception;

    protected abstract void runUpdate() throws Exception;

    public int getCurrentTaskId() {
        return this.task;
    }

    public void startTask(int taskId, String description) {
        this.startTask(taskId);
        this.setTaskDescription(description);
    }

    public void setTaskDescription(String description) {
        this.taskDescription = description;
    }

    public void saveCurrentTaskDuration() {
        if (this.task >= 0) {
            long taskDuration = System.currentTimeMillis() - this.taskStartTime;
            this.setProperty(this.getTaskDurationKey(this.task), String.valueOf(taskDuration));
        }
    }

    public long getTastDuration(int task) {
        return Long.parseLong(this.getProperty(this.getTaskDurationKey(task)));
    }

    public String getTaskDurationKey(int task) {
        return "taskDuration_" + String.format("%02d", task);
    }

    public void startTask(int taskId) {
        this.taskDescription = null;
        this.taskProgress = 0.0;
        this.task = taskId;
        this.oldRemainingTime = Long.MAX_VALUE;
        this.setTaskStartTime();
    }

    public void setTaskStartTime() {
        this.taskStartTime = System.currentTimeMillis();
    }

    public void startNextTask(String description) {
        this.startNextTask();
        this.setTaskDescription(description);
    }

    public void startNextTask() {
        this.startTask(this.task + 1);
    }

    @Override
    public final void run() {
        try {
            this.state = UpdatePlugin.State.RUNNING;
            this.updateStartTime = System.currentTimeMillis();
            this.runUpdate();
        }
        catch (Exception e) {
            this.log.error("", e);
            this.exception = e;
            this.isInterrupted = true;
        }
        this.finish();
    }

    @Override
    public UpdatePlugin.State getState() {
        return this.state;
    }

    public long getCurrentCounter() {
        return this.counterCurrent;
    }

    public void setCounterFinish(long value) {
        this.setTaskStartTime();
        this.counterFinish = value;
        this.counterCurrent = 0L;
    }

    public void increaseCounter(long amount) {
        this.counterCurrent += amount;
        this.setTaskProgress((double)this.counterCurrent / (double)this.counterFinish);
    }

    public void incrementCounter() {
        this.increaseCounter(1L);
    }

    public int getBatchSize() {
        return 500;
    }

    public static String getTempName(String name) {
        return name + "_tmp";
    }

    public static String getBackupName(String name) {
        return name + "_old";
    }

    private void adoptTempTable(String name) {
        this.backupOldTable(name);
        this.log.info("Adopting temp table: Renaming \"" + AbstractUpdatePlugin.getTempName(name) + "\" to \"" + name + "\".");
        this.renameTable(AbstractUpdatePlugin.getTempName(name), name);
    }

    protected void adoptTempTables() {
        if (this.tableNames != null) {
            for (String name : this.tableNames) {
                this.adoptTempTable(name);
            }
        }
    }

    protected void createTempTables() {
        if (this.tableNames != null) {
            for (String table : this.tableNames) {
                try {
                    this.createTempTable(table);
                    this.log.info("Created temp table: \"" + AbstractUpdatePlugin.getTempName(table) + "\" for  \"" + table + "\".");
                }
                catch (SQLException e) {
                    this.log.error("Could not create temp table \"" + table + "\".", e);
                }
            }
        }
    }

    protected void clearTables(String ... tables) throws SQLException {
        Statement deleteFrom = this.connection.createStatement();
        for (String table : tables) {
            deleteFrom.executeUpdate(String.format(QUERY_DELETE, table));
        }
    }

    protected long getTaskDuration(int taskId) {
        try {
            return Long.parseLong(this.getTaskDurationKey(taskId));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private void createTempTable(String name) throws SQLException {
        String tempName = AbstractUpdatePlugin.getTempName(name);
        this.dropTable(tempName);
        String createTempTableQuery = "CREATE TABLE " + tempName + " LIKE " + name;
        this.connection.prepareStatement(createTempTableQuery).execute();
    }

    public void dropTempTables() {
        if (this.tableNames != null) {
            for (String name : this.tableNames) {
                this.dropTable(AbstractUpdatePlugin.getTempName(name));
            }
        }
    }

    public void backupOldTable(String name) {
        this.log.info("Dropping old backup \"" + AbstractUpdatePlugin.getBackupName(name) + "\" if exists.");
        this.dropTable(AbstractUpdatePlugin.getBackupName(name));
        this.log.info("Creating new backup: Renaming \"" + name + "\" to \"" + AbstractUpdatePlugin.getBackupName(name) + "\".");
        this.renameTable(name, AbstractUpdatePlugin.getBackupName(name));
    }

    public void dropBackupTables() {
        if (this.tableNames != null) {
            for (String name : this.tableNames) {
                this.dropTable(AbstractUpdatePlugin.getBackupName(name));
            }
        }
    }

    public void renameTable(String oldName, String newName) {
        try {
            this.connection.prepareStatement("ALTER TABLE " + oldName + " RENAME " + newName).execute();
        }
        catch (SQLException e) {
            this.log.error("", e);
        }
    }

    public void dropTable(String name) {
        try {
            this.connection.prepareStatement("DROP TABLE IF EXISTS " + name).execute();
        }
        catch (SQLException e) {
            this.log.error("", e);
        }
    }

    public void clearTable(String name) {
        try {
            this.connection.prepareStatement(String.format(QUERY_DELETE, name)).execute();
        }
        catch (Exception e) {
            this.log.error("", e);
        }
    }

    public BufferedReader openReader(InputStream inputStream) {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.log.error("", e);
            }
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        return this.reader;
    }

    public BufferedReader openGzipReader(InputStream inputStream) {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(inputStream)));
            return this.reader;
        }
        catch (IOException e) {
            this.log.error("", e);
            return null;
        }
    }

    public BufferedReader openReader(File file) {
        try {
            this.log.info("Opening file reader for: " + file);
            return this.openReader(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            this.log.error("", e);
            return null;
        }
    }

    public Connection openDatabaseConnection() throws SQLException {
        Connection con = DbService.getCurrentService().getNewConnection();
        if (this.connection == null || this.connection.isClosed()) {
            this.log.info("Opened new Database-Connection.");
            this.connection = con;
        }
        return con;
    }

    public Connection openDatabaseConnection(boolean autoCommit) throws SQLException {
        Connection con = this.openDatabaseConnection();
        con.setAutoCommit(autoCommit);
        return con;
    }

    public double fakeProgress(double x, double a, double c) {
        if (!this.isInterrupted) {
            this.fakeProgress = AbstractUpdatePlugin.fakeProgressFunction(x, a, c);
        }
        return this.fakeProgress;
    }

    public static double fakeProgressFunction(double x, double a, double c) {
        if (x >= 0.0 && a > 0.0 && c > 0.0 && c < 1.0) {
            if (x < a) {
                return c / a * x;
            }
            return 1.0 - 1.0 / ((1.0 / (1.0 - c) - 1.0) / a * x + 1.0);
        }
        return 0.0;
    }

    public int getOldUpdateHash() {
        int hash = 0;
        String oldHash = this.getProperty(KEY_UPDATE_HASH);
        if (oldHash != null) {
            try {
                hash = Integer.parseInt(oldHash);
            }
            catch (Exception e) {
                this.log.warn("", e);
            }
        }
        return hash;
    }

    @Deprecated
    public int computeHashCodeFromOnlineFiles(String[] urls) throws IOException {
        List<String> list = Arrays.asList(urls);
        return this.computeHashCodeFromOnlineFiles(list);
    }

    public int computeHashCodeFromOnlineFiles(List<String> urls) throws IOException {
        int hashCode = 0;
        for (String urlString : urls) {
            StreamSource source = StreamSourceFactory.getStreamSourceByUrl(urlString);
            BufferedInputStream input = new BufferedInputStream(source.getStream(), this.hashingBufferSize);
            hashCode ^= InputStreamTool.getBeginningHashCode(input, this.hashingBufferSize);
        }
        this.log.info("New (url) hash code: " + String.valueOf(hashCode));
        return hashCode;
    }

    @Override
    public void cancel() throws UpdatePluginException {
        if (this.banCancel) {
            throw new UpdatePluginException("It is not allowed to interrupted the update at the moment.");
        }
        if (!this.getState().equals((Object)UpdatePlugin.State.RUNNING)) {
            throw new UpdatePluginException("Update process cannot be interrupted because it is not running.");
        }
        this.log.info("Cancel requesteted, trying to interrupt main thread...");
        this.isInterrupted = true;
    }

    @Override
    public double getTaskProgress() {
        switch (this.state) {
            case DONE: {
                return 1.0;
            }
            case RUNNING: {
                return this.taskProgress;
            }
        }
        return 0.0;
    }

    @Override
    public String getTaskDescription() {
        if (this.task == -1) {
            if (this.lastUpdateTime == null) {
                return "Last Update time unknown.";
            }
            SimpleDateFormat format = new SimpleDateFormat();
            return "Last Update on " + format.format(this.lastUpdateTime);
        }
        if (this.state.equals((Object)UpdatePlugin.State.RUNNING)) {
            if (this.taskDescription != null && !this.taskDescription.isEmpty()) {
                return this.taskDescription + " " + this.getFormattedTaskRemainingTime();
            }
            if (this.taskDescriptions != null && this.task < this.taskDescriptions.length && this.taskDescriptions[this.task] != null) {
                return this.taskDescriptions[this.task] + " " + this.getFormattedTaskRemainingTime();
            }
            return this.getFormattedTaskRemainingTime();
        }
        if (this.state.equals((Object)UpdatePlugin.State.DONE)) {
            return "Done.";
        }
        return "Canceled.";
    }

    public String getProperty(String key) {
        String prefixedKey = null;
        prefixedKey = !key.startsWith(this.getPropertyKeyPrefix()) ? this.getPropertyKeyPrefix() + key : key;
        String getValueQuery = "select property_value from client_properties where property_key = '" + prefixedKey + "'";
        String value = null;
        try {
            ResultSet result = DbService.getCurrentService().getStaticStatement().executeQuery(getValueQuery);
            if (result != null && result.next()) {
                value = result.getString(1);
            }
        }
        catch (Exception e) {
            this.log.warn("Could not fetch value: " + prefixedKey, e);
        }
        return value;
    }

    public void setProperty(String key, String value) {
        String prefixedKey = null;
        prefixedKey = !key.startsWith(this.getPropertyKeyPrefix()) ? this.getPropertyKeyPrefix() + key : key;
        String updataQuery = "insert into client_properties values ('" + prefixedKey + "', '" + value + "') on duplicate key update property_value = '" + value + "'";
        try {
            DbService.getCurrentService().getStaticStatement().executeUpdate(updataQuery);
        }
        catch (Exception e) {
            this.log.warn("Could not insert (Key, Value) = ('" + prefixedKey + "','" + value + "')", e);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getLastUpdateTime() {
        try {
            this.lastUpdateTime = this.dateFormat.parse(this.getProperty(KEY_LAST_UPDATE));
            return this.lastUpdateTime;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getUpdateTime(String key) {
        try {
            Date output = this.dateFormat.parse(this.getProperty(key));
            return output;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setUpdateTime(Date date) {
        this.setProperty(KEY_LAST_UPDATE, this.dateFormat.format(date));
    }

    protected void setUpdateTime(String key, Date date) {
        this.setProperty(key, this.dateFormat.format(date));
    }

    protected void setUpdateTime() {
        this.setUpdateTime(new Date());
    }

    @Override
    public String getName() {
        return this.pluginName;
    }

    @Override
    public double getProgress() {
        if (this.taskProgress < 0.0 || this.taskProgress > 1.0) {
            this.log.warn("Subtaskprogress not in [0,1]: " + this.taskProgress + " : " + this.task);
        }
        return this.getState().equals((Object)UpdatePlugin.State.DONE) ? 1.0 : (this.task == -1 ? 0.0 : ((double)this.task + this.taskProgress) / (double)this.taskCount);
    }

    public String getPropertyKeyPrefix() {
        return this.getClass().getName() + ".";
    }

    public long getTaskRunningTime() {
        if (this.taskStartTime > 0L) {
            return System.currentTimeMillis() - this.taskStartTime;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpdate() throws UpdatePluginException {
        if (!this.getState().equals((Object)UpdatePlugin.State.RESET)) {
            throw new UpdatePluginException("Update cannot be started because it is not reset.");
        }
        LockingManager lockingManager = this.lockingManager;
        synchronized (lockingManager) {
            try {
                if (this.lockingManager.isLocked(this.lockId)) {
                    throw new UpdatePluginException("Update cannot be started because it is running on another client.");
                }
                this.log.info("Locking " + this.lockId);
                this.lockingManager.lock(this.lockId);
                this.myThread = new Thread(this);
                this.myThread.start();
            }
            catch (Exception e) {
                this.log.error("", e);
                throw new UpdatePluginException("Update cannot be started. Could not lock this update.");
            }
        }
    }

    @Override
    public void reset() throws UpdatePluginException {
        switch (this.getState()) {
            case DONE: 
            case CANCELLED: 
            case RESET: {
                this.progressThread = null;
                this.task = -1;
                this.taskProgress = 0.0;
                this.downloader = null;
                this.isInterrupted = false;
                this.state = UpdatePlugin.State.RESET;
                this.taskStartTime = -1L;
                this.oldRemainingTime = Long.MAX_VALUE;
                this.getLastUpdateTime();
                break;
            }
            default: {
                throw new UpdatePluginException("Plugin cannot be reset in state: " + (Object)((Object)this.getState()));
            }
        }
    }

    protected void finish() {
        this.banCancel = true;
        this.log.info("cleaning up");
        if (this.isInterrupted) {
            this.log.info("Update " + this.getName() + " was cancelled.");
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    if (this.connection.getAutoCommit()) {
                        this.dropTempTables();
                    } else {
                        this.log.info("rolling back database...");
                        this.connection.rollback();
                    }
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                this.log.error("", e);
            }
            this.state = UpdatePlugin.State.CANCELLED;
        } else {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    if (this.connection.getAutoCommit()) {
                        this.adoptTempTables();
                        this.dropBackupTables();
                    } else {
                        this.connection.commit();
                    }
                    this.connection.close();
                }
                this.setUpdateTime();
                this.state = UpdatePlugin.State.DONE;
            }
            catch (Exception e) {
                this.state = UpdatePlugin.State.ILLEGAL;
            }
            this.saveCurrentTaskDuration();
            long duration = System.currentTimeMillis() - this.updateStartTime;
            this.log.info(String.format("The update %s took %s.", this.getName(), Timer.timeToString(duration)));
            this.setProperty(KEY_UPDATE_DURATION, String.valueOf(duration));
            if (this.updateHash != 0) {
                this.setProperty(KEY_UPDATE_HASH, String.valueOf(this.updateHash));
            } else {
                this.log.warn("Current Update Hash is '0'");
            }
        }
        this.connection = null;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.log.error("", e);
            }
            this.reader = null;
        }
        this.isUpdateAvailable = false;
        this.checkForUpdates();
        this.lockingManager.unlock(this.lockId);
        this.log.info("Unlocked: " + this.lockId);
        this.banCancel = false;
    }

    public void initializeDefaultProperty(String key, String value) {
        if (key != null && (this.getProperty(key) == null || this.getProperty(key).isEmpty())) {
            this.setProperty(key, value);
        }
    }

    public void initializeDefaultProperties(String[] properties) {
        if (properties != null) {
            int i = 0;
            while (i + 1 < properties.length) {
                String key = properties[i];
                String value = properties[i + 1];
                this.initializeDefaultProperty(key, value);
                i += 2;
            }
        }
    }

    @Override
    public Exception getException() {
        Exception e = this.exception;
        this.exception = null;
        return e;
    }

    protected void deriveTaskProgressFromOldDuration() {
        this.deriveTaskProgressFromDuration(this.getTaskDuration(this.task));
    }

    protected void deriveTaskProgressFromDuration(final long duration) {
        if (duration > 0L) {
            this.progressThread = new Thread(){

                @Override
                public void run() {
                    long runningTime = 0L;
                    do {
                        runningTime = AbstractUpdatePlugin.this.getTaskRunningTime();
                        AbstractUpdatePlugin.this.setTaskProgress(Math.min((double)runningTime / (double)duration, 0.99));
                        try {
                            Thread.sleep(5L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (AbstractUpdatePlugin.this.progressThread == Thread.currentThread() && duration > runningTime && !AbstractUpdatePlugin.this.isInterrupted);
                }
            };
            this.progressThread.start();
        }
        this.setTaskProgress(0.0);
    }

    protected File setTargetDirectory(String path) {
        return this.setTargetDirectory(new File(path));
    }

    protected File setTargetDirectory(File directory) {
        assert (directory != null);
        if (!directory.exists() && !directory.mkdirs()) {
            this.log.error("", new RuntimeException("Can not create folder or parent folder(s) of " + directory));
        } else if (!directory.isDirectory()) {
            this.log.error("", new RuntimeException("The file " + directory.getAbsolutePath() + " is not a directory as expected."));
        } else if (!directory.canWrite()) {
            this.log.error("No write permission at '" + directory.getAbsolutePath() + "'.");
        }
        this.targetDirectory = directory;
        this.log.debug("Target set to " + this.targetDirectory.getAbsolutePath());
        return this.targetDirectory;
    }

    protected File setTargetDirectoryToTmp() {
        return this.setTargetDirectory(PpiToolkit.getTempDirectory());
    }

    protected File setTargetDirectoryToTmp(String subfolder) {
        return this.setTargetDirectory(PpiToolkit.getTempDirectoryPath() + File.separator + subfolder);
    }

    protected File setTargetDirectoryToTmpWithSubfolder() {
        return this.setTargetDirectoryToTmp(this.getClass().getSimpleName());
    }

    protected void prepareTargetDirectory() {
        this.setTargetDirectoryToTmp(this.getClass().getSimpleName());
    }

    protected void setDownloadLengthHint(long length) {
        this.downloadLengthHint = length;
    }

    protected File download(String url) {
        File download = this.download(url, true);
        return download;
    }

    protected File download(String url, boolean handleProgress) {
        this.log.info("Try to download '" + url + "'.");
        if (url.startsWith("ftp://")) {
            return this.downloadViaFtpClient(url, handleProgress);
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return this.downloadViaUrl(url, handleProgress);
        }
        return null;
    }

    protected File downloadViaUrl(String url, boolean handleProgess) {
        this.log.info("Creating new Url-Downloader for '" + url + "'.");
        URLStreamSourceFactory factory = new URLStreamSourceFactory();
        this.downloader = new Downloader(url, factory);
        return this.startDownload(this.downloader, handleProgess);
    }

    protected File downloadViaFtpClient(String url, boolean handleProgress) {
        this.log.info("Creating new Ftp-Downloader for '" + url + "'.");
        FTPStreamSourceFactory factory = new FTPStreamSourceFactory();
        this.downloader = new Downloader(url, factory);
        return this.startDownload(this.downloader, handleProgress);
    }

    protected File downloadViaWget(String url) throws IOException {
        this.prepareTargetDirectory();
        WgetDownloader wgetDownloader = new WgetDownloader(url, this.targetDirectory.getAbsolutePath());
        wgetDownloader.startDownloading();
        while (wgetDownloader.isRunning(10)) {
            if (this.isInterrupted) {
                wgetDownloader.cancel();
            }
            this.taskProgress = wgetDownloader.getProgress();
        }
        return wgetDownloader.getTarget();
    }

    private File startDownload(Downloader downloader, boolean doUIFeedback) {
        this.prepareTargetDirectory();
        downloader.setContentLength(this.downloadLengthHint);
        String description = this.getTaskDescription();
        if (doUIFeedback) {
            this.setTaskDescription("(Initializing download...)");
        }
        downloader.setAbortHandling(Downloader.AbortHandling.RESTORE);
        downloader.setExistanceHandling(Downloader.ExistanceHandling.REPLACE);
        downloader.setTargetDirectory(this.targetDirectory);
        this.log.info("Initializing download...");
        downloader.initializeDownload();
        while (downloader.download() > -1 && !this.isInterrupted) {
            if (!doUIFeedback) continue;
            this.taskProgress = downloader.getProgress();
            this.setTaskDescription(String.format("Downloading %s (%dkb/%dkb)", downloader.getTargetFilename(), downloader.getDownloadedBytes() / 1024L, downloader.getContentLength() / 1024L));
        }
        if (this.isInterrupted) {
            downloader.abort();
        } else if (!downloader.isDone()) {
            this.log.warn("File " + downloader.getTargetFilename() + " could not be downloaded properly.");
        }
        this.setTaskDescription(description);
        File targetFile = downloader.getTargetFile();
        if (PpiToolkit.deleteTmpFilesOnExit() && targetFile != null) {
            targetFile.deleteOnExit();
        }
        return targetFile;
    }

    protected int countingInteractions() {
        this.countedInteractions = 0;
        this.setTaskDescription("Counting interactions.");
        int oldCountedInteractions = -1;
        try {
            oldCountedInteractions = Integer.parseInt(this.getProperty(KEY_INTERACTION_COUNT));
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterable<ProteinInteraction> iterable = this.getInteractionSource();
        if (iterable != null) {
            Iterator<ProteinInteraction> iterator = iterable.iterator();
            if (iterator != null) {
                while (iterator.hasNext() && !this.isInterrupted) {
                    iterator.next();
                    ++this.countedInteractions;
                    this.taskProgress = Math.max(0.0, (double)this.countedInteractions / (double)oldCountedInteractions);
                    this.taskProgress = Math.min(1.0, this.taskProgress);
                    this.setTaskDescription("Counting interactions. (" + this.countedInteractions + ")");
                }
                if (!this.isInterrupted) {
                    this.setProperty(KEY_INTERACTION_COUNT, String.valueOf(this.countedInteractions));
                }
                return this.countedInteractions;
            }
            this.log.error("Could not iterate over protein interactions.");
        } else {
            this.log.error("Returned interaction source was null. May be the source id is unknown.");
        }
        return -1;
    }

    protected void loadingInteractions() throws SQLException {
        int threadCount = 5;
        try {
            Properties piPaProperties = PpiToolkit.getPiPaProperties();
            String loaderThreadCount = piPaProperties.getProperty("ppi.loaderThreadCount");
            threadCount = Integer.parseInt(loaderThreadCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadingInteractionsParallel(threadCount);
    }

    protected void loadingInteractionsUnparallel() throws SQLException {
        Connection connection = this.openDatabaseConnection();
        this.setTaskDescription("Loading Interactions.");
        if (PpiToolkit.isValidSourceId(this.sourceId)) {
            InteractionLoader loader = new InteractionLoader(this.sourceId, connection);
            int processedInteractions = 0;
            Iterable<ProteinInteraction> interactions = this.getInteractionSource();
            for (ProteinInteraction interaction : interactions) {
                if (this.isInterrupted) break;
                try {
                    loader.load(interaction);
                    if (processedInteractions % 1000 == 0) {
                        this.log.info("Inserted " + processedInteractions + " Interactions so far.");
                    }
                }
                catch (LoaderException e) {
                    this.log.info(e.getMessage());
                }
                this.setTaskProgress((double)(++processedInteractions) / (double)this.countedInteractions);
                this.setTaskDescription("Loading Interactions. (" + processedInteractions + "\\" + this.countedInteractions + ")");
            }
        } else {
            this.log.error("Cannot load interaction. Invalid source id: " + (Object)((Object)this.sourceId));
        }
    }

    protected String getFormattedTaskRemainingTime() {
        try {
            if (this.taskStartTime > 0L && this.getTaskProgress() > 0.0) {
                long remainingTime;
                long elapsedTime = this.getTaskRunningTime();
                long estimatedTime = (long)((double)elapsedTime / this.getTaskProgress());
                this.oldRemainingTime = remainingTime = estimatedTime - elapsedTime;
                return Timer.timeToString(this.oldRemainingTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    protected void setTaskProgress(double progress) {
        this.taskProgress = Math.max(0.0, progress);
        this.taskProgress = Math.min(1.0, this.taskProgress);
    }

    @Deprecated
    protected Iterable<ProteinInteraction> getInteractionSourceById() {
        if (PpiToolkit.isValidSourceId(this.sourceId)) {
            return SourceFactory.getInteractionSourceById(this.sourceId);
        }
        this.log.error("Cannot init interaction source. Invalid source id: " + (Object)((Object)this.sourceId));
        return null;
    }

    protected Iterable<ProteinInteraction> getInteractionSource() {
        return null;
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.INTERACTION_DATA;
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    public void extractGZip(String source, String destination) throws IOException {
        this.extractGZip(new File(source), new File(destination));
    }

    public void copyStreams(InputStream input, OutputStream output, long length, String description) throws IOException {
        StreamCopy copy = new StreamCopy(input, output);
        while (copy.copyPieceBoolean() && !this.isInterrupted) {
            this.taskProgress = Math.min((double)copy.getBytesCopied() / (double)length, 1.0);
            this.taskDescription = String.format("%s (%dkb/%dkb)", description, copy.getBytesCopied(), length);
        }
        input.close();
        output.close();
    }

    public void extractGZip(File source, File destination) throws IOException {
        BufferedInputStream input = new BufferedInputStream(new GZIPInputStream(new FileInputStream(source)));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destination));
        long extractedSize = Extract.getUncompressedGZipFileSize(source.getAbsolutePath());
        this.copyStreams(input, output, extractedSize, String.format("Extracting %s ", source.getName()));
    }

    protected void loadingInteractionsParallel(int threadCount) throws SQLException {
        this.setTaskDescription("Loading Interactions.");
        Thread[] workers = new Thread[threadCount];
        if (PpiToolkit.isValidSourceId(this.sourceId)) {
            this.processedInteractions = 0;
            Iterable<ProteinInteraction> interactionSource = this.getInteractionSource();
            Iterator<ProteinInteraction> iterator = interactionSource.iterator();
            for (int i = 0; i < threadCount; ++i) {
                LoaderThread thread = new LoaderThread(iterator);
                workers[i] = thread;
                thread.start();
                this.log.info("Started loadint thread " + thread.getName());
            }
            for (Thread thread : workers) {
                try {
                    thread.join();
                    this.log.info("Thread " + thread.getName() + " done.");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        } else {
            this.log.error("Cannot load interaction. Invalid source id: " + (Object)((Object)this.sourceId));
        }
    }

    public static String shortenUrl(StringBuilder sb, int targetLength) {
        int length = sb.length() - targetLength;
        int start = sb.length() / 2 - length / 2;
        int end = start + length + 3;
        sb.delete(start, end);
        sb.insert(start, "...");
        return sb.toString();
    }

    protected void loadingInteractions(int counted) throws SQLException {
        this.countedInteractions = counted;
        this.loadingInteractions();
    }

    private class LoaderThread
    extends Thread {
        private InteractionLoader loader;
        private Iterator<ProteinInteraction> interactions;
        private Connection connection;

        public LoaderThread(Iterator<ProteinInteraction> interactions) throws SQLException {
            this.connection = AbstractUpdatePlugin.this.openDatabaseConnection();
            this.loader = new InteractionLoader(AbstractUpdatePlugin.this.sourceId, this.connection);
            this.interactions = interactions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProteinInteraction nextInteraction = null;
            Iterator<ProteinInteraction> iterator = this.interactions;
            synchronized (iterator) {
                nextInteraction = this.interactions.hasNext() ? this.interactions.next() : null;
            }
            while (nextInteraction != null && !AbstractUpdatePlugin.this.isInterrupted) {
                try {
                    if (this.loader.load(nextInteraction)) {
                        AbstractUpdatePlugin.this.processedInteractions++;
                        AbstractUpdatePlugin.this.log.info(this.getName() + " inserted " + AbstractUpdatePlugin.this.processedInteractions + " Interactions so far.");
                    }
                }
                catch (LoaderException e) {
                    AbstractUpdatePlugin.this.log.info("", e);
                }
                Iterator<ProteinInteraction> e = this.interactions;
                synchronized (e) {
                    boolean hasNext = this.interactions.hasNext();
                    nextInteraction = hasNext ? this.interactions.next() : null;
                    AbstractUpdatePlugin.this.setTaskProgress((double)AbstractUpdatePlugin.this.processedInteractions / (double)AbstractUpdatePlugin.this.countedInteractions);
                    AbstractUpdatePlugin.this.setTaskDescription("Loading Interactions. (" + AbstractUpdatePlugin.this.processedInteractions + "\\" + AbstractUpdatePlugin.this.countedInteractions + ")");
                }
            }
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
            this.loader = null;
        }
    }
}

