/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.tool.Extract;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.tool.ProgressCounter;
import de.berlin.hu.ppi.tool.StringFilter;
import de.berlin.hu.ppi.tool.StringTransformationMethods;
import de.berlin.hu.ppi.tool.WebSiteParsingException;
import de.berlin.hu.ppi.tool.WebSiteTools;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public abstract class AbstractPathwayUpdatePlugin
extends AbstractUpdatePlugin {
    protected static final int DOWNLOADING = 0;
    protected static final int PARSING_DATA = 1;
    protected static final int LOADING = 2;
    protected static final String KEY_LATEST_UPDATE = "latestUpdate";
    protected Date updateDate;
    protected File target;
    protected StorePathwaysInDB db;
    protected int uniquePathwayId = 0;
    protected CountDownLatch dateFetched = new CountDownLatch(1);
    protected ProgressCounter progressCounter;

    public AbstractPathwayUpdatePlugin() throws Exception {
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading", "Parsing files for organism", "Loading pathway data"};
        this.progressCounter = ProgressCounter.getInstance();
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.PATHWAY_DATA;
    }

    protected abstract Date getUpdateDate();

    @Override
    protected int getCurrentUpdateHash() {
        return this.getUpdateDate().hashCode();
    }

    @Override
    protected void checkForUpdates() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Date lastUpdateDate = AbstractPathwayUpdatePlugin.this.getLastUpdateTime();
                AbstractPathwayUpdatePlugin.this.updateDate = AbstractPathwayUpdatePlugin.this.getUpdateDate();
                AbstractPathwayUpdatePlugin.this.isUpdateAvailable = lastUpdateDate == null || AbstractPathwayUpdatePlugin.this.updateDate != null && lastUpdateDate.before(AbstractPathwayUpdatePlugin.this.updateDate);
                AbstractPathwayUpdatePlugin.this.dateFetched.countDown();
            }
        }).start();
    }

    protected int getCountOfLines(File file) throws IOException {
        LineNumberReader lnr = new LineNumberReader(new BufferedReader(new FileReader(file)));
        while (lnr.readLine() != null) {
        }
        int count = lnr.getLineNumber();
        lnr.close();
        return count;
    }

    public Date determineDate(String delimiter, String url, PpiConstants.DB_ID dbId, String datePattern, int count) throws WebSiteParsingException, InterruptedException, FileParsingException, ParseException {
        WebSiteTools webTool = new WebSiteTools(10000);
        Scanner scanner = webTool.tryToLoadWebSite(url, dbId.name());
        StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter(delimiter), "No date found for: " + dbId.name());
        for (int i = 0; i < count; ++i) {
            StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("\\s+"), "No date found for: " + dbId.name());
        }
        if (dbId == PpiConstants.DB_ID.SPIKE) {
            StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter(">"), "No date found for: " + dbId.name());
        }
        String date = PpiConstants.DB_ID.getPathwayInteractionDatabaseDbs().contains((Object)dbId) ? StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("<"), "No date found for: " + dbId.name()) : (PpiConstants.DB_ID.getPathwayCommonsDbs().contains((Object)dbId) ? StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("\\]"), "No date found for: " + dbId.name()) : StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("M"), "No date found for: " + dbId.name()));
        date = dbId == PpiConstants.DB_ID.SPIKE ? date.substring(1) : (PpiConstants.DB_ID.getPathwayCommonsDbs().contains((Object)dbId) ? date.substring(date.indexOf("[") + 1) : date.substring(delimiter.length()));
        scanner.close();
        return this.parseDate(datePattern, date, dbId);
    }

    protected Date parseDate(String datePattern, String date, PpiConstants.DB_ID dbId) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(datePattern, Locale.ENGLISH);
        Date recent = PpiConstants.DB_ID.getPathwayInteractionDatabaseDbs().contains((Object)dbId) ? df.parse(date.trim()) : df.parse(date.trim().substring(0, datePattern.length()));
        return recent;
    }

    protected int extractZip(File file, StringFilter filter) throws ZipException, IOException {
        return this.extractZip(file, FileTool.asDirectory(file), filter);
    }

    protected int extractZip(File file) throws ZipException, IOException {
        return this.extractZip(file, FileTool.asDirectory(file));
    }

    protected int extractZip(File file, File destination) throws ZipException, IOException {
        return this.extractZip(file, destination, null);
    }

    protected int extractZip(File file, File destination, StringFilter filter) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        int entryCount = 0;
        while (!this.isInterrupted && zipEntries.hasMoreElements() && (filter == null || filter.acceptString(zipEntries.nextElement().getName()))) {
            zipEntries.nextElement();
            ++entryCount;
        }
        this.setCounterFinish(entryCount);
        zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements() && !this.isInterrupted) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (filter != null && !filter.acceptString(zipEntry.getName())) continue;
            String destinationFile = zipEntry.getName();
            destinationFile = destination.getAbsolutePath() + File.separator + destinationFile;
            this.log.info("Extracting: " + zipEntry.getName());
            Extract.extractZipEntry(zipFile, zipEntry, destinationFile);
            this.incrementCounter();
        }
        zipFile.close();
        return entryCount;
    }
}

