/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import de.berlin.hu.ppi.tool.WebSiteParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.regex.Pattern;

public class WebSiteTools {
    private int sleepTime;
    private int startSleepTime;

    public WebSiteTools(int sleepTime) {
        this.sleepTime = sleepTime;
        this.startSleepTime = sleepTime;
    }

    public URLConnection provideConnection(String url) throws MalformedURLException, IOException {
        URL u = new URL(url);
        URLConnection uc = u.openConnection();
        uc.setConnectTimeout(this.sleepTime);
        uc.setReadTimeout(this.sleepTime * 4);
        return uc;
    }

    public Scanner checkPageCorrectness(String startDelim, String endDelim, String occurence, String url, String id) throws InterruptedException, WebSiteParsingException {
        int invokeCount = 0;
        Pattern start = Pattern.compile(startDelim, 2);
        Pattern end = Pattern.compile(endDelim, 2);
        Scanner scan = null;
        while (invokeCount < 10) {
            try {
                URLConnection uc = this.provideConnection(url);
                scan = new Scanner(new BufferedReader(new InputStreamReader(uc.getInputStream())));
                scan.useDelimiter(start);
                if (scan.hasNext()) {
                    String compare;
                    scan.next();
                    scan.useDelimiter(end);
                    if (scan.hasNext() && (compare = scan.next().substring(startDelim.length()).trim()).equalsIgnoreCase(occurence)) {
                        scan.reset();
                        return scan;
                    }
                }
                if (scan != null) {
                    scan.close();
                }
                ++invokeCount;
                Thread.sleep(this.sleepTime);
            }
            catch (IOException e) {
                ++invokeCount;
            }
            catch (InterruptedException e) {
                throw new InterruptedException("Tiggered by " + id + " | " + e.getMessage());
            }
        }
        throw new WebSiteParsingException("checkPageCorrectness failed for: " + id);
    }

    public Scanner tryToLoadWebSite(String url, String id) throws InterruptedException, WebSiteParsingException {
        Scanner scan = null;
        for (int invokeCount = 0; invokeCount < 10; ++invokeCount) {
            try {
                URLConnection uc = this.provideConnection(url);
                scan = new Scanner(new BufferedReader(new InputStreamReader(uc.getInputStream())));
                return scan;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(this.sleepTime);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new InterruptedException("Triggered by " + id + " | " + e.getMessage());
                }
            }
        }
        throw new WebSiteParsingException("tryToLoadWebSite failed for: " + id);
    }

    public static BufferedReader getUrlContent(String url) throws MalformedURLException, IOException {
        return new BufferedReader(new InputStreamReader(new URL(url).openStream()));
    }
}

