/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.mediator.dbx.DBConnectionProvider;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class UniprotTaxIdPlugin
extends AbstractUpdatePlugin {
    private static final String FTP_SPEZIES_FILE = "ftp://ftp.uniprot.org/pub/databases/uniprot/knowledgebase/docs/speclist.txt";
    private static UpdatePlugin instance = null;
    private static final int DOWNLOADING = 0;
    private static final int PARSING_DATA = 1;
    private static final int LOADING = 2;
    private static final String TMP_DIR = "tmp_uniprot_taxon";
    private static final String FTP_URL = "ftp.uniprot.org";
    private static final String FTP_DIRECTORY = "pub/databases/uniprot/knowledgebase/docs";
    private static final String FTP_FILE = "speclist.txt";
    private static final String KEY_LATEST_UPDATE = "latestUpdate";
    private DBConnectionProvider service;
    private Connection connection;
    private Map<String, Integer> knownTaxonIds;
    private Map<String, Integer> newTaxonIds;
    private static final Object sync = new Object();
    private Set<String> organismsWithoutTaxIds;
    private PreparedStatement selectOrganismFromLookupTable;
    private Date update;

    private UniprotTaxIdPlugin(DBConnectionProvider service) throws Exception {
        FileTool.deleteDirectoryRecursive(new File(TMP_DIR));
        this.pluginName = "UniProt Species Taxon Id Mapping";
        this.description = "This plugin updates the lookup table for species taxon id mapping.";
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading", "Parsing", "Loading"};
        this.knownTaxonIds = new HashMap<String, Integer>();
        this.service = service == null ? DbService.getCurrentService() : service;
        this.connection = this.service.getNewConnection();
        Statement stmt = this.connection.createStatement();
        ResultSet result = stmt.executeQuery("SELECT name, taxon_id FROM organism_taxonomy");
        while (result.next()) {
            this.knownTaxonIds.put(result.getString(1), result.getInt(2));
        }
        this.selectOrganismFromLookupTable = this.connection.prepareStatement("SELECT taxon_id FROM lookup_organism_taxonomy WHERE name LIKE ?");
        this.newTaxonIds = new HashMap<String, Integer>();
        this.organismsWithoutTaxIds = new HashSet<String>();
        this.checkForUpdates();
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.LOOKUP_TABLES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdatePlugin getInstance() throws Exception {
        Object object = sync;
        synchronized (object) {
            if (instance == null) {
                instance = new UniprotTaxIdPlugin(null);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdatePlugin getInstance(DBConnectionProvider service) throws Exception {
        Object object = sync;
        synchronized (object) {
            if (instance == null) {
                instance = new UniprotTaxIdPlugin(service);
            }
        }
        return instance;
    }

    public synchronized Integer getTaxonIdForOrganism(String organism) throws SQLException {
        ResultSet result;
        if (organism == null) {
            return null;
        }
        if (this.knownTaxonIds.containsKey(organism)) {
            return this.knownTaxonIds.get(organism);
        }
        if (this.newTaxonIds.containsKey(organism)) {
            return this.newTaxonIds.get(organism);
        }
        if (this.organismsWithoutTaxIds.contains(organism)) {
            return null;
        }
        String[] tmp = organism.split("\\s+");
        StringBuilder organismPattern = new StringBuilder();
        organismPattern.append("%");
        for (String t : tmp) {
            organismPattern.append(t);
            organismPattern.append("%");
        }
        int index = organismPattern.length();
        do {
            this.selectOrganismFromLookupTable.setString(1, organismPattern.substring(0, index));
            result = this.selectOrganismFromLookupTable.executeQuery();
            index = organismPattern.lastIndexOf("%", index - 1);
        } while (!result.next() && index != -1);
        result.beforeFirst();
        if (result.next()) {
            int id = result.getInt(1);
            if (result.next()) {
                this.organismsWithoutTaxIds.add(organism);
                return null;
            }
            result.close();
            this.newTaxonIds.put(organism, id);
            return id;
        }
        this.organismsWithoutTaxIds.add(organism);
        return null;
    }

    public synchronized void loadNewTaxonIdsForOrganismsIntoDb() throws Exception {
        if (this.newTaxonIds.size() > 0) {
            this.connection = this.service.getNewConnection();
            ResultSet newTaxIdsInDb = this.connection.createStatement().executeQuery("SELECT name FROM organism_taxonomy");
            while (newTaxIdsInDb.next()) {
                String knownOrganism = newTaxIdsInDb.getString(1);
                if (!this.newTaxonIds.containsKey(knownOrganism)) continue;
                this.knownTaxonIds.put(knownOrganism, this.newTaxonIds.remove(knownOrganism));
            }
            if (this.newTaxonIds.size() > 0) {
                PreparedStatement loadIntoDB = this.connection.prepareStatement("INSERT INTO organism_taxonomy (name, taxon_id) VALUES (?, ?)");
                ArrayList<String> known = new ArrayList<String>();
                for (String organism : this.newTaxonIds.keySet()) {
                    loadIntoDB.setString(1, organism);
                    loadIntoDB.setInt(2, this.newTaxonIds.get(organism));
                    loadIntoDB.executeUpdate();
                    known.add(organism);
                }
                for (String organism : known) {
                    this.knownTaxonIds.put(organism, this.newTaxonIds.remove(organism));
                }
            }
            this.connection.close();
        }
    }

    public Integer getCollectedTaxonIdForOrganism(String organism) {
        if (this.knownTaxonIds.containsKey(organism)) {
            return this.knownTaxonIds.get(organism);
        }
        if (this.newTaxonIds.containsKey(organism)) {
            return this.newTaxonIds.get(organism);
        }
        return null;
    }

    @Override
    protected void runUpdate() throws Exception {
        File file = null;
        if (!this.isInterrupted) {
            this.startTask(0);
            File dir = new File(TMP_DIR);
            this.setTargetDirectory(dir);
            if (!dir.exists()) {
                this.log.error("Temporary directory for parsing uniprot files could not be created.");
                throw new IOException("Temporary directory for parsing uniprot files could not be created.");
            }
            file = this.downloadViaUrl(FTP_SPEZIES_FILE, true);
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.parseFile(file);
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            Connection connection = this.openDatabaseConnection();
            connection.setAutoCommit(false);
            connection.createStatement().executeUpdate("DELETE FROM lookup_organism_taxonomy");
            PreparedStatement loadIntoDB = connection.prepareStatement("INSERT INTO lookup_organism_taxonomy (name, taxon_id) VALUES (?, ?)");
            this.setCounterFinish(this.knownTaxonIds.keySet().size());
            for (String organism : this.knownTaxonIds.keySet()) {
                if (this.isInterrupted) {
                    return;
                }
                loadIntoDB.setString(1, organism);
                loadIntoDB.setInt(2, this.knownTaxonIds.get(organism));
                loadIntoDB.executeUpdate();
                this.incrementCounter();
            }
            this.setUpdateTime(KEY_LATEST_UPDATE, this.update);
        }
        FileTool.deleteDirectoryRecursive(new File(TMP_DIR));
    }

    private void parseFile(File file) throws IOException {
        this.knownTaxonIds = new HashMap<String, Integer>();
        Scanner scanner = new Scanner(new BufferedReader(new FileReader(file)));
        Pattern start = Pattern.compile("S=Synonym", 2);
        scanner.useDelimiter(start);
        if (!scanner.hasNext()) {
            throw new FileParsingException();
        }
        scanner.next();
        scanner.nextLine();
        scanner.nextLine();
        this.setCounterFinish(FileTool.countLines1(file));
        Integer lastTaxId = null;
        while (scanner.hasNextLine() && !this.isInterrupted) {
            String[] values = scanner.nextLine().split(":");
            if (values.length == 1) {
                values[0] = values[0].trim();
                if (values[0].startsWith("C=") || values[0].startsWith("S=")) {
                    if (lastTaxId == null) {
                        System.out.println(values[0].substring(values[0].indexOf("=") + 1) + ":::" + lastTaxId);
                    }
                    this.knownTaxonIds.put(values[0].substring(values[0].indexOf("=") + 1), lastTaxId);
                }
            }
            if (values.length == 2 && !values[1].startsWith("/")) {
                lastTaxId = Integer.valueOf(values[0].substring(values[0].lastIndexOf(" ") + 1));
                if (lastTaxId == null) {
                    System.out.println(values[1].substring(values[1].indexOf("=") + 1) + ":::" + lastTaxId);
                }
                this.knownTaxonIds.put(values[1].substring(values[1].indexOf("=") + 1), lastTaxId);
            }
            this.incrementCounter();
        }
        scanner.close();
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        this.update = this.getUpdateDate();
        return Long.valueOf(this.update.getTime()).hashCode();
    }

    private Date getUpdateDate() {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(FTP_URL);
            ftp.login("anonymous", "email@aol.com");
            ftp.enterLocalPassiveMode();
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp.disconnect();
                System.err.println("FTP server refused connection.");
                return null;
            }
            ftp.changeWorkingDirectory(FTP_DIRECTORY);
            FTPFile[] file = ftp.listFiles(FTP_FILE);
            if (file.length != 0) {
                return file[0].getTimestamp().getTime();
            }
            System.err.println("File could not be found");
            return null;
        }
        catch (SocketException e) {
            this.log.warn("", e);
        }
        catch (IOException e) {
            this.log.warn("", e);
        }
        return null;
    }
}

