/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class UniprotAccessionNumbersPlugin
extends AbstractUpdatePlugin {
    private static UpdatePlugin instance = null;
    private static final String SECONDARY_ACCESSION_NUMBERS = "ftp://ftp.uniprot.org/pub/databases/uniprot/knowledgebase/docs/sec_ac.txt";
    public static final String ACCESSION_INDEX = "ftp://ftp.uniprot.org/pub/databases/uniprot/knowledgebase/docs/acindex.txt";
    private static final String FTP_URL = "ftp.uniprot.org";
    private static final String FTP_DIRECTORY = "pub/databases/uniprot/knowledgebase/docs";
    private static final String FTP_FILE1 = "acindex.txt";
    private static final String FTP_FILE2 = "sec_ac.txt";
    private static final String TMP_DIR = "tmp_uniprot";
    private static final String KEY_LATEST_UPDATE = "latestUpdate";
    private static final String KEY_LAST_UPDATE_UNIPROT_ACCESSION = "UniprotAccession.latestUpdate";
    private static final String KEY_LAST_UPDATE_UNIPROT_SECONDARY_ACCESSION = "UniprotSecondaryAccession.latestUpdate";
    private Set<String> accessionIndex;
    private Map<String, String> secondaryAccessionIndex;
    private Map<String, UpdateInfo> updateInfo;

    private UniprotAccessionNumbersPlugin() throws Exception {
        FileTool.deleteDirectoryRecursive(new File(TMP_DIR));
        this.pluginName = "UniProt Accession Numbers";
        this.description = "This plugin updates the lookup tables for uniprot accession numbers.";
        this.taskCount = 6;
        this.updateInfo = new HashMap<String, UpdateInfo>();
        this.accessionIndex = new HashSet<String>();
        this.secondaryAccessionIndex = new HashMap<String, String>();
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new UniprotAccessionNumbersPlugin();
        }
        return instance;
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.LOOKUP_TABLES;
    }

    @Override
    protected void runUpdate() throws Exception {
        for (String key : this.updateInfo.keySet()) {
            int size;
            File file = null;
            if (this.isInterrupted) {
                return;
            }
            this.setTaskDescription("Downloading");
            this.startNextTask();
            this.setTargetDirectoryToTmp();
            file = key.equals(KEY_LAST_UPDATE_UNIPROT_ACCESSION) ? this.downloadViaUrl(ACCESSION_INDEX, true) : this.downloadViaUrl(SECONDARY_ACCESSION_NUMBERS, true);
            if (this.isInterrupted) {
                return;
            }
            this.startNextTask();
            this.setTaskDescription("Parsing data");
            if (key.equals(KEY_LAST_UPDATE_UNIPROT_ACCESSION)) {
                this.parseAccessionIndex(file);
            } else {
                this.parseSecondaryIds(file);
            }
            if (this.isInterrupted) {
                return;
            }
            this.startNextTask();
            this.setTaskDescription("Loading data");
            if (this.connection == null) {
                this.connection = DbService.getCurrentService().getNewConnection();
                this.connection.setAutoCommit(false);
            }
            if (key.equals(KEY_LAST_UPDATE_UNIPROT_ACCESSION)) {
                this.connection.createStatement().executeUpdate("DELETE FROM lookup_uniprot_accession");
                PreparedStatement insertAccessionNumber = this.connection.prepareStatement("INSERT INTO lookup_uniprot_accession (id) VALUES (?)");
                size = this.accessionIndex.size();
                this.setCounterFinish(size);
                for (String id : this.accessionIndex) {
                    if (this.isInterrupted) break;
                    insertAccessionNumber.setString(1, id);
                    insertAccessionNumber.executeUpdate();
                    this.incrementCounter();
                }
                this.setUpdateTime(KEY_LAST_UPDATE_UNIPROT_ACCESSION, this.updateInfo.get((Object)KEY_LAST_UPDATE_UNIPROT_ACCESSION).updateDate);
                continue;
            }
            this.connection.createStatement().executeUpdate("DELETE FROM lookup_uniprot_secondary_accession_mapping");
            PreparedStatement insertAccessionNumberMapping = this.connection.prepareStatement("INSERT INTO lookup_uniprot_secondary_accession_mapping (secondary_id, primary_id) VALUES (?,?)");
            size = this.secondaryAccessionIndex.keySet().size();
            this.setCounterFinish(size);
            for (String secondaryId : this.secondaryAccessionIndex.keySet()) {
                if (this.isInterrupted) break;
                insertAccessionNumberMapping.setString(1, secondaryId);
                insertAccessionNumberMapping.setString(2, this.secondaryAccessionIndex.get(secondaryId));
                insertAccessionNumberMapping.executeUpdate();
                this.incrementCounter();
            }
            this.setUpdateTime(KEY_LAST_UPDATE_UNIPROT_SECONDARY_ACCESSION, this.updateInfo.get((Object)KEY_LAST_UPDATE_UNIPROT_SECONDARY_ACCESSION).updateDate);
        }
    }

    private void parseAccessionIndex(File acIndex) throws IOException {
        long numLines = FileTool.countLines1(acIndex);
        this.setCounterFinish(numLines);
        Scanner scanner = new Scanner(new BufferedReader(new FileReader(acIndex)));
        Pattern start = Pattern.compile("number\\s+name\\(s\\)", 2);
        scanner.useDelimiter(start);
        if (!scanner.hasNext()) {
            throw new FileParsingException();
        }
        scanner.next();
        scanner.nextLine();
        scanner.nextLine();
        while (scanner.hasNextLine() && !this.isInterrupted) {
            String[] values = scanner.nextLine().split("\\s+");
            if (values.length == 2) {
                this.accessionIndex.add(values[0]);
            }
            this.incrementCounter();
        }
        scanner.close();
    }

    private void parseSecondaryIds(File secondaryIds) throws IOException {
        long size = FileTool.countLines1(secondaryIds);
        this.setCounterFinish(size);
        Scanner scanner = new Scanner(new BufferedReader(new FileReader(secondaryIds)));
        Pattern start = Pattern.compile("secondary ac\\s+primary ac", 2);
        scanner.useDelimiter(start);
        if (!scanner.hasNext()) {
            throw new FileParsingException();
        }
        scanner.next();
        scanner.nextLine();
        scanner.nextLine();
        while (scanner.hasNextLine() && !this.isInterrupted) {
            String[] values = scanner.nextLine().split("\\s+");
            if (values.length == 2) {
                if (values[0].length() != 6 || values[1].length() != 6) {
                    System.err.println(values[0] + " " + values[1]);
                }
                this.secondaryAccessionIndex.put(values[0], values[1]);
            }
            this.incrementCounter();
        }
        scanner.close();
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        this.getUpdateDate();
        ArrayList<Long> times = new ArrayList<Long>();
        for (String key : Arrays.asList(KEY_LAST_UPDATE_UNIPROT_ACCESSION, KEY_LAST_UPDATE_UNIPROT_SECONDARY_ACCESSION)) {
            Date lastUpdateDate = this.getUpdateTime(key);
            UpdateInfo ui = this.updateInfo.get(key);
            Date updateDate = ui.updateDate;
            long time = updateDate.getTime();
            times.add(time);
            if (lastUpdateDate != null && (updateDate == null || !lastUpdateDate.before(updateDate))) continue;
            ui.updateAvailable = true;
        }
        return ((Object)times).hashCode();
    }

    private void getUpdateDate() {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(FTP_URL);
            ftp.login("anonymous", "email@aol.com");
            ftp.enterLocalPassiveMode();
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp.disconnect();
                System.err.println("FTP server refused connection.");
                return;
            }
            ftp.changeWorkingDirectory(FTP_DIRECTORY);
            for (int i = 0; i < 2; ++i) {
                String key;
                String ftpFile;
                if (i == 0) {
                    ftpFile = FTP_FILE1;
                    key = KEY_LAST_UPDATE_UNIPROT_ACCESSION;
                } else {
                    ftpFile = FTP_FILE2;
                    key = KEY_LAST_UPDATE_UNIPROT_SECONDARY_ACCESSION;
                }
                FTPFile[] file = ftp.listFiles(ftpFile);
                if (file.length != 0) {
                    this.updateInfo.put(key, new UpdateInfo(file[0].getTimestamp().getTime()));
                    continue;
                }
                System.err.println("File could not be found");
                this.updateInfo.put(key, null);
            }
        }
        catch (SocketException e) {
            this.log.warn("", e);
        }
        catch (IOException e) {
            this.log.warn("", e);
        }
    }

    public void loadDataFromDatabase(Connection connection) throws Exception {
        this.accessionIndex = new HashSet<String>();
        this.secondaryAccessionIndex = new HashMap<String, String>();
        ResultSet result = connection.createStatement().executeQuery("SELECT id FROM lookup_uniprot_accession");
        while (result.next()) {
            this.accessionIndex.add(result.getString(1));
        }
        result = connection.createStatement().executeQuery("SELECT secondary_id, primary_id FROM lookup_uniprot_secondary_accession_mapping");
        while (result.next()) {
            this.secondaryAccessionIndex.put(result.getString(1), result.getString(2));
        }
        connection.close();
    }

    public String getPrimaryUniprotId(String secondaryUniprotId) {
        String primaryUniprotId = this.secondaryAccessionIndex.get(secondaryUniprotId);
        if (primaryUniprotId == null) {
            if (this.accessionIndex.contains(secondaryUniprotId)) {
                return secondaryUniprotId;
            }
            return null;
        }
        return primaryUniprotId;
    }

    protected class UpdateInfo {
        public Date updateDate;
        public boolean updateAvailable;

        public UpdateInfo(Date updateDate) {
            this.updateDate = updateDate;
        }
    }
}

