/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadPoolManager<TASK extends Callable<RESULT>, RESULT> {
    ExecutorService pool;
    ExecutorCompletionService<RESULT> complete;
    List<Future<RESULT>> futures;
    int count;
    int threadPoolSize;

    public ThreadPoolManager(int threadPoolSize) {
        this.pool = Executors.newFixedThreadPool(threadPoolSize);
        this.complete = new ExecutorCompletionService(this.pool);
        this.futures = new ArrayList<Future<RESULT>>();
        this.count = 0;
        this.threadPoolSize = threadPoolSize;
    }

    public Future<RESULT> addTask(TASK task) throws InterruptedException {
        this.futures.add(this.complete.submit((Callable<RESULT>)task));
        ++this.count;
        if (this.count == this.threadPoolSize) {
            Future<RESULT> tmp = this.complete.take();
            this.futures.remove(tmp);
            --this.count;
            return tmp;
        }
        return null;
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    public int getFuturesSize() {
        return this.futures.size();
    }

    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    public void removeRemainingTasks() throws InterruptedException {
        while (this.futures.size() > 0) {
            Future<RESULT> tmp = this.complete.take();
            this.futures.remove(tmp);
        }
    }

    public Future<RESULT> popResult() throws InterruptedException {
        Future<RESULT> tmp = this.complete.take();
        this.futures.remove(tmp);
        return tmp;
    }
}

