/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import de.berlin.hu.ppi.parser.FileParsingException;
import java.util.Scanner;

public final class StringTransformationMethods {
    public static boolean isNumber(char character) {
        return character > '/' && character < ':';
    }

    private static int determineStart(String buffer) {
        if (buffer == null) {
            return -1;
        }
        int start = 0;
        if (buffer.charAt(0) == '-') {
            start = 1;
        }
        return start;
    }

    private static int determineIntPart(String buffer, int start, int length) throws NumberFormatException {
        int value = 0;
        for (int i = start; i < length; ++i) {
            if (!StringTransformationMethods.isNumber(buffer.charAt(i))) {
                throw new NumberFormatException();
            }
            value = 10 * value + (buffer.charAt(i) - 48);
        }
        return value;
    }

    public static int strtoint(String buffer) throws NumberFormatException {
        int start = StringTransformationMethods.determineStart(buffer);
        if (start == -1) {
            return 0;
        }
        int value = StringTransformationMethods.determineIntPart(buffer, start, buffer.length());
        if (start == 1) {
            value *= -1;
        }
        return value;
    }

    public static double strtodouble(String buffer) throws NumberFormatException {
        int start = StringTransformationMethods.determineStart(buffer);
        if (start == -1) {
            return 0.0;
        }
        int position = buffer.indexOf(44);
        if (position == -1) {
            position = buffer.indexOf(46);
        }
        double value = 0.0;
        if (position == -1) {
            value = StringTransformationMethods.determineIntPart(buffer, start, buffer.length());
        } else {
            value = StringTransformationMethods.determineIntPart(buffer, start, position);
            for (int i = position + 1; i < buffer.length(); ++i) {
                if (StringTransformationMethods.isNumber(buffer.charAt(i))) {
                    value += (double)(buffer.charAt(i) - 48) * Math.pow(10.0, position - i);
                    continue;
                }
                throw new NumberFormatException();
            }
        }
        if (start == 1) {
            value *= -1.0;
        }
        return value;
    }

    public static String processToNextDelimiter(Scanner scanner, String message) throws FileParsingException {
        if (!scanner.hasNext()) {
            throw new FileParsingException(message);
        }
        return scanner.next();
    }

    public static String removeUnecessaryStuffAndCutOff(String tmp, int length) {
        tmp = tmp.replaceAll("&.+?;", "");
        if ((tmp = tmp.replaceAll("(name copied from entity in Homo sapiens)", "")).length() > length) {
            System.err.println("Had to cut: " + tmp);
            tmp = tmp.substring(0, length - 1);
            System.err.println("\tresult: " + tmp);
        }
        return tmp;
    }

    public static boolean isEmptyOrBlank(String str) {
        return str == null || str.trim().isEmpty();
    }
}

