/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopy {
    BufferedInputStream input;
    BufferedOutputStream output;
    byte[] buf = new byte[4095];
    long bytesCopied = 0L;

    public static void copyStreams(InputStream input, OutputStream output) throws IOException {
        new StreamCopy(input, output).copy();
    }

    public StreamCopy(InputStream input, OutputStream output, int internalBufferSize) {
        this.input = new BufferedInputStream(input);
        this.output = new BufferedOutputStream(output);
        this.buf = new byte[internalBufferSize];
    }

    public StreamCopy(InputStream input, OutputStream output) {
        this(input, output, 4095);
    }

    public int copyPieceInt() throws IOException {
        int len = this.input.read(this.buf);
        if (len > 0) {
            this.output.write(this.buf, 0, len);
            this.bytesCopied += (long)len;
        } else {
            this.output.flush();
        }
        return len;
    }

    public boolean copyPieceBoolean() throws IOException {
        return this.copyPieceInt() > 0;
    }

    public void setBufferSize(int size) {
        this.buf = new byte[size];
    }

    public void copy() throws IOException {
        while (this.copyPieceBoolean()) {
        }
    }

    public long getBytesCopied() {
        return this.bytesCopied;
    }
}

