/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

public class ProgressCounter {
    private static ProgressCounter instance = null;
    private long[] counters = new long[PATHWAY_PLUGIN_ID.getCountOfPathwayPlugins()];
    private long[] limits = new long[PATHWAY_PLUGIN_ID.getCountOfPathwayPlugins()];

    private ProgressCounter() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = 0L;
        }
    }

    public static ProgressCounter getInstance() {
        if (instance == null) {
            instance = new ProgressCounter();
        }
        return instance;
    }

    public void incrementCounter(PATHWAY_PLUGIN_ID id) {
        int n = id.ordinal();
        this.counters[n] = this.counters[n] + 1L;
    }

    public long getCounter(PATHWAY_PLUGIN_ID id) {
        return this.counters[id.ordinal()];
    }

    public void resetCounter(PATHWAY_PLUGIN_ID id) {
        this.counters[id.ordinal()] = 0L;
    }

    public long getLimit(PATHWAY_PLUGIN_ID id) {
        return this.limits[id.ordinal()];
    }

    public void setLimit(PATHWAY_PLUGIN_ID id, long limit) {
        this.limits[id.ordinal()] = limit;
    }

    public static enum PATHWAY_PLUGIN_ID {
        BIOCYC,
        INOH,
        KEGG,
        PATHWAY_COMMONS,
        PATHWAY_INTERACTION_DATABASE,
        REACTOME,
        SPIKE;


        public static int getCountOfPathwayPlugins() {
            return SPIKE.ordinal() + 1;
        }
    }
}

