/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

public class InputStreamTool {
    public static byte[] readBeginning(InputStream input, byte[] destination) throws IOException {
        if (destination != null && destination.length > 0) {
            int length = 0;
            for (int offset = 0; offset < destination.length && length != -1; offset += length) {
                length = input.read(destination, offset, destination.length - offset);
            }
        }
        return destination;
    }

    public static int getBeginningHashCode(InputStream input, int length) throws IOException {
        return Arrays.hashCode(InputStreamTool.readBeginning(input, new byte[length]));
    }

    public static long countCharacter(InputStream input, char c) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        byte[] buf = new byte[4095];
        int i = in.read(buf);
        long numLines = 0L;
        while (i > 0) {
            for (int j = 0; j < i; ++j) {
                if (buf[j] != c) continue;
                ++numLines;
            }
            i = in.read(buf);
        }
        in.close();
        return numLines;
    }

    public static long countLines(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = reader.readLine();
        long count = 0L;
        while (line != null) {
            ++count;
            line = reader.readLine();
        }
        return count;
    }
}

