/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import de.berlin.hu.ppi.tool.InputStreamTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FileTool {
    public static final Comparator<File> FILE_DATE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return (int)((o2.lastModified() - o1.lastModified()) / 86400000L);
        }
    };

    private FileTool() {
    }

    public static File asDirectory(File file) {
        if (!file.isDirectory()) {
            String path = file.getAbsolutePath();
            file = new File(path.substring(0, path.lastIndexOf(46)));
            return file;
        }
        return file;
    }

    public static void listAllFiles(File file, FilenameFilter filter, List<File> target) {
        for (File subFile : file.listFiles(filter)) {
            if (subFile.isDirectory()) {
                FileTool.listAllFiles(subFile, filter, target);
                continue;
            }
            target.add(subFile);
        }
    }

    public static List<File> listAllFiles(File file, FilenameFilter filter) {
        ArrayList<File> target = new ArrayList<File>();
        FileTool.listAllFiles(file, filter, target);
        return target;
    }

    public static List<File> listAllFiles(File file) {
        ArrayList<File> target = new ArrayList<File>();
        FileTool.listAllFiles(file, null, target);
        return target;
    }

    public static boolean deleteDirectoryRecursive(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                if (FileTool.deleteDirectoryRecursive(new File(dir, children[i]))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static long countLines1(File file) throws IOException {
        return InputStreamTool.countCharacter(new FileInputStream(file), '\n');
    }
}

