/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import de.berlin.hu.ppi.tool.Timer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Scanner;

public class FastLineCounter {
    public static int bufSize = 100000;

    public static void main(String[] args) throws IOException {
        Timer t = Timer.startTimer();
        System.out.println(FastLineCounter.countLinesFast("/vol/fob-vol5/mi06/arzt/Desktop/omim/omim.txt"));
        t.print("");
    }

    public static int countOccurrences(byte[] template, byte[] pattern) {
        int count = 0;
        int finish = template.length - pattern.length + 1;
        for (int i = 0; i < finish; ++i) {
            int j;
            for (j = 0; j < pattern.length && template[i + j] == pattern[j]; ++j) {
            }
            if (j != pattern.length) continue;
            ++count;
        }
        return count;
    }

    public static MappedByteBuffer getMappedByteBuffer(String path) throws IOException {
        File file = new File(path);
        FileChannel ch = new FileInputStream(file).getChannel();
        MappedByteBuffer mb = ch.map(FileChannel.MapMode.READ_ONLY, 0L, ch.size());
        return mb;
    }

    public static int countLinesFast(String path) throws IOException {
        MappedByteBuffer mb = FastLineCounter.getMappedByteBuffer(path);
        byte[] array = new byte[bufSize];
        int count = 0;
        while (mb.hasRemaining()) {
            int n = Math.min(mb.remaining(), bufSize);
            mb.get(array, 0, n);
            count += FastLineCounter.countOccurrences(array, "\n".getBytes());
        }
        return count;
    }

    public static int countLinesSlow(String path) throws FileNotFoundException {
        Scanner scan = new Scanner(new File(path));
        int output = 0;
        while (scan.hasNextLine()) {
            ++output;
            scan.nextLine();
        }
        return output;
    }
}

