/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.tool;

import de.berlin.hu.ppi.tool.StreamCopy;
import de.berlin.hu.ppi.tool.Timer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class Extract {
    public static Logger log = Logger.getLogger(Extract.class);

    public static long getUncompressedGZipFileSize(String file) {
        String cmd = "gzip -l " + file;
        long uncompressedSize = -1L;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            reader.readLine();
            String line = reader.readLine();
            String[] splitted = line.split("[ ]+");
            uncompressedSize = Long.parseLong(splitted[2]);
        }
        catch (IOException e) {
            uncompressedSize = (long)((double)new File(file).length() * 5.344515038158303);
        }
        return uncompressedSize;
    }

    public static void extractZipFile(File file) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(file);
        String parentDirectory = file.getParent();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            System.out.println(zipEntry);
            if (!zipEntry.getName().toLowerCase().endsWith("2.owl")) continue;
            String dirName = zipEntry.getName();
            File dir = new File(parentDirectory + "/" + dirName.substring(0, dirName.lastIndexOf("/")));
            if (!dir.exists() && !dir.mkdirs()) {
                log.error("BioCycPathwayUpdatePlugin: A subdirectory in the temporary directory for extracting biocyc xml files could not be created.");
            }
            Extract.extractZipEntry(zipFile, zipEntry, parentDirectory + File.separator + zipEntry.getName());
        }
        zipFile.close();
    }

    public static void copyInputStreamToFile(InputStream input, String filename) throws FileNotFoundException, IOException {
        File file = new File(filename);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            log.error("", new IOException("Cannot create file " + filename));
        }
        StreamCopy.copyStreams(input, new FileOutputStream(file));
        input.close();
    }

    public static void extractZipEntry(ZipFile zipFile, ZipEntry zipEntry, String destination) throws IOException {
        InputStream input = zipFile.getInputStream(zipEntry);
        Extract.copyInputStreamToFile(input, destination);
    }

    public static void extractGZipFile(String file, String destination) throws FileNotFoundException, IOException {
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(file));
        FileOutputStream output = new FileOutputStream(destination);
        StreamCopy.copyStreams(in, output);
        in.close();
    }

    public static void extractGZipFileLinux(String file) throws IOException, InterruptedException {
        Timer t = Timer.startTimer();
        Process p = Runtime.getRuntime().exec("gunzip " + file);
        p.waitFor();
        System.out.println(t.stop());
    }
}

