/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.statistics;

import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.statistics.Statistics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Deprecated
public class StatisticsOld
implements Statistics {
    private Map<String, Map<String, String>> parsedData;
    private Map<String, Map<String, String>> infos;
    private Map<String, List<String>> sectionSubsectionMap;
    private List<String> sections;
    private Logger log = Logger.getLogger(StatisticsOld.class);
    public static final String STANDARD_FILE = "statistics.conf";

    public StatisticsOld() {
        this.parsedData = new HashMap<String, Map<String, String>>();
        this.infos = new HashMap<String, Map<String, String>>();
        this.sectionSubsectionMap = new HashMap<String, List<String>>();
        this.sections = new ArrayList<String>();
    }

    @Override
    public Iterable<String> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    @Override
    public Iterable<String> getSubsections(String section) {
        return Collections.unmodifiableList(this.sectionSubsectionMap.get(section));
    }

    public String getQuery(String section, String subsection) {
        return this.parsedData.get(section).get(subsection);
    }

    @Override
    public String getResult(String section, String subsection) {
        String output = "empty";
        try {
            Statement statement = DbService.getCurrentService().getStaticStatement();
            ResultSet result = statement.executeQuery(this.getQuery(section, subsection));
            if (!result.isClosed() && result.next()) {
                String resultString = result.getString(1);
                NumberFormat format = NumberFormat.getInstance();
                format.setMaximumFractionDigits(2);
                format.setMinimumFractionDigits(2);
                output = format.format(Double.parseDouble(resultString));
                result.close();
            }
        }
        catch (SQLException e) {
            this.log.error("", e);
            output = "InvalidQuery";
        }
        catch (Exception e) {
            output = "";
        }
        return output;
    }

    public void loadQueriesFromFile(File file) {
        try {
            this.parseQueries(new BufferedReader(new FileReader(file)));
        }
        catch (FileNotFoundException e) {
            this.log.error("", e);
        }
    }

    public void loadQueriesFromRessource(String ressourceName) {
        InputStream input = ClassLoader.getSystemResourceAsStream(ressourceName);
        this.parseQueries(new BufferedReader(new InputStreamReader(input)));
    }

    public void parseQueries(BufferedReader reader) {
        String currentSection = "";
        String currentSubsection = "";
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("#") && !line.isEmpty()) {
                    if (line.startsWith("\t\t\t")) {
                        this.log.info("Found info");
                        if (this.infos.get(currentSection) == null) {
                            this.infos.put(currentSection, new HashMap());
                        }
                        this.infos.get(currentSection).put(currentSubsection, line.substring(3));
                    } else if (line.startsWith("\t\t")) {
                        if ((line = line.substring(2)).toLowerCase().startsWith("select")) {
                            this.parsedData.get(currentSection).put(currentSubsection, line);
                            this.log.trace("\t\tAdded statistics Query: " + line);
                        } else {
                            this.log.warn("Skipped Query: \"" + line + "\"");
                        }
                    } else if (line.startsWith("\t")) {
                        currentSubsection = line.substring(1);
                        if (!this.sectionSubsectionMap.get(currentSection).contains(currentSubsection)) {
                            this.sectionSubsectionMap.get(currentSection).add(currentSubsection);
                        }
                        this.log.trace("\tName: " + currentSubsection);
                    } else {
                        currentSection = line;
                        this.sectionSubsectionMap.put(currentSection, new ArrayList());
                        if (this.parsedData.get(currentSection) == null) {
                            this.parsedData.put(currentSection, new HashMap());
                        }
                        if (!this.sections.contains(currentSection)) {
                            this.sections.add(currentSection);
                        }
                        this.log.trace("Section: " + currentSection);
                    }
                }
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    this.log.error("", e);
                }
            }
        }
        catch (IOException e) {
            this.log.error("", e);
        }
    }

    public void updateAllResults() {
    }

    public void updateResult(String section, String subsection) {
    }

    @Override
    public String getInfo(String section, String subsection) {
        String info;
        Map<String, String> subsectionMap = this.infos.get(section);
        if (subsectionMap != null && (info = subsectionMap.get(subsection)) != null) {
            return info;
        }
        return "No info found.";
    }
}

