/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.statistics;

import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.statistics.Statistics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class StatisticsNew
implements Statistics {
    private static final String STRING_NO_QUERY_FOUND = "No query found";
    Map<String, Map<String, String>> entries;
    Map<String, Map<String, String>> infos;
    Map<String, List<String>> sectionSubsectionMap;
    List<String> sections;
    Logger log = Logger.getLogger(StatisticsNew.class);
    Map<String, PreparedStatement> queryMap;
    Reader input = null;

    public StatisticsNew(Reader inputFile, Properties queries) throws Exception {
        Connection c = DbService.getCurrentService().getNewConnection();
        this.input = inputFile;
        this.queryMap = new HashMap<String, PreparedStatement>();
        for (String queryId : queries.stringPropertyNames()) {
            String queryString = queries.getProperty(queryId);
            if (queryString.trim().toLowerCase().startsWith("select")) {
                this.queryMap.put(queryId, c.prepareStatement(queryString.trim()));
                continue;
            }
            this.log.warn("Invalid Query: '" + queryString + "'. Only 'select'-statements are permitted");
        }
        this.entries = new HashMap<String, Map<String, String>>();
        this.infos = new HashMap<String, Map<String, String>>();
        this.sectionSubsectionMap = new HashMap<String, List<String>>();
        this.sections = new ArrayList<String>();
        this.parseQueries();
    }

    @Override
    public Iterable<String> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    @Override
    public Iterable<String> getSubsections(String section) {
        return Collections.unmodifiableList(this.sectionSubsectionMap.get(section));
    }

    public String getEntry(String section, String subsection) {
        return this.entries.get(section).get(subsection);
    }

    @Override
    public String getResult(String section, String subsection) {
        String output = STRING_NO_QUERY_FOUND;
        Object[] commands = this.entries.get(section).get(subsection).split("[|]");
        PreparedStatement statement = this.queryMap.get(commands[0]);
        try {
            if (statement != null) {
                for (int i = 1; i < commands.length; ++i) {
                    statement.setString(i, ((String)commands[i]).trim());
                }
                ResultSet result = statement.executeQuery();
                if (!result.isClosed() && result.next()) {
                    output = result.getString(1);
                    result.close();
                }
            }
        }
        catch (SQLException e) {
            this.log.error(Arrays.toString(commands), e);
            this.log.error(statement);
            output = "InvalidQuery";
        }
        catch (Exception e) {
            this.log.error("", e);
            output = "Error occurred";
        }
        return output == null ? "Null" : output;
    }

    public void parseQueries() throws IOException {
        BufferedReader reader = new BufferedReader(this.input);
        String section = "";
        String subSection = "";
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("#") && !line.trim().isEmpty()) {
                if (line.startsWith("\t")) {
                    if ((line = line.substring(1)).startsWith("\t")) {
                        if ((line = line.substring(1)).startsWith("\t")) {
                            if (!(line = line.substring(1)).startsWith("\t")) {
                                this.infos.get(section).put(subSection, line);
                            }
                        } else {
                            this.entries.get(section).put(subSection, line);
                        }
                    } else {
                        subSection = line;
                        if (!this.sectionSubsectionMap.get(section).contains(subSection)) {
                            this.sectionSubsectionMap.get(section).add(subSection);
                        }
                    }
                } else {
                    section = line;
                    if (!this.sections.contains(section)) {
                        this.sections.add(section);
                        this.sectionSubsectionMap.put(section, new ArrayList());
                        this.entries.put(section, new HashMap());
                        this.infos.put(section, new HashMap());
                    }
                }
            }
            line = reader.readLine();
        }
    }

    @Override
    public String getInfo(String section, String subsection) {
        return this.infos.get(section).get(subsection);
    }
}

