/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryRetrievalService;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtJAPI;

public class UniProtJapiTester {
    public static final String query = "http://www.uniprot.org/uniprot/%s.txt";
    private final Semaphore sem;
    private List<String> uniProtIds;
    private EntryRetrievalService entryRetrievalService;
    private int count;
    private int countPerSecond;
    private int numOfWorkers;
    private long startTime;

    public UniProtJapiTester(int numOfWorkers) throws IOException {
        this.sem = new Semaphore(numOfWorkers, true);
        this.numOfWorkers = numOfWorkers;
        this.uniProtIds = UniProtJapiTester.getSomeUniprotIds();
        this.entryRetrievalService = UniProtJAPI.factory.getEntryRetrievalService();
        this.count = 0;
    }

    public static List<String> getSomeUniprotIds() throws IOException {
        Vector<String> output = new Vector<String>(700000);
        URL url = new URL("ftp://ftp.uniprot.org/pub/databases/uniprot/knowledgebase/docs/acindex.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        while (!line.startsWith("_")) {
            line = reader.readLine();
        }
        reader.readLine();
        line = reader.readLine();
        while (line != null) {
            try {
                line = line.substring(0, 6);
                output.add(line);
            }
            catch (Exception e) {
                System.err.println("Could not handle: '" + line + "'");
            }
            line = reader.readLine();
        }
        return output;
    }

    public void start() throws InterruptedException {
        this.startTime = System.currentTimeMillis();
        for (int i = 0; i < this.numOfWorkers; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    System.out.println(Thread.currentThread().getName() + " started");
                    while (UniProtJapiTester.this.uniProtIds.size() > 0) {
                        try {
                            UniProtJapiTester.this.sem.acquire();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        List list = UniProtJapiTester.this.uniProtIds;
                        synchronized (list) {
                            String id = (String)UniProtJapiTester.this.uniProtIds.remove(UniProtJapiTester.this.uniProtIds.size() - 1);
                            try {
                                UniProtJapiTester.this.retrieve2(id);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            UniProtJapiTester.this.count++;
                            UniProtJapiTester.this.countPerSecond++;
                        }
                        UniProtJapiTester.this.sem.release();
                    }
                    System.out.println(Thread.currentThread().getName() + " stopped");
                }
            }.start();
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                while (UniProtJapiTester.this.uniProtIds.size() > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    long runningTime = System.currentTimeMillis() - UniProtJapiTester.this.startTime;
                    System.out.println(UniProtJapiTester.this.count + "\t" + (double)UniProtJapiTester.this.count * 1000.0 / (double)runningTime + "\t" + UniProtJapiTester.this.countPerSecond);
                    UniProtJapiTester.this.countPerSecond = 0;
                }
            }
        };
        runner.setPriority(8);
        runner.start();
    }

    public void retrieve(String id) {
        this.entryRetrievalService.getUniProtEntry(id);
    }

    public void retrieve2(String id) {
        try {
            URL test = new URL(String.format(query, id));
            BufferedReader reader = new BufferedReader(new InputStreamReader(test.openStream()));
            String line = reader.readLine();
            while (line != null) {
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        UniProtJapiTester tester = new UniProtJapiTester(5);
        tester.start();
    }
}

