/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.tool.Timer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class TestMySqlDatabaseEngines {
    Connection con;
    int batchSize = 100000;

    public TestMySqlDatabaseEngines() throws Exception {
        Properties settings = PpiToolkit.loadSettings();
        settings.setProperty("database", "tmp");
        DbService service = DbService.createNewDbService(settings);
        this.con = service.getNewConnection();
        this.con.setAutoCommit(true);
    }

    public void insertNumbersInto(String table, int[] numbers, boolean autoCommit, boolean commit, boolean batch) throws SQLException {
        this.con.setAutoCommit(autoCommit);
        System.out.println("Autocommit: " + this.con.getAutoCommit());
        System.out.println("Inserting...");
        Timer t = Timer.startTimer();
        PreparedStatement statement = this.con.prepareStatement("insert into " + table + " values (?)");
        for (int i = 0; i < numbers.length; ++i) {
            statement.setInt(1, numbers[i]);
            if (batch) {
                statement.addBatch();
                if (i % this.batchSize != 0) continue;
                statement.executeBatch();
                System.out.println("executing batch...");
                continue;
            }
            statement.execute();
        }
        if (!batch) {
            statement.executeBatch();
        }
        System.out.println("Inserting took: " + t.stop());
        t.start();
        if (!autoCommit) {
            if (commit) {
                System.out.println("Start commit..");
                this.con.commit();
            } else {
                System.out.println("Start rollback..");
                this.con.rollback();
            }
        }
        System.out.println("Took: " + t.stop());
        this.con.setAutoCommit(true);
        this.con.createStatement().executeUpdate("delete from " + table);
    }

    public int[] generateRandomNumbers(int number) {
        int[] output = new int[number];
        for (int i = 0; i < output.length; ++i) {
            output[i] = (int)(Math.random() * 2.147483647E9);
        }
        return output;
    }

    public static void main(String[] args) throws Exception {
        TestMySqlDatabaseEngines test = new TestMySqlDatabaseEngines();
        int[] random = test.generateRandomNumbers(20000);
        test.insertNumbersInto("test", random, false, true, true);
        test.insertNumbersInto("test2", random, false, true, true);
    }
}

