/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import de.berlin.hu.ppi.tool.Timer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class TestInnoDbRollback {
    public static void main(String[] args) throws SQLException, IOException {
        MysqlDataSource source = new MysqlDataSource();
        source.setUser("arzt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Enter Password: ");
        String password = reader.readLine();
        source.setPassword(password);
        source.setDatabaseName("test");
        source.setServerName("raps");
        Connection con = source.getConnection();
        con.setAutoCommit(false);
        Statement stat = con.createStatement();
        stat.executeUpdate("SET FOREIGN_KEY_CHECKS = 0");
        con.commit();
        stat.executeUpdate("drop table if exists test");
        stat.executeUpdate("drop table if exists test2");
        con.commit();
        stat.executeUpdate("create table test (id int, primary key (id)) engine = innodb");
        stat.executeUpdate("create table test2 (id int, ref_id int, primary key (id), foreign key (ref_id) references test (id)) engine = innodb");
        stat.executeUpdate("SET FOREIGN_KEY_CHECKS = 1");
        con.commit();
        int valueCount = 1000000;
        PreparedStatement pStat = con.prepareStatement("replace into test values (?)");
        Timer t = Timer.startTimer();
        for (int i = 0; i < valueCount; ++i) {
            pStat.setInt(1, i);
            pStat.addBatch();
            if (i % 100000 != 0) continue;
            System.out.println(i);
            pStat.executeBatch();
        }
        pStat.executeBatch();
        System.out.println("Batch time: " + t.stopStart());
        con.commit();
        t.stopStart();
        stat.executeUpdate("delete from test");
        con.rollback();
        System.out.println("Rollback: " + t.stop());
    }
}

