/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import de.berlin.hu.ppi.tool.Timer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.GZIPInputStream;

public class TestDBPerformance {
    public static final String LOAD_DATA_QUERY = "LOAD DATA INFILE '/tmp/idmapping.dat' INTO TABLE lookup_mapping";
    public static final String INSERT_DATA_QUERY = "INSERT INTO lookup_mapping values (?,?,?)";
    public static final String USER = "arzt";
    public static final String PASSWORD = "c7o+Arzt";
    public static final String DB = "protpath_for";

    public static void cropFile(int length) throws FileNotFoundException, IOException {
        File input = new File("/tmp/arzt/idmapping.dat.gz");
        File output = new File("/vol/fob-vol5/mi06/arzt/tmp/idmapping_test.dat");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(input))));
        PrintStream stream = new PrintStream(output);
        String line = reader.readLine();
        int count = 0;
        while (line != null && count < length) {
            line = reader.readLine();
            stream.println(line);
            if (++count % 100000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        System.out.println(count);
    }

    public static void countEntries() throws FileNotFoundException, IOException {
        File input = new File("/tmp/arzt/idmapping.dat.gz");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(input))));
        String line = reader.readLine();
        int count = 0;
        while (line != null) {
            line = reader.readLine();
            if (++count % 1000000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        System.out.println(count);
    }

    public static void loadDataInsert() throws SQLException, InterruptedException {
        MysqlDataSource test = new MysqlDataSource();
        test.setDatabaseName(DB);
        test.setUser(USER);
        test.setPassword(PASSWORD);
        test.setServerName("raps.informatik.hu-berlin.de");
        Connection c = test.getConnection();
        Statement s = c.createStatement();
        Timer t = Timer.startTimer();
        s.execute("truncate table lookup_mapping");
        s.execute("alter table lookup_mapping disable keys");
        System.out.print("Loading data...");
        s.execute(LOAD_DATA_QUERY);
        System.out.println("done.");
        System.out.print("Creating keys...");
        s.execute("alter table lookup_mapping enable keys");
        System.out.println("done.");
        s.close();
        System.out.println("execution done.");
        long stop = t.stop();
        System.out.println(stop);
        System.out.println((double)(stop * 134L) / 60000.0);
    }

    public static void insertData() throws SQLException, IOException {
        MysqlDataSource test = new MysqlDataSource();
        test.setDatabaseName(DB);
        test.setUser(USER);
        test.setPassword(PASSWORD);
        test.setServerName("raps.informatik.hu-berlin.de");
        Connection c = test.getConnection();
        PreparedStatement s = c.prepareStatement(INSERT_DATA_QUERY);
        Timer t = Timer.startTimer();
        File input = new File("/tmp/arzt/idmapping.dat");
        BufferedReader reader = new BufferedReader(new FileReader(input));
        String line = reader.readLine();
        int count = 0;
        while (line != null) {
            ++count;
            String[] splitted = line.split("[\t]");
            s.setString(1, splitted[0]);
            s.setString(2, splitted[1]);
            s.setString(3, splitted[2]);
            s.addBatch();
            line = reader.readLine();
            if (count % 10000 != 0) continue;
            System.out.print(".");
            s.executeBatch();
        }
        s.executeBatch();
        long stop = t.stop();
        System.out.println(stop);
        System.out.println((double)(stop * 134L) / 60000.0);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, SQLException, InterruptedException {
        TestDBPerformance.loadDataInsert();
    }
}

