/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import de.berlin.hu.ppi.net.Downloader;
import de.berlin.hu.ppi.update.plugin.HprdUpdatePlugin;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.StaxWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtJAPI;

public class Test {
    public static final String testUrl = "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.fb.gz";

    public static void testGoAnnotations() throws IOException {
        String[] urls;
        for (String url : urls = new String[]{"ftp://ftp.ebi.ac.uk/pub/databases/intact/current/psi25/pmidMIF25.zip", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.sgd.gz", testUrl, "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.wb.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.rgd.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.goa_uniprot.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.mgi.gz"}) {
            URL test = new URL(url);
            System.out.println("Trying to open\n\t" + url);
            InputStream stream = test.openStream();
            System.out.println("Successfully opened!");
            stream.close();
        }
    }

    public static InputStream downoadFromFTP(String server, String file) throws IOException {
        FTPClient client = new FTPClient();
        client.connect(server);
        client.login("anonymous", "email@aol.com");
        client.setFileType(2);
        client.enterLocalPassiveMode();
        for (FTPFile ftpFile : client.listFiles(file)) {
            System.out.println(ftpFile.getName() + ": " + ftpFile.getSize());
        }
        return client.retrieveFileStream(file);
    }

    public static void testHprdReleaseIdentifying() {
        System.out.println(HprdUpdatePlugin.getCurrentRealeaseString());
    }

    public static String createKeggQuery(List<String> keggIds) {
        StringBuilder b = new StringBuilder();
        b.append("http://www.genome.jp/dbget-bin/www_bget?");
        for (int i = 0; i < keggIds.size() - 1; ++i) {
            b.append(keggIds.get(i));
            b.append('+');
        }
        b.append(keggIds.get(keggIds.size() - 1));
        return b.toString();
    }

    public static void getKeggPathways(List<String> keggIds) throws IOException {
        HashMap keggPathwayMap = new HashMap();
        String query = Test.createKeggQuery(keggIds);
        URL url = new URL(query);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        String currentKeggId = null;
        String currentPathwayId = null;
        String split = "<input type=\"hidden\" name=\"KEGGID\" value=\"";
        while (line != null) {
            if (!line.isEmpty()) {
                if (line.startsWith(split)) {
                    String[] splitted = line.split(split);
                    String token = splitted[1];
                    if (token.length() > 1) {
                        currentKeggId = token.substring(0, token.length() - 3);
                    }
                } else if (line.contains("PATH: ")) {
                    int index = line.indexOf("</a>");
                    currentPathwayId = line.substring(index - 8, index);
                    if (currentKeggId != null && !currentKeggId.isEmpty()) {
                        if (keggPathwayMap.get(currentKeggId) == null) {
                            keggPathwayMap.put(currentKeggId, new HashSet());
                        }
                        ((Set)keggPathwayMap.get(currentKeggId)).add(currentPathwayId);
                    }
                }
            }
            line = reader.readLine();
        }
    }

    public static void testUniprotQuery() throws IOException {
        String query = "http://www.uniprot.org/uniprot/?query=active:no&compress=yes&format=tab&columns=id,entry%20name,reviewed,protein%20names,genes,organism,length";
        URL u = new URL(query);
        URLConnection con = u.openConnection();
        InputStream stream = con.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(stream)));
        String line = reader.readLine();
        while (line != null) {
            if (line.contains("Demerged")) {
                System.out.println(Arrays.toString(line.split("\t")));
            }
            line = reader.readLine();
        }
    }

    public static void testEntryRetrievalService() {
        System.out.println(UniProtJAPI.factory.getEntryRetrievalService().getUniProtEntry("Q10935"));
    }

    public static void testDownload() throws IOException {
        String FTP_FILE_LOCATION = "ftp://ftp.genome.jp/pub/kegg/release/current/kgml.tar.gz";
        Downloader downloader = new Downloader(FTP_FILE_LOCATION);
        downloader.setTargetDirectory(new File("."));
        downloader.initializeDownload();
        while (downloader.download() != -1) {
        }
    }

    public static void testMpisPlugin() throws FileNotFoundException, IOException {
        GZIPInputStream input = new GZIPInputStream(new FileInputStream("/tmp/arzt/mppi.gz"));
        StaxWrapper test = new StaxWrapper(input, "Test");
        int counter = 0;
        for (ProteinInteraction interaction : test) {
            System.out.println(interaction + " " + counter);
            ++counter;
        }
    }

    public static void cropMappingFile(int count, String source, String destination) throws IOException {
        BufferedReader input = new BufferedReader(new FileReader(source));
        PrintStream output = new PrintStream(destination);
        String line = input.readLine();
        for (int i = 0; i < count && line != null; ++i) {
            output.println(line);
            if (i % 10000 != 0) continue;
            System.out.print("i: ");
            System.out.println(i);
        }
        input.close();
        output.close();
    }

    public static void main(String ... args) throws IOException {
        List<String> test = Arrays.asList("Eins", "Zwo", "Drei");
        List<String> test2 = Collections.unmodifiableList(test);
        System.out.println(test2);
    }
}

