/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class MapLocation {
    static String queryUrl = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=gene&id=<id>&retmode=text";

    public static String getMapLocation(int geneId) throws IOException {
        URL url = new URL(queryUrl.replace("<id>", Integer.toString(geneId)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        while (line != null) {
            if (line.contains("maploc")) {
                reader.close();
                String[] splitted = line.split("maploc \"|\".*");
                return splitted[splitted.length - 1];
            }
            line = reader.readLine();
        }
        reader.close();
        return null;
    }

    public static String toQueryString(int ... geneId) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < geneId.length - 1; ++i) {
            b.append(geneId[i]).append(',');
        }
        b.append(geneId[geneId.length - 1]);
        return b.toString();
    }

    public static Map<Integer, String> getMapLocation(int ... geneId) throws IOException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        String urlString = queryUrl.replace("<id>", MapLocation.toQueryString(geneId));
        System.out.println(urlString);
        URL url = new URL(urlString);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        int currentGeneId = 0;
        int index = 0;
        while (line != null && index < geneId.length) {
            if (line.contains(String.valueOf(geneId[index]))) {
                currentGeneId = geneId[index];
            }
            if (line.contains("maploc")) {
                String[] splitted = line.split("maploc \"|\".*");
                String mapLocation = splitted[splitted.length - 1];
                result.put(currentGeneId, mapLocation);
                ++index;
            }
            line = reader.readLine();
        }
        reader.close();
        return result;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(MapLocation.getMapLocation(6846));
    }
}

