/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Laut
extends DefaultHandler {
    private String title;
    private String name;
    private String record;
    private String year;
    private String image;
    private String teaser;
    private String url;
    private String station;
    private String lastElement;
    public static final String TITLE = "title";
    public static final String NAME = "name";
    public static final String RECORD = "record";
    public static final String YEAR = "year";
    public static final String IMAGE = "image";
    public static final String TEASER = "teaser";
    public static final String URL = "url";
    public static final String EMPTY = "";

    public static void main(String[] args) {
        Laut test = new Laut("neon");
        try {
            test.refresh();
            System.out.println("Name:\t" + test.getName());
            System.out.println("Titel:\t" + test.getTitle());
            System.out.println("Record:\t" + test.getRecord());
            System.out.println("Year:\t" + test.getYear());
            System.out.println("Teaser:\t" + test.getTeaser());
            System.out.println("Image:\t" + test.getImageURL());
            System.out.println("URL:\t" + test.getURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public Laut(String station) {
        this.station = station;
    }

    @Override
    public void characters(char[] characters, int start, int length) {
        String text = new String(characters, start, length);
        if (this.lastElement.equals(TITLE)) {
            this.title = text;
        } else if (this.lastElement.equals(NAME)) {
            this.name = text;
        } else if (this.lastElement.equals(RECORD)) {
            this.record = text;
        } else if (this.lastElement.equals(YEAR)) {
            this.year = text;
        } else if (this.lastElement.equals(TEASER)) {
            this.teaser = text;
        } else if (this.lastElement.equals(URL)) {
            this.url = text;
        } else if (this.lastElement.equals(IMAGE)) {
            this.image = text;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.lastElement = EMPTY;
    }

    public String getImageURL() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public String getRecord() {
        return this.record;
    }

    public String getTeaser() {
        return this.teaser;
    }

    public String getTitle() {
        return this.title;
    }

    public String getURL() {
        return this.url;
    }

    public String getYear() {
        return this.year;
    }

    private void parseInputStream(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory.newInstance().newSAXParser().parse(input, (DefaultHandler)this);
    }

    public void refresh() throws MalformedURLException, IOException, ParserConfigurationException, SAXException {
        this.refresh(new URL("http://www.laut.fm/user/" + this.station.toLowerCase() + "/jetzt.xml"));
    }

    public void refresh(File file) throws ParserConfigurationException, SAXException, IOException {
        this.parseInputStream(new FileInputStream(file));
    }

    public void refresh(URL url) throws IOException, ParserConfigurationException, SAXException {
        this.parseInputStream(url.openStream());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        this.lastElement = qName;
    }
}

