/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JXMLTreeTest
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private JScrollPane scrollPane;

    public JXMLTreeTest(String filePath) {
        super("JXMLTreeTest");
        this.setDefaultCloseOperation(3);
        DefaultMutableTreeNode root = this.initTreeRoot(filePath);
        this.tree = new JTree(root);
        this.scrollPane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
        this.setVisible(true);
    }

    private DefaultMutableTreeNode initTreeRoot(String file) {
        Node doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new File(file));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            return new DefaultMutableTreeNode("EMPTY");
        }
        Node rootNode = doc.getFirstChild();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootNode.getNodeName());
        JXMLTreeTest.treeWalk(rootNode, 0, root);
        return root;
    }

    public static void treeWalk(Node node, int level, DefaultMutableTreeNode parentNode) {
        DefaultMutableTreeNode childNode = null;
        if (node.hasChildNodes()) {
            ++level;
            NodeList list = node.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = list.item(i);
                childNode = new DefaultMutableTreeNode(child.getNodeName());
                parentNode.add(childNode);
                JXMLTreeTest.treeWalk(list.item(i), level, childNode);
            }
        } else {
            childNode = new DefaultMutableTreeNode(node.getNodeValue());
            parentNode.add(childNode);
        }
    }

    public static void main(String[] args) {
        new JXMLTreeTest("/home/realdocx/ppi_data/pmid/2008/1961752.xml");
    }

    public static final StringBuffer repeat(int n, char c) {
        char[] cA = new char[n];
        Arrays.fill(cA, c);
        return new StringBuffer().insert(0, cA);
    }
}

