/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.prototype;

import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.db.DbService;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mim.Mim;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryRetrievalService;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtJAPI;

public class EntryRetrievalExample {
    public static Map<Integer, String> getAllProteins() throws SQLException {
        Connection c = DbService.getCurrentService().getNewConnection();
        Statement s = c.createStatement();
        ResultSet result = s.executeQuery("select id, primary_uniprot_id from molecule where primary_uniprot_id is not null and tax_id = 9606 order by id");
        HashMap<Integer, String> output = new HashMap<Integer, String>();
        while (result.next()) {
            int id = result.getInt(1);
            String uid = result.getString(2);
            output.put(id, uid);
        }
        return output;
    }

    public void addOmimRef(int id, String uid) {
    }

    public static void main(String[] args) throws Throwable {
        EntryRetrievalService service = UniProtJAPI.factory.getEntryRetrievalService();
        UniProtEntry entry = service.getUniProtEntry("P05091");
        System.out.println("Tax id: " + entry.getNcbiTaxonomyIds().get(0).getValue());
        System.out.println("entry = " + entry);
        if (entry != null) {
            System.out.println(entry.getGenes().size());
            System.out.println(entry.getDatabaseCrossReferences(DatabaseType.MIM));
            System.out.println(entry.getGenes().get(0).getGeneName().getValue());
        }
    }

    private static void insertOmimGenoTypes() throws IOException, Exception, SQLException {
        PpiToolkit.setupEnvironment();
        DbService.createMyDbService();
        Map<Integer, String> allProteins = EntryRetrievalExample.getAllProteins();
        int count = 0;
        Connection con = DbService.getCurrentService().getNewConnection();
        PreparedStatement statement = con.prepareStatement("insert ignore into reference values (?, ?, ?)");
        EntryRetrievalService service = UniProtJAPI.factory.getEntryRetrievalService();
        for (Integer id : new TreeSet<Integer>(allProteins.keySet())) {
            List databaseCrossReferences;
            String uid = allProteins.get(id);
            UniProtEntry uniProtEntry = service.getUniProtEntry(uid);
            if (uniProtEntry == null || (databaseCrossReferences = uniProtEntry.getDatabaseCrossReferences(DatabaseType.MIM)) == null) continue;
            for (DatabaseCrossReference ref : databaseCrossReferences) {
                String description;
                Mim mimRef = (Mim)ref;
                if (!mimRef.hasMimAccessionNumber() || !(description = mimRef.getMimDescription().getValue()).startsWith("gene")) continue;
                String mim = mimRef.getMimAccessionNumber().getValue();
                statement.setInt(1, id);
                statement.setString(2, "omim_genotype");
                statement.setString(3, mim);
                statement.addBatch();
                if (++count % 250 == 0) {
                    statement.executeBatch();
                }
                System.out.println(allProteins.keySet().size() + ":" + count);
            }
        }
        statement.executeBatch();
    }
}

