/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.object.kgml;

import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.tool.StringTransformationMethods;
import java.util.ArrayList;
import java.util.List;

public class Entry {
    public static final int DEFAULT_REACTION_LENGTH = 9;
    private String id;
    private String name;
    private String type;
    private List<String> reactions = new ArrayList<String>();
    private List<String> components = new ArrayList<String>();
    private String link = null;
    private int originalX;
    private int originalY;
    private int x;
    private int y;
    private int adjustX = 0;
    private int adjustY = 0;
    private boolean hasReactionAssignment = false;

    public Entry(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReaction(int index) {
        return this.reactions.get(index);
    }

    private void addReactions(String splitChar, String reaction) throws FileParsingException {
        String[] tmp = reaction.split(splitChar);
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].length() == 6) {
                tmp[i] = "rn:" + tmp[i];
            }
            if (tmp[i].length() != 9) continue;
            this.reactions.add(tmp[i]);
        }
    }

    public void setReactions(String reaction) throws FileParsingException {
        if (reaction == null) {
            return;
        }
        if (reaction.length() > 9) {
            if (reaction.contains(" ")) {
                this.addReactions(" ", reaction);
            } else if (reaction.contains(",")) {
                this.addReactions(",", reaction);
            }
        } else if (reaction.length() < 9) {
            if (reaction.length() == 6) {
                reaction = "rn:" + reaction;
                this.reactions.add(reaction);
            }
        } else {
            this.reactions.add(reaction);
        }
    }

    public int getReactionsSize() {
        return this.reactions.size();
    }

    public void addComponent(String component) {
        this.components.add(component);
    }

    public String getComponent(int index) {
        return this.components.get(index);
    }

    public int getComponentsSize() {
        return this.components.size();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getX() {
        return this.x;
    }

    public void setX(String x) throws NumberFormatException {
        this.x = StringTransformationMethods.strtoint(x);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void increaseX(int x) {
        this.x += x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(String y) throws NumberFormatException {
        this.y = StringTransformationMethods.strtoint(y);
    }

    public void setY(int y) {
        this.y = y;
    }

    public void increaseY(int y) {
        this.y += y;
    }

    public int getAdjustX() {
        return this.adjustX;
    }

    public void resetAdjustX() {
        this.adjustX = 0;
    }

    public void setAdjustX(int adjustX) {
        this.adjustX = adjustX;
    }

    public int getAdjustY() {
        return this.adjustY;
    }

    public void resetAdjustY() {
        this.adjustY = 0;
    }

    public void setAdjustY(int adjustY) {
        this.adjustY = adjustY;
    }

    public boolean hasReactionAssignment() {
        return this.hasReactionAssignment;
    }

    public void setHasReactionAssignment(boolean hasReactionAssignment) {
        this.hasReactionAssignment = hasReactionAssignment;
    }

    public void reassignOriginalX() {
        this.x = this.originalX;
    }

    public void setOriginalX(int originalX) {
        this.originalX = originalX;
    }

    public void reassignOriginalY() {
        this.y = this.originalY;
    }

    public void setOriginalY(int originalY) {
        this.originalY = originalY;
    }
}

