/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.object;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.object.ExternalRef;
import de.berlin.hu.ppi.tool.StringTransformationMethods;
import de.berlin.hu.ppi.tool.UniprotAccessionNumbersPlugin;
import de.berlin.hu.ppi.wrapper.Protein;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Vertex
implements Protein {
    private static final String UNIPROT = "uniprot";
    private int generatedId;
    private String id;
    private String name;
    private String shortName;
    private String organism;
    private String cellularLocation;
    private PpiConstants.MOLECULE_TYPE type;
    private String sequence;
    private String chromosomalPosition;
    private Integer x;
    private Integer y;
    private boolean isComplex = false;
    private List<String> complexParts;
    private List<String> synonyms = new ArrayList<String>();
    private boolean isSuspicious;
    private Set<ExternalRef> externalRefs;
    private Map<String, Set<String>> externalRefsPerDb;
    private Map<String, String> referencesAsMap = null;
    private static Set<String> uniprotIdentifiers = new HashSet<String>();
    private boolean alreadyKnown;

    public boolean isSuspicious() {
        return this.isSuspicious;
    }

    public void setSuspicious(boolean isSuspicious) {
        this.isSuspicious = isSuspicious;
    }

    public Vertex(String id) {
        this.complexParts = new ArrayList<String>();
        this.id = id;
        this.externalRefs = new HashSet<ExternalRef>();
        this.externalRefsPerDb = new HashMap<String, Set<String>>();
        this.x = null;
        this.y = null;
        this.generatedId = -1;
        this.name = null;
        this.sequence = null;
        this.chromosomalPosition = null;
        this.type = PpiConstants.MOLECULE_TYPE.UNDEFINED;
        this.alreadyKnown = false;
    }

    public boolean isAlreadyKnown() {
        return this.alreadyKnown;
    }

    public void setAlreadyKnown(boolean alreadyKnown) {
        this.alreadyKnown = alreadyKnown;
    }

    public String getChromosomalPosition() {
        return this.chromosomalPosition;
    }

    public void setChromosomalPosition(String chromosomalPosition) {
        this.chromosomalPosition = chromosomalPosition;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public int getGeneratedId() {
        return this.generatedId;
    }

    public void setGeneratedId(int generatedId) {
        this.generatedId = generatedId;
    }

    private void addReference(ExternalRef newRef) {
        if (this.externalRefs.add(newRef)) {
            Set<String> tmp = this.externalRefsPerDb.get(newRef.getDb());
            if (tmp == null) {
                tmp = new HashSet<String>();
                this.externalRefsPerDb.put(newRef.getDb(), tmp);
            }
            tmp.add(newRef.getId());
        }
    }

    public void addExternalRef(ExternalRef ref) {
        if (uniprotIdentifiers.contains(ref.getDb().toLowerCase())) {
            ref.setDb(UNIPROT);
        }
        if (ref.getId().contains(" ")) {
            String[] ids = ref.getId().split("\\s+");
            for (int i = 0; i < ids.length; ++i) {
                ExternalRef newRef = new ExternalRef();
                newRef.setDb(ref.getDb());
                newRef.setId(ids[i]);
                this.addReference(newRef);
            }
        } else {
            this.addReference(ref);
        }
    }

    public int getExternalRefsSize() {
        return this.externalRefs.size();
    }

    public Iterator<ExternalRef> getExternalRefs() {
        return this.externalRefs.iterator();
    }

    public void setComplexParts(List<String> complexParts) {
        this.complexParts = complexParts;
    }

    public void addComplexPart(String part) {
        this.complexParts.add(part);
    }

    public int getComplexPartsSize() {
        return this.complexParts.size();
    }

    public String getComplexPart(int index) {
        return this.complexParts.get(index);
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public void setComplex(boolean isComplex) {
        this.isComplex = isComplex;
    }

    public int getSynonymsSize() {
        return this.synonyms.size();
    }

    public String getSynonym(int index) {
        return this.synonyms.get(index);
    }

    public void addSynonym(String synonym) {
        if (synonym != null) {
            synonym = StringTransformationMethods.removeUnecessaryStuffAndCutOff(synonym, 255);
        }
        this.synonyms.add(synonym);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = StringTransformationMethods.removeUnecessaryStuffAndCutOff(name, 255);
        }
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        if (shortName != null) {
            shortName = StringTransformationMethods.removeUnecessaryStuffAndCutOff(shortName, 255);
        }
        this.shortName = shortName;
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String organism) {
        if (organism != null) {
            organism = StringTransformationMethods.removeUnecessaryStuffAndCutOff(organism, 255);
        }
        this.organism = organism;
    }

    public String getCellularLocation() {
        return this.cellularLocation;
    }

    public void setCellularLocation(String cellularLocation) {
        if (cellularLocation != null) {
            cellularLocation = StringTransformationMethods.removeUnecessaryStuffAndCutOff(cellularLocation, 255);
        }
        this.cellularLocation = cellularLocation;
    }

    public PpiConstants.MOLECULE_TYPE getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type == null) {
            this.type = PpiConstants.MOLECULE_TYPE.UNDEFINED;
        } else {
            try {
                this.type = PpiConstants.MOLECULE_TYPE.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                System.err.println("An unknown molecule type was discovered: \"" + type + "\"; saved as \"undefined\"");
                this.type = PpiConstants.MOLECULE_TYPE.UNDEFINED;
            }
        }
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    @Override
    public Map<String, String> getAllIds() {
        if (this.referencesAsMap == null) {
            this.referencesAsMap = new HashMap<String, String>();
            for (String db : this.externalRefsPerDb.keySet()) {
                this.referencesAsMap.put(db, this.externalRefsPerDb.get(db).iterator().next());
            }
        }
        return this.referencesAsMap;
    }

    @Override
    public String getIdValue(String idName) {
        Set<String> tmp = this.externalRefsPerDb.get(idName);
        if (tmp == null) {
            return null;
        }
        return tmp.iterator().next();
    }

    public boolean isRepresentativeMolecule() {
        String primaryUniprotId = null;
        for (String db : this.externalRefsPerDb.keySet()) {
            Set<String> refs = this.externalRefsPerDb.get(db);
            if (db.equals(UNIPROT)) {
                for (String ref : refs) {
                    String result = null;
                    try {
                        result = ((UniprotAccessionNumbersPlugin)UniprotAccessionNumbersPlugin.getInstance()).getPrimaryUniprotId(ref);
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).warn("", e);
                    }
                    if (result == null) continue;
                    if (primaryUniprotId == null) {
                        primaryUniprotId = result;
                        continue;
                    }
                    if (primaryUniprotId.equals(result)) continue;
                    return true;
                }
                continue;
            }
            if (refs.size() <= 1) continue;
            return true;
        }
        Set<String> uniprotIds = this.externalRefsPerDb.remove(UNIPROT);
        if (uniprotIds != null) {
            for (String uniprotId : uniprotIds) {
                ExternalRef ref = new ExternalRef(UNIPROT, uniprotId);
                this.externalRefs.remove(ref);
            }
            if (primaryUniprotId != null) {
                HashSet<String> newId = new HashSet<String>();
                newId.add(primaryUniprotId);
                this.externalRefsPerDb.put(UNIPROT, newId);
                this.externalRefs.add(new ExternalRef(UNIPROT, primaryUniprotId));
            }
        }
        return false;
    }

    @Override
    public String getExperimentalRole() {
        return null;
    }

    static {
        uniprotIdentifiers.add("up");
        uniprotIdentifiers.add(UNIPROT);
        uniprotIdentifiers.add("uniprotkb");
        uniprotIdentifiers.add("uniprot knowledge base");
        uniprotIdentifiers.add("swiss-prot");
    }
}

