/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Tag {
    private TagType type;
    private String name = null;
    private boolean hasChildren = false;
    private Map<String, String> attributes = new HashMap<String, String>();

    public String toString() {
        return "(Type: " + (Object)((Object)this.type) + ", Name: " + this.name + ", hasChildren: " + this.hasChildren + ", Attributes: " + this.printAttributes() + ")";
    }

    private String printAttributes() {
        StringBuilder all = new StringBuilder();
        for (String key : this.attributes.keySet()) {
            all.append(key);
            all.append(":");
            all.append(this.attributes.get(key));
            all.append(" ");
        }
        return all.toString();
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public TagType getType() {
        return this.type;
    }

    public void setType(TagType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAttributesSize() {
        return this.attributes.size();
    }

    public Iterator<String> getAttributes() {
        return this.attributes.keySet().iterator();
    }

    public boolean containsAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public static enum TagType {
        OPENING_TAG,
        ENDING_TAG,
        COMPLETE_TAG,
        USELESS_TAG;

    }
}

