/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.object;

import de.berlin.hu.ppi.parser.object.Edge;
import de.berlin.hu.ppi.parser.object.InterConnection;
import de.berlin.hu.ppi.parser.object.Vertex;
import de.berlin.hu.ppi.tool.StringTransformationMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Graph {
    private String id = null;
    private String name;
    private String shortName = null;
    private String organism = null;
    private Date lastUpdate;
    private boolean isPPI;
    private Map<String, Vertex> vertices = new HashMap<String, Vertex>();
    private Map<String, Edge> edges = new HashMap<String, Edge>();
    private List<InterConnection> interConnections = new ArrayList<InterConnection>();

    public Graph(String name) {
        if (name != null) {
            name = StringTransformationMethods.removeUnecessaryStuffAndCutOff(name, 255);
        }
        this.name = name;
        this.isPPI = false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id != null) {
            id = StringTransformationMethods.removeUnecessaryStuffAndCutOff(id, 255);
        }
        this.id = id;
    }

    public void addInterConnection(InterConnection interConnection) {
        this.interConnections.add(interConnection);
    }

    public Iterator<InterConnection> getInterConnectionsIterator() {
        return this.interConnections.iterator();
    }

    public void setInterConnections(List<InterConnection> interConnections) {
        this.interConnections = interConnections;
    }

    public void setVertices(Map<String, Vertex> vertices) {
        this.vertices = vertices;
    }

    public Iterator<String> getVerticesIterator() {
        return this.vertices.keySet().iterator();
    }

    public int getCountOfVertices() {
        return this.vertices.size();
    }

    public Vertex getVertex(String id) {
        return this.vertices.get(id);
    }

    public void addVertex(Vertex vertex) {
        this.vertices.put(vertex.getId(), vertex);
    }

    public Iterator<String> getEdgesIterator() {
        return this.edges.keySet().iterator();
    }

    public Edge getEdge(String id) {
        return this.edges.get(id);
    }

    public void addEdge(Edge edge) {
        this.edges.put(edge.getId(), edge);
    }

    public void addAllEdges(List<Edge> edges) {
        edges.addAll(edges);
    }

    public void setEdges(Map<String, Edge> edges) {
        this.edges = edges;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = StringTransformationMethods.removeUnecessaryStuffAndCutOff(name, 255);
        }
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        if (shortName != null) {
            shortName = StringTransformationMethods.removeUnecessaryStuffAndCutOff(shortName, 255);
        }
        this.shortName = shortName;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String organism) {
        if (organism != null) {
            organism = StringTransformationMethods.removeUnecessaryStuffAndCutOff(organism, 255);
        }
        this.organism = organism;
    }

    public boolean isPPI() {
        return this.isPPI;
    }

    public void setIsPPI(boolean isPPI) {
        this.isPPI = isPPI;
    }
}

