/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.object;

import de.berlin.hu.ppi.parser.object.SubEdge;
import de.berlin.hu.ppi.parser.object.VertexPair;
import de.berlin.hu.ppi.parser.object.biopax.Attribute;
import de.berlin.hu.ppi.tool.StringTransformationMethods;
import java.util.ArrayList;
import java.util.List;

public class Edge {
    private List<VertexPair> vertices;
    private int generatedId;
    private String id;
    private String name;
    private String shortName;
    private String type;
    private int direction;
    private Attribute nextSteps;
    private List<SubEdge> subEdges;

    public Edge(String id) {
        this.id = id;
        this.generatedId = -1;
        this.vertices = new ArrayList<VertexPair>();
        this.subEdges = new ArrayList<SubEdge>();
    }

    public int getSubEdgesSize() {
        return this.subEdges.size();
    }

    public SubEdge getSubEdge(int index) {
        return this.subEdges.get(index);
    }

    public void addSubEdge(SubEdge edge) {
        this.subEdges.add(edge);
    }

    public int getGeneratedId() {
        return this.generatedId;
    }

    public void setGeneratedId(int generatedId) {
        this.generatedId = generatedId;
    }

    public void addVertexPair(VertexPair pair) {
        this.vertices.add(pair);
    }

    public int getVertexPairsSize() {
        return this.vertices.size();
    }

    public VertexPair getVertexPair(int index) {
        return this.vertices.get(index);
    }

    public Attribute getNextSteps() {
        return this.nextSteps;
    }

    public void setNextSteps(Attribute nextSteps) {
        this.nextSteps = nextSteps;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = StringTransformationMethods.removeUnecessaryStuffAndCutOff(name, 255);
        }
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        if (shortName != null) {
            shortName = StringTransformationMethods.removeUnecessaryStuffAndCutOff(shortName, 255);
        }
        this.shortName = shortName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null) {
            type = StringTransformationMethods.removeUnecessaryStuffAndCutOff(type, 255);
        }
        this.type = type;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public static enum EdgeDirection {
        LEFT,
        RIGHT,
        BOTH;

    }
}

