/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.goa;

import de.berlin.hu.ppi.parser.goa.GoAnnotation;
import de.berlin.hu.ppi.parser.goa.GoAnnotationListener;
import de.berlin.hu.wbi.common.performance.Pool;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MemoryGoAnnotationListener
implements GoAnnotationListener {
    private Map<String, Set<GoAnnotation>> annotations = new HashMap<String, Set<GoAnnotation>>();
    private Set<String> relevantIds = null;
    private Pool<String> stringPool = new Pool();
    private int annotationCount;

    public Map<String, Set<GoAnnotation>> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void handleGoAnnotation(String databaseId, String goIdString, String type) {
        boolean isRelevant;
        boolean bl = isRelevant = this.relevantIds != null && this.relevantIds.contains(databaseId);
        if (isRelevant || this.relevantIds == null) {
            int goId = MemoryGoAnnotationListener.convertToIntegerIdUnsave(goIdString);
            type = this.stringPool.pool(type);
            GoAnnotation annotation = new GoAnnotation();
            annotation.setGoId(goId);
            annotation.setType(type);
            Set<GoAnnotation> annotationSet = this.annotations.get(databaseId);
            if (annotationSet == null) {
                annotationSet = new HashSet<GoAnnotation>();
                this.annotations.put(databaseId, annotationSet);
            }
            annotationSet.add(annotation);
            ++this.annotationCount;
        }
    }

    public void setRelevantIds(Set<String> ofInterest) {
        this.relevantIds = ofInterest;
    }

    public static int convertToIntegerIdUnsave(String goId) {
        return Integer.parseInt(goId.substring(3));
    }

    public static String convertToStringId(int goId) {
        return String.format("GO:%07d", goId);
    }
}

