/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.goa;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.goa.GoAnnotationListener;
import de.berlin.hu.ppi.parser.goa.GoAnnotationParser;
import de.berlin.hu.wbi.common.io.IO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Inserter {
    private static final String SQL_SELECT_FOREIGN_IDS = "select l.foreign_key, m.id from molecule m, lookup_mapping l where m.primary_uniprot_id = l.uniprot_id and l.foreign_db = ?";
    private static final String SQL_SELECT_MOLECULES = "select distinct m.primary_uniprot_id, m.id from molecule m";
    public static final String SQL_INSERT_ANNOTATIONS = "insert ignore into go_rel_evidence_add values (?, ?, ?, ?)";
    private int count;
    private PreparedStatement selectForeignIds;
    private PreparedStatement selectMolecules;
    private PreparedStatement insertAnnotations;
    private int currentLineNumber;
    private GoAnnotationParser parser;
    private boolean skipInsert = false;

    public Inserter(Connection connection) throws SQLException {
        this.selectForeignIds = connection.prepareStatement(SQL_SELECT_FOREIGN_IDS);
        this.selectMolecules = connection.prepareStatement(SQL_SELECT_MOLECULES);
        this.insertAnnotations = connection.prepareStatement(SQL_INSERT_ANNOTATIONS);
    }

    public Map<String, Integer> fetchForeignIds(String dbName, int limit) throws SQLException {
        this.selectForeignIds.setString(1, dbName);
        return this.toStringIntegerMap(this.selectForeignIds, limit);
    }

    public Map<String, Integer> fetchForeignIds(String dbName) throws SQLException {
        return this.fetchForeignIds(dbName, Integer.MAX_VALUE);
    }

    public Map<String, Integer> toStringIntegerMap(PreparedStatement statement, int limit) throws SQLException {
        HashMap<String, Integer> output = new HashMap<String, Integer>(1000);
        ResultSet result = statement.executeQuery();
        while (result.next() && limit > 0) {
            String uniprotId = result.getString(1);
            int moleculeId = result.getInt(2);
            output.put(uniprotId, moleculeId);
            --limit;
        }
        return output;
    }

    public Map<String, Integer> fetchMolecules(int limit) throws SQLException {
        return this.toStringIntegerMap(this.selectMolecules, limit);
    }

    public Map<String, Integer> fetchMolecules() throws SQLException {
        return this.toStringIntegerMap(this.selectMolecules, Integer.MAX_VALUE);
    }

    public Map<String, Integer> getIdMapping(PpiConstants.DB_ID a, int limit) throws SQLException {
        Map<String, Integer> idMapping = null;
        idMapping = a == PpiConstants.DB_ID.GoaHuman || a == PpiConstants.DB_ID.GoaUniProt ? this.fetchMolecules(limit) : this.fetchForeignIds(a.toString(), limit);
        return idMapping;
    }

    public Map<String, Integer> getIdMapping(String a) throws SQLException {
        Map<String, Integer> idMapping = null;
        idMapping = "GoaHuman".equals(a) || "GoaUniProt".equals(a) ? this.fetchMolecules() : this.fetchForeignIds(a);
        return idMapping;
    }

    public void perform(InputStream stream, final Map<String, Integer> idMapping, final String source, int limit) throws IOException, SQLException {
        System.out.println("Potential proteins: " + idMapping.keySet().size());
        this.parser = new GoAnnotationParser();
        GoAnnotationListener goAnnotationParser = new GoAnnotationListener(){

            @Override
            public void handleGoAnnotation(String id, String goId, String type) {
                Integer moleculeId = (Integer)idMapping.get(id);
                if (moleculeId != null) {
                    try {
                        Inserter.this.insertAnnotation(goId, moleculeId, type, source);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.parser.setGoAnnotationHandler(goAnnotationParser);
        this.parser.parse(stream);
        this.currentLineNumber += this.parser.getCurrentLineNumber();
        this.finish();
    }

    private void insertAnnotation(String goId, int id, String type, String source) throws SQLException {
        this.insertAnnotations.setString(1, goId);
        this.insertAnnotations.setInt(2, id);
        this.insertAnnotations.setString(3, type);
        this.insertAnnotations.setString(4, source);
        if (this.skipInsert) {
            System.out.println(this.insertAnnotations);
        } else {
            this.insertAnnotations.addBatch();
        }
        ++this.count;
        if (this.count % 100000 == 0) {
            int[] executeBatch = this.insertAnnotations.executeBatch();
            int sum = 0;
            for (int i : executeBatch) {
                sum += i;
            }
        }
    }

    public void finish() throws SQLException {
        this.insertAnnotations.executeBatch();
    }

    public int getCount() {
        return this.count;
    }

    public static void main(String[] args) throws SQLException, IOException, InterruptedException {
        final GoAnnotationParser parser = new GoAnnotationParser();
        parser.setGoAnnotationHandler(new GoAnnotationListener(){

            @Override
            public void handleGoAnnotation(String databaseId, String goId, String type) {
                System.out.format("Database: %s, Go: %s, Type: %s\n", databaseId, goId, type);
            }
        });
        String file = "/tmp/arzt/goa/gene_association.goa_uniprot.gz";
        final BufferedReader reader = IO.read(file);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    parser.parse(reader);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.start();
        Thread.sleep(4000L);
    }

    public void skipInsert(boolean skip) {
        this.skipInsert = skip;
    }

    public void perform(InputStream stream, Map<String, Integer> idMapping, String source) throws IOException, SQLException {
        this.perform(stream, idMapping, source, Integer.MAX_VALUE);
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber + (this.parser == null ? 0 : this.parser.getCurrentLineNumber());
    }

    public void interrupt() {
        if (this.parser != null) {
            this.parser.interruptParsing();
        }
    }
}

