/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.goString;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GoTerm
implements Comparable<GoTerm>,
Serializable {
    private static final long serialVersionUID = 6939020027037892836L;
    private String id = "";
    private String name = "";
    private String def = "";
    private int minDepth = -1;
    private int maxDepth = -1;
    private double avgDepth = -1.0;
    private boolean isObsolete = false;
    private Namespace namespace = Namespace.UNDEFINED;
    private Map<Relationship, Set<GoTerm>> relationships = new HashMap<Relationship, Set<GoTerm>>();
    private Collection<String> altIds = Collections.emptyList();
    private Collection<String> considerIds = Collections.emptyList();
    private Set<GoTerm> parents = new HashSet<GoTerm>();
    private Set<GoTerm> children = new HashSet<GoTerm>();
    private Set<GoTerm> allChildren = null;
    private Set<GoTerm> allParents = null;
    private Set<String> allChildrenIds;
    private Set<String> allParentIds;
    private int hash;
    private static final String goPattern = "GO:\\d\\d\\d\\d\\d\\d\\d";

    public GoTerm(String goId) {
        this.hash = GoTerm.converToIntegerId(goId);
        this.id = goId;
    }

    public static int[] convertToIntegerIds(Set<String> integers) {
        int[] output = new int[integers.size()];
        int i = 0;
        for (String s : integers) {
            output[i] = GoTerm.convertToIntegerIdUnsave(s);
            ++i;
        }
        return output;
    }

    private void addRelationship(Relationship relationship, GoTerm term) {
        Set<GoTerm> isA = this.relationships.get((Object)relationship);
        if (isA == null) {
            isA = new HashSet<GoTerm>();
            this.relationships.put(relationship, isA);
        }
        isA.add(term);
    }

    public void addIsA(GoTerm term) {
        this.addRelationship(Relationship.IS_A, term);
    }

    public void doPostProcessing() {
        for (Relationship r : Relationship.values()) {
            Set<GoTerm> relatingTerms = this.relationships.get((Object)r);
            if (relatingTerms == null) continue;
            this.parents.addAll(relatingTerms);
        }
        for (GoTerm parent : this.parents) {
            parent.children.add(this);
        }
    }

    public Collection<GoTerm> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    public Collection<GoTerm> getNegativelyRegulates() {
        return this.getRelatingParents(Relationship.NEGATIVELY_REGULATES);
    }

    public Collection<GoTerm> getPositivelyRegulates() {
        return this.getRelatingParents(Relationship.NEGATIVELY_REGULATES);
    }

    public Collection<GoTerm> getPartOf() {
        return this.getRelatingParents(Relationship.PART_OF);
    }

    public Collection<GoTerm> getIsA() {
        return this.getRelatingParents(Relationship.IS_A);
    }

    public Collection<GoTerm> getRegulates() {
        return this.getRelatingParents(Relationship.REGULATES);
    }

    private static int convertToIntegerIdUnsave(String goId) {
        return Integer.parseInt(goId.substring(3));
    }

    public static int converToIntegerId(String goId) {
        if (goId.matches(goPattern)) {
            return GoTerm.convertToIntegerIdUnsave(goId);
        }
        throw new IllegalArgumentException("Argument '" + goId + "' is not a goId.");
    }

    public String getIdString() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDef(String def) {
        this.def = def;
    }

    public String getDef() {
        return this.def;
    }

    public void setObsolete() {
        this.isObsolete = true;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public int getId() {
        return GoTerm.convertToIntegerIdUnsave(this.id);
    }

    public void setNamespace(String namespace) {
        if (Namespace.BIOLOGICAL_PROCESS.toString().equalsIgnoreCase(namespace)) {
            this.setNamespace(Namespace.BIOLOGICAL_PROCESS);
        } else if (Namespace.CELLULAR_COMPONENT.toString().equalsIgnoreCase(namespace)) {
            this.setNamespace(Namespace.CELLULAR_COMPONENT);
        } else if (Namespace.MOLECULAR_FUNCTION.toString().equalsIgnoreCase(namespace)) {
            this.setNamespace(Namespace.MOLECULAR_FUNCTION);
        }
    }

    public void addAltId(String altId) {
        if (this.altIds.isEmpty()) {
            this.altIds = new ArrayList<String>();
        }
        this.altIds.add(altId);
    }

    public Collection<String> getAltIds() {
        return Collections.unmodifiableCollection(this.altIds);
    }

    public void addConsiderId(String considerId) {
        if (this.considerIds.isEmpty()) {
            this.considerIds = new ArrayList<String>();
        }
        this.considerIds.add(considerId);
    }

    public Collection<String> getConsiderIds() {
        return Collections.unmodifiableCollection(this.considerIds);
    }

    public void addRegulates(GoTerm term) {
        this.addRelationship(Relationship.REGULATES, term);
    }

    public void addPartOf(GoTerm term) {
        this.addRelationship(Relationship.PART_OF, term);
    }

    public void addPositivelyRegulates(GoTerm term) {
        this.addRelationship(Relationship.POSITIVELY_REGULATES, term);
    }

    public void addNegativelyRegulates(GoTerm term) {
        this.addRelationship(Relationship.NEGATIVELY_REGULATES, term);
    }

    public String toString() {
        return this.id;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setAvgDepth(double avgDepth) {
        this.avgDepth = avgDepth;
    }

    public double getAvgDepth() {
        return this.avgDepth;
    }

    public Collection<GoTerm> getRelatingParents(Relationship rel) {
        return this.relationships.get((Object)rel);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(GoTerm o) {
        for (String test : Arrays.asList("test")) {
            System.out.println(test);
        }
        return GoTerm.converToIntegerId(this.id) - GoTerm.converToIntegerId(o.id);
    }

    public Collection<GoTerm> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public Set<GoTerm> getAllChildren() {
        if (this.allChildren == null) {
            this.allChildren = new HashSet<GoTerm>();
            for (GoTerm child : this.children) {
                this.allChildren.add(child);
                this.allChildren.addAll(child.getAllChildren());
            }
            this.allChildren = Collections.unmodifiableSet(this.allChildren);
        }
        return this.allChildren;
    }

    public Set<GoTerm> getAllParents() {
        if (this.allParents == null) {
            this.allParents = new HashSet<GoTerm>();
            for (GoTerm parent : this.parents) {
                this.allParents.add(parent);
                this.allParents.addAll(parent.getAllParents());
            }
            this.allParents = Collections.unmodifiableSet(this.allParents);
        }
        return this.allParents;
    }

    public Set<String> getAllChildrenIds() {
        if (this.allChildrenIds == null) {
            this.allChildrenIds = this.toStringArray(this.getAllChildren());
        }
        return this.allChildrenIds;
    }

    public Set<String> getAllParentIds() {
        if (this.allParentIds == null) {
            this.allParentIds = this.toStringArray(this.getAllParents());
        }
        return this.allParentIds;
    }

    private Set<String> toStringArray(Set<GoTerm> allChildrenSet) {
        int size = allChildrenSet.size();
        HashSet<String> output = new HashSet<String>(size);
        for (GoTerm goTerm : allChildrenSet) {
            output.add(goTerm.getIdString());
        }
        return output;
    }

    public static enum Relationship {
        IS_A,
        PART_OF,
        REGULATES,
        POSITIVELY_REGULATES,
        NEGATIVELY_REGULATES;

    }

    public static enum Namespace {
        BIOLOGICAL_PROCESS('P'),
        MOLECULAR_FUNCTION('F'),
        CELLULAR_COMPONENT('C'),
        UNDEFINED('U');

        private final char charRepresentation;

        private Namespace(char representation) {
            this.charRepresentation = representation;
        }

        public char getCharRepresentation() {
            return this.charRepresentation;
        }
    }
}

