/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.goString;

import de.berlin.hu.ppi.parser.goString.GoTerm;
import de.berlin.hu.wbi.common.misc.Timer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class Go {
    private Map<String, GoTerm> geneOntology = new HashMap<String, GoTerm>();

    private Go() {
    }

    public static void serialize(Go go, String file) throws FileNotFoundException, IOException {
        ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(file))));
        for (GoTerm term : go.getGoTerms()) {
            output.writeObject(term);
        }
    }

    public static Go deserialize(String file) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(file))));
        GoTerm term = (GoTerm)input.readObject();
        Go go = null;
        while (term != null) {
            go = new Go();
            go.geneOntology.put(term.getIdString(), term);
        }
        return go;
    }

    public static Go parseUrl(String url) throws IOException {
        return Go.parse(new URL(url));
    }

    public static Go parseFile(String file) throws FileNotFoundException {
        return Go.parse(new File(file));
    }

    public static Go parse(File file) throws FileNotFoundException {
        return Go.parseStream(new FileInputStream(file));
    }

    public static Go parse(URL url) throws IOException {
        return Go.parseStream(url.openStream());
    }

    public static Go parseStream(InputStream input) {
        Go output = new Go();
        output.parse(input);
        return output;
    }

    private static boolean equals(String a, String b) {
        return a.equals(b);
    }

    private GoTerm getTerm(String goId) {
        GoTerm term = this.geneOntology.get(goId);
        if (term == null) {
            term = new GoTerm(goId);
            this.geneOntology.put(goId, term);
        }
        return term;
    }

    public void parse(InputStream input) {
        Scanner scan = new Scanner(new BufferedInputStream(input));
        GoTerm term = null;
        String line = "";
        while (scan.hasNextLine() && !line.startsWith("[Typedef]")) {
            String[] items;
            String firstItem;
            line = scan.nextLine();
            if (line.trim().isEmpty() || Go.equals("[Term]", firstItem = (items = line.split(" "))[0])) continue;
            if (Go.equals("id:", firstItem)) {
                String id = items[1];
                term = this.getTerm(id);
                continue;
            }
            if (Go.equals("name:", firstItem)) {
                int start = firstItem.length() + 1;
                String name = line.substring(start);
                term.setName(name.trim());
                continue;
            }
            if (Go.equals("namespace:", firstItem)) {
                String nameSpace = items[1];
                term.setNamespace(nameSpace.trim());
                continue;
            }
            if (Go.equals("def:", firstItem)) {
                int start = line.indexOf(34);
                int end = line.indexOf(34, start + 1);
                String def = line.substring(start, end + 1);
                term.setDef(def.trim());
                continue;
            }
            if (Go.equals("is_a:", firstItem)) {
                String isA = items[1];
                term.addIsA(this.getTerm(isA));
                continue;
            }
            if (Go.equals("alt_id:", firstItem)) {
                String altId = items[1];
                term.addAltId(altId);
                continue;
            }
            if (Go.equals("relationship:", firstItem)) {
                String type = items[1];
                String goId = items[2];
                if ("part_of".equals(type)) {
                    term.addPartOf(this.getTerm(goId));
                    continue;
                }
                if ("positively_regulates".equals(type)) {
                    term.addPositivelyRegulates(this.getTerm(goId));
                    continue;
                }
                if ("negatively_regulates".equals(type)) {
                    term.addNegativelyRegulates(this.getTerm(goId));
                    continue;
                }
                if ("regulates".equals(type)) {
                    term.addRegulates(this.getTerm(goId));
                    continue;
                }
                System.out.println(type);
                continue;
            }
            if (Go.equals("is_obsolete:", firstItem)) {
                term.setObsolete();
                continue;
            }
            if (!Go.equals("consider:", firstItem)) continue;
            String considerId = items[1];
            term.addConsiderId(considerId);
        }
    }

    private int determineMinDepth(GoTerm term) {
        int minDepth = Integer.MAX_VALUE;
        if (term.getMinDepth() != -1) {
            return term.getMinDepth();
        }
        for (GoTerm parent : term.getParents()) {
            int minDepthParent = this.determineMinDepth(parent);
            minDepth = Math.min(minDepth, minDepthParent + 1);
        }
        if (minDepth == Integer.MAX_VALUE) {
            minDepth = 0;
        }
        term.setMinDepth(minDepth);
        return minDepth;
    }

    private int determineMaxDepth(GoTerm term) {
        int maxDepth = 0;
        if (term.getMaxDepth() != -1) {
            return term.getMaxDepth();
        }
        for (GoTerm parent : term.getParents()) {
            int maxDepthParent = this.determineMaxDepth(parent);
            maxDepth = Math.max(maxDepth, maxDepthParent + 1);
        }
        term.setMaxDepth(maxDepth);
        return maxDepth;
    }

    private double determineAvgDepth(GoTerm term) {
        double avgDepth = 0.0;
        if (term.getAvgDepth() != -1.0) {
            avgDepth = term.getAvgDepth();
        } else {
            Collection<GoTerm> parents = term.getParents();
            int parentsCount = parents.size();
            for (GoTerm parent : parents) {
                double parentAvgDepth = this.determineAvgDepth(parent);
                avgDepth += parentAvgDepth + 1.0;
            }
            if (parentsCount != 0) {
                avgDepth /= (double)parentsCount;
            }
        }
        term.setAvgDepth(avgDepth);
        return avgDepth;
    }

    public void determineAncestors() {
        for (GoTerm term : this.geneOntology.values()) {
            if (term.isObsolete()) continue;
            this.determineMinDepth(term);
            this.determineMaxDepth(term);
            this.determineAvgDepth(term);
        }
    }

    public void doPostProcessing() {
        for (GoTerm term : this.geneOntology.values()) {
            term.doPostProcessing();
        }
        this.determineAncestors();
    }

    public Collection<GoTerm> getGoTerms() {
        return Collections.unmodifiableCollection(this.geneOntology.values());
    }

    public GoTerm[] getGoTermsArray() {
        Collection<GoTerm> terms = this.getGoTerms();
        GoTerm[] output = new GoTerm[terms.size()];
        terms.toArray(output);
        return output;
    }

    public GoTerm[] getMaxPath(GoTerm termId) {
        int pathLength = this.geneOntology.get(termId).getMaxDepth() + 1;
        GoTerm[] path = new GoTerm[pathLength];
        this.getMaxPath(termId, path);
        return path;
    }

    private void getMaxPath(GoTerm termId, GoTerm[] path) {
        GoTerm term = this.geneOntology.get(termId);
        if (term.getMaxDepth() > 0) {
            Collection<GoTerm> parents = term.getParents();
            GoTerm maxParent = null;
            int maxDepth = 0;
            for (GoTerm parentTerm : parents) {
                int parentMaxDepth = parentTerm.getMaxDepth();
                if (parentMaxDepth < maxDepth) continue;
                maxParent = parentTerm;
                maxDepth = parentMaxDepth;
            }
            this.getMaxPath(maxParent, path);
        }
        path[term.getMaxDepth()] = termId;
    }

    public void printPath(int[] path, PrintStream out) {
        for (int i : path) {
            out.println(this.geneOntology.get(i).getName());
        }
    }

    public static String toGoId(int id) {
        return String.format("GO:%07d", id);
    }

    public GoTerm getGoTerm(int id) {
        return this.geneOntology.get(Go.toGoId(id));
    }

    public GoTerm getGoTerm(String id) {
        return this.geneOntology.get(id);
    }

    public Set<String> getAllChildren(String id) {
        return this.geneOntology.get(id).getAllChildrenIds();
    }

    public Set<String> getAllParents(String id) {
        return this.geneOntology.get(id).getAllParentIds();
    }

    public static void main(String[] args) throws IOException {
        Timer t = Timer.startTimerMilli();
        Go go = Go.parseFile("/vol/fob-vol5/mi06/arzt/Desktop/test/go/go.obo");
        t.print("Time: ");
        go.doPostProcessing();
        for (GoTerm term : go.getGoTerms()) {
            System.out.println(term);
            System.out.println(term.getChildren());
            System.out.println(term.getAllChildren());
            System.out.println(term.getParents());
            System.out.println(term.getAllParents());
            System.out.println();
        }
    }
}

