/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.go;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;

public class GoTerm
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String idString = "";
    private String name = "";
    private String def = "";
    private int id = -1;
    private int minDepth = -1;
    private int maxDepth = -1;
    private double avgDepth = -1.0;
    private boolean isObsolete = false;
    private Namespace namespace = Namespace.UNDEFINED;
    private int[][] relationships = new int[5][0];
    private int[] altIds = new int[0];
    private int[] considerIds = new int[0];
    private int[] parents = new int[0];
    private int[] children = new int[0];
    private static final String goPattern = "GO:\\d\\d\\d\\d\\d\\d\\d";

    public static int[] convertToIntegerIds(Set<String> integers) {
        int[] output = new int[integers.size()];
        int i = 0;
        for (String s : integers) {
            output[i] = GoTerm.convertToIntegerIdUnsave(s);
            ++i;
        }
        return output;
    }

    public void setIsA(Set<String> isASet) {
        this.relationships[Relationship.IS_A.ordinal()] = GoTerm.convertToIntegerIds(isASet);
    }

    public void doPostProcessing() {
        int parentCount = this.getIsA().length + this.getPartOf().length + this.getRegulates().length + this.getNegativelyRegulates().length + this.getPositivelyRegulates().length;
        this.parents = new int[parentCount];
        int offset = 0;
        for (Relationship r : Relationship.values()) {
            int i = r.ordinal();
            System.arraycopy(this.relationships[i], 0, this.parents, offset, this.relationships[i].length);
            offset += this.relationships[i].length;
        }
        Arrays.sort(this.parents);
    }

    public int[] getParents() {
        return this.parents;
    }

    public void setIsA(int[] isA) {
        this.setRelatingParents(Relationship.IS_A, isA);
    }

    public int[] getIsA() {
        return this.getRelatingParents(Relationship.IS_A);
    }

    public void setPartOf(Set<String> partOfSet) {
        this.setPartOf(GoTerm.convertToIntegerIds(partOfSet));
    }

    public void setPartOf(int[] partOf) {
        this.setRelatingParents(Relationship.PART_OF, partOf);
    }

    public int[] getPartOf() {
        return this.getRelatingParents(Relationship.PART_OF);
    }

    public void setRegulates(Set<String> regulatesSet) {
        this.setRegulates(GoTerm.convertToIntegerIds(regulatesSet));
    }

    public void setRegulates(int[] regulates) {
        this.setRelatingParents(Relationship.REGULATES, regulates);
    }

    public int[] getRegulates() {
        return this.getRelatingParents(Relationship.REGULATES);
    }

    public void setIdString(String idString) {
        if (idString != null && idString.matches(goPattern)) {
            this.idString = idString;
            this.id = GoTerm.convertToIntegerIdUnsave(idString);
        }
    }

    private static int convertToIntegerIdUnsave(String goId) {
        return Integer.parseInt(goId.substring(3));
    }

    public static int converToIntegerId(String goId) {
        if (goId.matches(goPattern)) {
            return GoTerm.convertToIntegerIdUnsave(goId);
        }
        throw new IllegalArgumentException("Argument '" + goId + "' is not a goId.");
    }

    public String getIdString() {
        return this.idString;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDef(String def) {
        this.def = def;
    }

    public String getDef() {
        return this.def;
    }

    public void setObsolete() {
        this.isObsolete = true;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public int getId() {
        return this.id;
    }

    public void setNamespace(String namespace) {
        if (Namespace.BIOLOGICAL_PROCESS.toString().equalsIgnoreCase(namespace)) {
            this.setNamespace(Namespace.BIOLOGICAL_PROCESS);
        } else if (Namespace.CELLULAR_COMPONENT.toString().equalsIgnoreCase(namespace)) {
            this.setNamespace(Namespace.CELLULAR_COMPONENT);
        } else if (Namespace.MOLECULAR_FUNCTION.toString().equalsIgnoreCase(namespace)) {
            this.setNamespace(Namespace.MOLECULAR_FUNCTION);
        }
    }

    public void setAltIds(Set<String> altIds) {
        this.altIds = GoTerm.convertToIntegerIds(altIds);
    }

    public void setAltIds(int[] altIds) {
        this.altIds = altIds;
    }

    public int[] getAltIds() {
        return this.altIds;
    }

    public void setConsiderIds(Set<String> considerIds) {
        this.considerIds = GoTerm.convertToIntegerIds(considerIds);
    }

    public void setConsiderIds(int[] considerIds) {
        this.considerIds = considerIds;
    }

    public int[] getConsiderIds() {
        return this.considerIds;
    }

    public void setPositivelyRegulates(int[] positively_regulates) {
        this.setRelatingParents(Relationship.POSITIVELY_REGULATES, positively_regulates);
    }

    public int[] getPositivelyRegulates() {
        return this.getRelatingParents(Relationship.POSITIVELY_REGULATES);
    }

    public void setNegativelyRegulates(int[] negativelyRegulates) {
        this.setRelatingParents(Relationship.NEGATIVELY_REGULATES, negativelyRegulates);
    }

    public int[] getNegativelyRegulates() {
        return this.getRelatingParents(Relationship.NEGATIVELY_REGULATES);
    }

    public void setNegativelyRegulates(Set<String> negativelyRegulatesSet) {
        this.setNegativelyRegulates(GoTerm.convertToIntegerIds(negativelyRegulatesSet));
    }

    public void setPositivelyRegulates(Set<String> positivelyRegulatesSet) {
        this.setPositivelyRegulates(GoTerm.convertToIntegerIds(positivelyRegulatesSet));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneOntologyTerm [idString=");
        builder.append(this.idString);
        builder.append(", isObsolete=");
        builder.append(this.isObsolete);
        builder.append(", parents=");
        builder.append(Arrays.toString(this.getParents()));
        builder.append("]");
        return builder.toString();
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setAvgDepth(double avgDepth) {
        this.avgDepth = avgDepth;
    }

    public double getAvgDepth() {
        return this.avgDepth;
    }

    public int[] getRelatingParents(Relationship rel) {
        return this.relationships[rel.ordinal()];
    }

    public void setRelatingParents(Relationship rel, int[] parents) {
        this.relationships[rel.ordinal()] = parents;
    }

    public int hashCode() {
        return this.id;
    }

    public static enum Relationship {
        IS_A,
        PART_OF,
        REGULATES,
        POSITIVELY_REGULATES,
        NEGATIVELY_REGULATES;

    }

    public static enum Namespace {
        BIOLOGICAL_PROCESS('P'),
        MOLECULAR_FUNCTION('F'),
        CELLULAR_COMPONENT('C'),
        UNDEFINED('U');

        private final char charRepresentation;

        private Namespace(char representation) {
            this.charRepresentation = representation;
        }

        public char getCharRepresentation() {
            return this.charRepresentation;
        }
    }
}

