/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser.go;

import de.berlin.hu.ppi.parser.go.GoTerm;
import de.berlin.hu.ppi.tool.Timer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class Go
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<GoTerm> terms;
    private Map<Integer, GoTerm> geneOntology;

    private Go() {
    }

    public static Go parseUrl(String url) throws IOException {
        return Go.parse(new URL(url));
    }

    public static Go parseFile(String file) throws FileNotFoundException {
        return Go.parse(new File(file));
    }

    public static Go parse(File file) throws FileNotFoundException {
        return Go.parseStream(new FileInputStream(file));
    }

    public static Go parse(URL url) throws IOException {
        return Go.parseStream(url.openStream());
    }

    public static Go parseStream(InputStream input) {
        Go output = new Go();
        output.parse(input);
        return output;
    }

    private static boolean equals(String a, String b) {
        return a.equals(b);
    }

    public void parse(InputStream input) {
        Scanner scan = new Scanner(new BufferedInputStream(input));
        this.terms = new ArrayList<GoTerm>(100000);
        HashSet<String> isASet = new HashSet<String>();
        HashSet<String> partOfSet = new HashSet<String>();
        HashSet<String> regulatesSet = new HashSet<String>();
        HashSet<String> negativelyRegulatesSet = new HashSet<String>();
        HashSet<String> positivelyRegulatesSet = new HashSet<String>();
        HashSet<String> altIds = new HashSet<String>();
        HashSet<String> considerIds = new HashSet<String>();
        GoTerm term = null;
        String line = "";
        while (scan.hasNextLine() && !line.startsWith("[Typedef]")) {
            line = scan.nextLine();
            if (line.trim().isEmpty()) continue;
            String[] items = line.split(" ");
            String firstItem = items[0];
            if (Go.equals("[Term]", firstItem)) {
                if (term != null) {
                    term.setIsA(isASet);
                    term.setPartOf(partOfSet);
                    term.setRegulates(regulatesSet);
                    term.setNegativelyRegulates(negativelyRegulatesSet);
                    term.setPositivelyRegulates(positivelyRegulatesSet);
                    term.setAltIds(altIds);
                    term.setConsiderIds(considerIds);
                    altIds.clear();
                    isASet.clear();
                    partOfSet.clear();
                    regulatesSet.clear();
                    negativelyRegulatesSet.clear();
                    positivelyRegulatesSet.clear();
                    considerIds.clear();
                }
                term = new GoTerm();
                this.getTerms().add(term);
                continue;
            }
            if (Go.equals("id:", firstItem)) {
                String id = items[1];
                term.setIdString(id);
                continue;
            }
            if (Go.equals("name:", firstItem)) {
                int start = firstItem.length() + 1;
                String name = line.substring(start);
                term.setName(name.trim());
                continue;
            }
            if (Go.equals("namespace:", firstItem)) {
                String nameSpace = items[1];
                term.setNamespace(nameSpace.trim());
                continue;
            }
            if (Go.equals("def:", firstItem)) {
                int start = line.indexOf(34);
                int end = line.indexOf(34, start + 1);
                String def = line.substring(start, end + 1);
                term.setDef(def.trim());
                continue;
            }
            if (Go.equals("is_a:", firstItem)) {
                String isA = items[1];
                isASet.add(isA);
                continue;
            }
            if (Go.equals("alt_id:", firstItem)) {
                String altId = items[1];
                altIds.add(altId);
                continue;
            }
            if (Go.equals("relationship:", firstItem)) {
                String type = items[1];
                String goId = items[2];
                if ("part_of".equals(type)) {
                    partOfSet.add(goId);
                    continue;
                }
                if ("positively_regulates".equals(type)) {
                    positivelyRegulatesSet.add(goId);
                    continue;
                }
                if ("negatively_regulates".equals(type)) {
                    negativelyRegulatesSet.add(goId);
                    continue;
                }
                if ("regulates".equals(type)) {
                    regulatesSet.add(goId);
                    continue;
                }
                System.out.println(type);
                continue;
            }
            if (Go.equals("is_obsolete:", firstItem)) {
                term.setObsolete();
                continue;
            }
            if (!Go.equals("consider:", firstItem)) continue;
            String considerId = items[1];
            considerIds.add(considerId);
        }
        if (term != null) {
            term.setIsA(isASet);
            term.setPartOf(partOfSet);
            term.setRegulates(regulatesSet);
            term.setNegativelyRegulates(negativelyRegulatesSet);
            term.setPositivelyRegulates(positivelyRegulatesSet);
            term.setAltIds(altIds);
            term.setConsiderIds(considerIds);
            altIds.clear();
            isASet.clear();
            partOfSet.clear();
            regulatesSet.clear();
            negativelyRegulatesSet.clear();
            positivelyRegulatesSet.clear();
            considerIds.clear();
        }
    }

    private int determineMinDepth(int termId) {
        GoTerm term = this.geneOntology.get(termId);
        int minDepth = Integer.MAX_VALUE;
        if (term.getMinDepth() != -1) {
            return term.getMinDepth();
        }
        for (int parent : term.getParents()) {
            int minDepthParent = this.determineMinDepth(parent);
            minDepth = Math.min(minDepth, minDepthParent + 1);
        }
        if (minDepth == Integer.MAX_VALUE) {
            minDepth = 0;
        }
        term.setMinDepth(minDepth);
        return minDepth;
    }

    private int determineMaxDepth(int termId) {
        GoTerm term = this.geneOntology.get(termId);
        int maxDepth = 0;
        if (term.getMaxDepth() != -1) {
            return term.getMaxDepth();
        }
        for (int parent : term.getParents()) {
            int maxDepthParent = this.determineMaxDepth(parent);
            maxDepth = Math.max(maxDepth, maxDepthParent + 1);
        }
        term.setMaxDepth(maxDepth);
        return maxDepth;
    }

    private double determineAvgDepth(int termId) {
        double avgDepth = 0.0;
        GoTerm term = this.geneOntology.get(termId);
        if (term.getAvgDepth() != -1.0) {
            avgDepth = term.getAvgDepth();
        } else {
            int[] parents = term.getParents();
            int parentsCount = parents.length;
            for (int parent : parents) {
                double parentAvgDepth = this.determineAvgDepth(parent);
                avgDepth += parentAvgDepth + 1.0;
            }
            if (parentsCount != 0) {
                avgDepth /= (double)parentsCount;
            }
        }
        term.setAvgDepth(avgDepth);
        return avgDepth;
    }

    public void determineAncestors() {
        for (GoTerm term : this.terms) {
            if (term.isObsolete()) continue;
            this.determineMinDepth(term.getId());
            this.determineMaxDepth(term.getId());
            this.determineAvgDepth(term.getId());
        }
    }

    public void doPostProcessing() {
        this.geneOntology = new HashMap<Integer, GoTerm>();
        for (GoTerm term : this.terms) {
            term.doPostProcessing();
            this.geneOntology.put(term.getId(), term);
        }
        this.determineAncestors();
    }

    public List<GoTerm> getTerms() {
        return this.terms;
    }

    public int[] getMaxPath(int termId) {
        int pathLength = this.geneOntology.get(termId).getMaxDepth() + 1;
        int[] path = new int[pathLength];
        this.getMaxPath(termId, path);
        return path;
    }

    public void getMaxPath(int termId, int[] path) {
        GoTerm term = this.geneOntology.get(termId);
        if (term.getMaxDepth() > 0) {
            int[] parents = term.getParents();
            GoTerm parentTerm = this.geneOntology.get(parents[0]);
            int maxParent = parentTerm.getId();
            int maxDepth = parentTerm.getMaxDepth();
            for (int i = 1; i < parents.length; ++i) {
                parentTerm = this.geneOntology.get(parents[i]);
                int parentMaxDepth = parentTerm.getMaxDepth();
                if (parentMaxDepth < maxDepth) continue;
                maxParent = i;
                maxDepth = parentMaxDepth;
            }
            this.getMaxPath(maxParent, path);
        }
        path[term.getMaxDepth()] = termId;
    }

    public Set<GoTerm> getAllParents(GoTerm term) {
        HashSet<GoTerm> parents = new HashSet<GoTerm>();
        int parentCount = parents.size();
        for (int parent : term.getParents()) {
            parents.add(this.geneOntology.get(parent));
        }
        while (parents.size() > parentCount) {
            parentCount = parents.size();
            for (GoTerm parentTerm : new ArrayList<GoTerm>(parents)) {
                for (int parent : parentTerm.getParents()) {
                    parents.add(this.geneOntology.get(parent));
                }
            }
        }
        return parents;
    }

    public Set<GoTerm> getAllChildren(GoTerm term) {
        HashSet<GoTerm> output = new HashSet<GoTerm>();
        return output;
    }

    public void printPath(int[] path, PrintStream out) {
        for (int i : path) {
            out.println(this.geneOntology.get(i).getName());
        }
    }

    public static String toGoId(int id) {
        return String.format("GO:%07d", id);
    }

    public GoTerm getTerm(int i) {
        return this.geneOntology.get(i);
    }

    public static void main(String[] args) throws IOException {
        Timer t = Timer.startTimer();
        Go geneOntology = Go.parseFile("/vol/fob-vol5/mi06/arzt/Desktop/go/gene_ontology.1_2.obo");
        geneOntology.doPostProcessing();
        geneOntology.getTerm(1).getAvgDepth();
        t.print("Time: ");
        List<GoTerm> allParents = geneOntology.getTerms();
        for (GoTerm term : allParents) {
            System.out.println(term.getIdString() + ": " + term.getAvgDepth());
        }
    }
}

