/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser;

import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.Quotes;
import de.berlin.hu.ppi.parser.object.Tag;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlOwlParser {
    private Pattern space = Pattern.compile("\\s+");
    private Pattern start = Pattern.compile("<");
    private Pattern end = Pattern.compile(">");
    private Pattern owl = Pattern.compile("<([^\\!\\?])..[^:]*?(\\s|>)");
    private int prefixSkipPosition;
    private Scanner scanner;
    private String putativeValue;

    public XmlOwlParser(boolean withPrefix) {
        this.prefixSkipPosition = withPrefix ? 3 : 0;
    }

    public void openReader(Reader reader) throws FileNotFoundException, FileParsingException {
        this.scanner = new Scanner(new BufferedReader(reader));
        this.determineFirstTag();
    }

    private void determineFirstTag() throws FileParsingException {
        this.scanner.useDelimiter(this.owl);
        if (this.scanner.hasNext()) {
            this.scanner.next();
            this.scanner.useDelimiter(this.end);
            if (!this.scanner.hasNext()) {
                throw new FileParsingException("No normal bioPax tag was found");
            }
        } else {
            throw new FileParsingException("No normal bioPax tag was found");
        }
    }

    public boolean hasNextTag() {
        this.scanner.useDelimiter(this.start);
        if (!this.scanner.hasNext()) {
            return false;
        }
        this.putativeValue = this.scanner.next().substring(1).trim();
        return this.scanner.hasNext();
    }

    public Tag getNextTag() throws FileParsingException {
        this.scanner.useDelimiter(this.end);
        if (!this.scanner.hasNext()) {
            throw new FileParsingException("expected " + this.end.toString());
        }
        String tmp = this.scanner.next().substring(1).trim();
        Quotes quotes = new Quotes(tmp);
        while (quotes.hasOddCount()) {
            if (!this.scanner.hasNext()) {
                throw new FileParsingException("Couldn't find tag with even count of quotes");
            }
            String tmp2 = this.scanner.next().trim();
            quotes.append(tmp2);
            tmp = tmp.concat(tmp2);
        }
        return this.createTag(tmp, quotes);
    }

    private Tag createTag(String tagAndAttributes, Quotes quotes) throws FileParsingException {
        Tag tag = new Tag();
        Matcher spaces = this.space.matcher(tagAndAttributes);
        if (tagAndAttributes.charAt(0) != '/') {
            this.prefixSkipPosition = Character.toLowerCase(tagAndAttributes.charAt(0)) == 'b' && Character.toLowerCase(tagAndAttributes.charAt(1)) == 'p' && tagAndAttributes.charAt(2) == ':' ? 3 : 0;
            if (spaces.find()) {
                this.setAttributeAndName(tagAndAttributes, tag, spaces, quotes);
                if (tagAndAttributes.charAt(tagAndAttributes.length() - 1) == '/') {
                    tag.setType(Tag.TagType.COMPLETE_TAG);
                } else {
                    tag.setType(Tag.TagType.OPENING_TAG);
                }
            } else if (tagAndAttributes.charAt(tagAndAttributes.length() - 1) == '/') {
                tag.setType(Tag.TagType.USELESS_TAG);
            } else {
                tag.setName(this.transformName(tagAndAttributes.substring(this.prefixSkipPosition)));
                tag.setType(Tag.TagType.OPENING_TAG);
            }
        } else {
            this.prefixSkipPosition = Character.toLowerCase(tagAndAttributes.charAt(1)) == 'b' && Character.toLowerCase(tagAndAttributes.charAt(2)) == 'p' && tagAndAttributes.charAt(3) == ':' ? 3 : 0;
            tag.setName(this.transformName(tagAndAttributes.substring(this.prefixSkipPosition + 1)));
            tag.setType(Tag.TagType.ENDING_TAG);
        }
        return tag;
    }

    private void setAttributeAndName(String tagAndAttributes, Tag tag, Matcher spaces, Quotes quotes) throws FileParsingException {
        tag.setName(this.transformName(tagAndAttributes.substring(this.prefixSkipPosition, spaces.start())));
        int position = tagAndAttributes.indexOf("=", spaces.end());
        if (position == -1) {
            throw new FileParsingException("No attribute(s) for tag " + tag.getName() + " found");
        }
        do {
            String key = tagAndAttributes.substring(spaces.end(), position).trim().toLowerCase();
            if (!quotes.hasNext()) {
                throw new FileParsingException("expected \" for the value of attribute " + key + " in tag " + tag.getName());
            }
            int firstPosition = quotes.getNext() + 1;
            if (!quotes.hasNext()) {
                throw new FileParsingException("expected \" for the value of attribute " + key + " in tag " + tag.getName());
            }
            position = quotes.getNext();
            if (position == firstPosition) continue;
            String value = tagAndAttributes.substring(firstPosition, position);
            if (value.charAt(0) == '#') {
                value = value.substring(1);
            }
            tag.addAttribute(key, value);
        } while (spaces.find(position + 1) && (position = tagAndAttributes.indexOf("=", spaces.end())) != -1);
    }

    private String transformName(String name) {
        StringBuilder transformed = new StringBuilder(name);
        int position = 0;
        transformed.setCharAt(position, Character.toUpperCase(transformed.charAt(position)));
        ++position;
        while (position < transformed.length()) {
            char c = transformed.charAt(position);
            if (c != '-') {
                transformed.setCharAt(position, Character.toLowerCase(c));
            } else {
                transformed.deleteCharAt(position);
                transformed.setCharAt(position, Character.toUpperCase(transformed.charAt(position)));
            }
            ++position;
        }
        return transformed.toString();
    }

    public String getPutativeValue() {
        return this.putativeValue;
    }

    public void close() {
        this.scanner.close();
    }

    public static void main(String[] args) throws FileNotFoundException, FileParsingException {
        XmlOwlParser obj = new XmlOwlParser(true);
        obj.openReader(new FileReader("biopax sample/biopaxTest2.owl"));
        do {
            Tag tag = obj.getNextTag();
            System.out.println(tag.toString());
        } while (obj.hasNextTag());
        obj.close();
    }
}

