/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser;

import java.util.ArrayList;
import java.util.List;

public class Quotes {
    private List<Integer> quotePosition = new ArrayList<Integer>();
    private int index = -1;
    private int lengthOfString = 0;

    public Quotes(String stringWithQuotes) {
        this.determineQuotesPositions(stringWithQuotes);
        this.lengthOfString = stringWithQuotes.length();
    }

    protected void determineQuotesPositions(String stringWithQuotes) {
        int position = stringWithQuotes.indexOf("\"");
        while (position != -1) {
            this.quotePosition.add(position + this.lengthOfString);
            position = stringWithQuotes.indexOf("\"", this.quotePosition.get(this.quotePosition.size() - 1) + 1);
        }
    }

    public void append(String stringWithQuotes) {
        this.determineQuotesPositions(stringWithQuotes);
        this.lengthOfString += stringWithQuotes.length();
    }

    public void reset() {
        this.index = -1;
    }

    public int getCount() {
        return this.quotePosition.size();
    }

    public boolean hasOddCount() {
        return this.quotePosition.size() % 2 != 0;
    }

    public boolean hasNext() {
        return this.index + 2 <= this.quotePosition.size();
    }

    public int getNext() throws IndexOutOfBoundsException {
        ++this.index;
        if (this.index == this.quotePosition.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.quotePosition.get(this.index);
    }

    public static void main(String[] args) {
        String tmp1 = "<tag attr1=\"foo\" attr2=\"";
        String tmp2 = "bar\"";
        Quotes quotes = new Quotes(tmp1);
        if (quotes.hasOddCount()) {
            System.out.println("odd");
            quotes.append(tmp2);
        } else {
            System.out.println("arg");
        }
        tmp1 = tmp1.concat(tmp2);
        System.out.println(tmp1.substring(quotes.getNext(), quotes.getNext()));
        System.out.println(tmp1.substring(quotes.getNext(), quotes.getNext()));
    }
}

