/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser;

import de.berlin.hu.ppi.parser.BioPaxParser;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.object.Edge;
import de.berlin.hu.ppi.parser.object.ExternalRef;
import de.berlin.hu.ppi.parser.object.Graph;
import de.berlin.hu.ppi.parser.object.InterConnection;
import de.berlin.hu.ppi.parser.object.Vertex;
import de.berlin.hu.ppi.parser.object.VertexPair;
import de.berlin.hu.ppi.parser.object.biopax.Attribute;
import de.berlin.hu.ppi.parser.object.biopax.Biochemicalreaction;
import de.berlin.hu.ppi.parser.object.biopax.Biosource;
import de.berlin.hu.ppi.parser.object.biopax.Catalysis;
import de.berlin.hu.ppi.parser.object.biopax.Complex;
import de.berlin.hu.ppi.parser.object.biopax.Complexassembly;
import de.berlin.hu.ppi.parser.object.biopax.Control;
import de.berlin.hu.ppi.parser.object.biopax.Conversion;
import de.berlin.hu.ppi.parser.object.biopax.Dna;
import de.berlin.hu.ppi.parser.object.biopax.Entity;
import de.berlin.hu.ppi.parser.object.biopax.Interaction;
import de.berlin.hu.ppi.parser.object.biopax.Modulation;
import de.berlin.hu.ppi.parser.object.biopax.Opencontrolledvocabulary;
import de.berlin.hu.ppi.parser.object.biopax.Pathway;
import de.berlin.hu.ppi.parser.object.biopax.Pathwaystep;
import de.berlin.hu.ppi.parser.object.biopax.PhysicalEntitySubclass;
import de.berlin.hu.ppi.parser.object.biopax.Physicalentity;
import de.berlin.hu.ppi.parser.object.biopax.Physicalentityparticipant;
import de.berlin.hu.ppi.parser.object.biopax.Physicalinteraction;
import de.berlin.hu.ppi.parser.object.biopax.Protein;
import de.berlin.hu.ppi.parser.object.biopax.Rna;
import de.berlin.hu.ppi.parser.object.biopax.Sequenceparticipant;
import de.berlin.hu.ppi.parser.object.biopax.Smallmolecule;
import de.berlin.hu.ppi.parser.object.biopax.Transport;
import de.berlin.hu.ppi.parser.object.biopax.Transportwithbiochemicalreaction;
import de.berlin.hu.ppi.parser.object.biopax.Unificationxref;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PathwayParser {
    protected List<Graph> pathways = new ArrayList<Graph>();
    protected Map<String, Vertex> vertices;
    protected Map<String, Edge> edges;
    private Map<String, Vertex> processedVertices;
    private Map<String, Edge> processedEdges;
    protected BioPaxParser biopaxParser;
    private Set<String> processedIds = new HashSet<String>();
    protected List<InterConnection> interConnections;
    private boolean withPrefix;

    public PathwayParser(boolean withPrefix) {
        this.processedEdges = new HashMap<String, Edge>();
        this.processedVertices = new HashMap<String, Vertex>();
        this.withPrefix = withPrefix;
    }

    public void parseFile(String file) throws FileNotFoundException, FileParsingException, InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        File f = new File(file);
        if (!f.exists()) {
            throw new FileNotFoundException("File " + file + "does not exist");
        }
        this.generatePathway(new FileReader(f));
    }

    public void parseFiles(String directory) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, FileParsingException, FileNotFoundException {
        File dir = new File(directory);
        String[] files = dir.list();
        int i = 0;
        try {
            for (i = 0; i < files.length; ++i) {
                System.out.println("Process file: " + files[i]);
                this.generatePathway(new FileReader(directory + files[i]));
            }
        }
        catch (FileParsingException e) {
            throw new FileParsingException("In File: " + files[i] + " following error occured: " + e.getMessage());
        }
        System.out.println("processed " + files.length + " files");
    }

    private String getFirstElement(Attribute attr, String message) throws FileParsingException {
        if (attr.size() == 0) {
            throw new FileParsingException(message);
        }
        return attr.get(0);
    }

    private String getFirstElement(Attribute attr) {
        if (attr.size() != 0) {
            return attr.get(0);
        }
        return null;
    }

    private Attribute checkIfEmpty(Attribute attr, String message) throws FileParsingException {
        if (attr.size() == 0) {
            throw new FileParsingException(message);
        }
        return attr;
    }

    public void generatePathway(Reader reader) throws FileParsingException, InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        try {
            this.biopaxParser = new BioPaxParser(reader, this.withPrefix);
            this.biopaxParser.generateEntries();
            this.generatePathwayComponents();
        }
        catch (FileParsingException e) {
            Logger.getLogger(this.getClass()).error("", e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    protected void generatePathwayComponents() throws FileParsingException {
        if (!this.biopaxParser.getPathways().hasNext()) {
            throw new FileParsingException("No pathway found");
        }
        Iterator<Entity> iterP = this.biopaxParser.getPathways();
        while (iterP.hasNext()) {
            Pathway pathway = (Pathway)iterP.next();
            Graph graph = new Graph(this.getFirstElement(pathway.getName(), "Pathway (" + pathway.getIdString() + ") has no name"));
            graph.setId(pathway.getIdString());
            graph.setShortName(this.getFirstElement(pathway.getShortName()));
            graph.setOrganism(this.getOrganism(this.getFirstElement(pathway.getOrganism())));
            this.vertices = new HashMap<String, Vertex>();
            this.edges = new HashMap<String, Edge>();
            this.interConnections = new ArrayList<InterConnection>();
            this.parsePathwayComponents(pathway.getPathwayComponents());
            graph.setVertices(this.vertices);
            graph.setEdges(this.edges);
            graph.setInterConnections(this.interConnections);
            this.pathways.add(graph);
        }
    }

    protected void parsePathwayComponents(Attribute pathwayComponents) throws FileParsingException {
        if (pathwayComponents.size() == 0) {
            System.err.println("Pathway is empty");
        }
        for (String component : pathwayComponents) {
            Pathwaystep step = (Pathwaystep)this.biopaxParser.getEntity(component);
            Attribute nextSteps = step.getNextStep();
            Attribute stepInteractions = this.checkIfEmpty(step.getStepInteractions(), "No Step-Interactions exist in Pathway-Step (" + step.getIdString() + ")");
            this.createSubgraph(stepInteractions, nextSteps);
        }
    }

    protected List<String> createSubgraph(Attribute stepInteractions, Attribute nextSteps) throws FileParsingException {
        ArrayList<String> allVertices = new ArrayList<String>();
        for (String step : stepInteractions) {
            Entity tmp = this.biopaxParser.getEntity(step);
            allVertices.addAll(this.processEntity(tmp, nextSteps));
        }
        return allVertices;
    }

    public List<String> processEntity(Entity tmp, Attribute nextSteps) throws FileParsingException {
        ArrayList<String> left = new ArrayList<String>();
        if (tmp == null) {
            return left;
        }
        ArrayList<String> right = new ArrayList<String>();
        if (tmp instanceof Conversion || tmp instanceof Biochemicalreaction || tmp instanceof Complexassembly || tmp instanceof Transport || tmp instanceof Transportwithbiochemicalreaction) {
            Conversion conversion = (Conversion)tmp;
            this.handleSubparts(conversion.getLeft(), conversion.getRight(), left, right);
            String type = this.getInteractionType(this.getFirstElement(conversion.getInteractionType()));
            if (type == null) {
                type = tmp.getClass().getSimpleName();
            }
            this.handleEdges(left, right, (Physicalinteraction)tmp, type, Edge.EdgeDirection.LEFT.ordinal(), nextSteps);
        } else if (tmp instanceof Control || tmp instanceof Catalysis || tmp instanceof Modulation) {
            String type;
            Control control = (Control)tmp;
            this.handleSubparts(control.getController(), control.getControlled(), left, right);
            int direction = Edge.EdgeDirection.LEFT.ordinal();
            if (tmp instanceof Catalysis) {
                String d;
                Catalysis catalysis = (Catalysis)control;
                if (catalysis.getCofactor().size() != 0) {
                    left.addAll(this.createSubgraph(catalysis.getCofactor(), null));
                }
                if ((d = this.getFirstElement(catalysis.getDirection())) != null) {
                    direction = this.getDirection(d);
                }
            }
            if ((type = this.getInteractionType(this.getFirstElement(control.getControlType()))) == null) {
                type = tmp.getClass().getSimpleName();
            }
            this.handleEdges(left, right, (Physicalinteraction)tmp, type, direction, nextSteps);
        } else if (tmp instanceof Physicalentityparticipant || tmp instanceof Sequenceparticipant) {
            Physicalentityparticipant pep = (Physicalentityparticipant)tmp;
            left.addAll(this.processPhysicalEntityParticipant(pep));
        } else if (tmp instanceof PhysicalEntitySubclass) {
            left.addAll(this.createVertices(tmp, null));
        } else if (tmp instanceof Complex) {
            left.addAll(this.createVertices(tmp, null));
        } else if (tmp instanceof Physicalinteraction) {
            Physicalinteraction pi = (Physicalinteraction)tmp;
            String type = this.getInteractionType(this.getFirstElement(pi.getInteractionType()));
            if (type == null) {
                type = tmp.getClass().getSimpleName();
            }
            this.handleSubparts(pi.getParticipants(), null, left, null);
            this.handleEdges(left, null, pi, type, Edge.EdgeDirection.BOTH.ordinal(), nextSteps);
        } else if (tmp instanceof Interaction) {
            Interaction interaction = (Interaction)tmp;
            this.handleSubparts(interaction.getParticipants(), null, left, null);
            String type = tmp.getClass().getSimpleName();
            this.handleEdges(left, null, interaction, type, Edge.EdgeDirection.BOTH.ordinal(), nextSteps);
        } else if (tmp instanceof Pathway) {
            InterConnection interConnection = new InterConnection();
            interConnection.setPathway(tmp.getIdString());
            this.interConnections.add(interConnection);
        } else {
            throw new FileParsingException("Unhandeld connection or meta vertex type: " + tmp.getClass().getSimpleName() + " " + tmp.getIdString());
        }
        left.addAll(right);
        return left;
    }

    public void handleSubparts(Attribute leftSpecies, Attribute rightSpecies, List<String> left, List<String> right) throws FileParsingException {
        if (leftSpecies.size() != 0) {
            left.addAll(this.createSubgraph(leftSpecies, null));
        }
        if (rightSpecies != null && rightSpecies.size() != 0) {
            right.addAll(this.createSubgraph(rightSpecies, null));
        }
    }

    public void handleEdges(List<String> left, List<String> right, Interaction i, String type, int direction, Attribute nextSteps) {
        Edge newEdge = this.createEdges(left, right, i, type, direction, nextSteps);
        this.edges.put(newEdge.getId(), newEdge);
        this.processedEdges.put(newEdge.getId(), newEdge);
        this.processedIds.add(i.getIdString());
    }

    private String getInteractionType(String tmp) throws FileParsingException {
        if (tmp == null) {
            return null;
        }
        Opencontrolledvocabulary type = (Opencontrolledvocabulary)this.biopaxParser.getEntity(tmp);
        if (type == null) {
            return tmp;
        }
        return this.getFirstElement(type.getTerm(), "Expected the attribute term in entity openControlledVocabulary");
    }

    private String getCellularLocation(String tmp) throws FileParsingException {
        if (tmp == null) {
            return null;
        }
        Opencontrolledvocabulary location = (Opencontrolledvocabulary)this.biopaxParser.getEntity(tmp);
        if (location == null) {
            return tmp;
        }
        return this.getFirstElement(location.getTerm(), "Expected the attribute term in entity openContolledVocabulary");
    }

    private String getOrganism(String tmp) throws FileParsingException {
        if (tmp == null) {
            return null;
        }
        Biosource bioSource = (Biosource)this.biopaxParser.getEntity(tmp);
        if (bioSource == null) {
            return tmp;
        }
        return this.getFirstElement(bioSource.getName(), "Expected the attribute name in entity bioSource");
    }

    protected List<String> createVertices(Entity tmp, String cellularLocation) throws FileParsingException {
        ArrayList<String> ids = new ArrayList<String>();
        String className = tmp.getClass().getSimpleName();
        if (tmp instanceof Dna || tmp instanceof Rna || tmp instanceof Protein || tmp instanceof Smallmolecule) {
            PhysicalEntitySubclass pes = (PhysicalEntitySubclass)tmp;
            Vertex vertex = new Vertex(pes.getIdString());
            this.setName(vertex, pes.getName(), pes.getShortName());
            vertex.setOrganism(this.getOrganism(this.getFirstElement(pes.getOrganism())));
            vertex.setType(className);
            vertex.setCellularLocation(cellularLocation);
            this.setUnificationXref(tmp, vertex);
            this.vertices.put(vertex.getId(), vertex);
            this.processedVertices.put(vertex.getId(), vertex);
            ids.add(vertex.getId());
        } else if (tmp instanceof Complex) {
            Complex complex = (Complex)tmp;
            Vertex vertex = new Vertex(complex.getIdString());
            this.setName(vertex, complex.getName(), complex.getShortName());
            vertex.setOrganism(this.getOrganism(this.getFirstElement(complex.getOrganism())));
            vertex.setType(className);
            vertex.setCellularLocation(cellularLocation);
            this.setUnificationXref(tmp, vertex);
            vertex.setComplex(true);
            if (complex.getComponents().size() != 0) {
                vertex.setComplexParts(this.createSubgraph(complex.getComponents(), null));
            }
            this.vertices.put(vertex.getId(), vertex);
            this.processedVertices.put(vertex.getId(), vertex);
            ids.add(vertex.getId());
            for (int i = 0; i < vertex.getComplexPartsSize(); ++i) {
                ids.add(vertex.getComplexPart(i));
            }
        } else if (tmp instanceof Physicalentity) {
            Physicalentity pe = (Physicalentity)tmp;
            Vertex vertex = new Vertex(pe.getIdString());
            this.setName(vertex, pe.getName(), pe.getShortName());
            vertex.setType(className);
            this.setUnificationXref(tmp, vertex);
            this.vertices.put(vertex.getId(), vertex);
            this.processedVertices.put(vertex.getId(), vertex);
            ids.add(vertex.getId());
        } else {
            throw new FileParsingException("Unhandeld vertex type: " + className + " " + tmp.getIdString());
        }
        return ids;
    }

    public List<String> processPhysicalEntityParticipant(Physicalentityparticipant pep) throws FileParsingException {
        ArrayList<String> ids = new ArrayList<String>();
        String cellularLocation = this.getCellularLocation(this.getFirstElement(pep.getCellularLocation()));
        if (pep.getPhysicalEntity().size() != 0) {
            Entity tmp = this.biopaxParser.getEntity(pep.getPhysicalEntity().get(0));
            if (tmp != null) {
                ids.addAll(this.createVertices(tmp, cellularLocation));
            } else {
                System.err.println("Reference to a non existing physical entity found: " + pep.getPhysicalEntity().get(0));
            }
        } else {
            System.err.println("A physical entity was not specified");
        }
        return ids;
    }

    protected void setUnificationXref(Entity tmp, Vertex vertex) {
        Attribute xrefs = tmp.getXref();
        for (String xref : xrefs) {
            Entity ref = this.biopaxParser.getEntity(xref);
            if (!(ref instanceof Unificationxref)) continue;
            Unificationxref uniXref = (Unificationxref)ref;
            String db = null;
            String id = null;
            db = this.getFirstElement(uniXref.getDb());
            id = this.getFirstElement(uniXref.getId());
            if (db == null || id == null) continue;
            vertex.addExternalRef(new ExternalRef(db, id));
        }
    }

    private void setName(Vertex vertex, Attribute name, Attribute shortName) {
        if (name.size() != 0) {
            vertex.setName(name.get(0));
            vertex.setShortName(this.getFirstElement(shortName));
        } else if (shortName.size() != 0) {
            String both = shortName.get(0);
            vertex.setName(both);
            vertex.setShortName(both);
        } else {
            System.err.println("No name specified for entity: " + vertex.getId());
        }
    }

    public Edge createEdges(List<String> left, List<String> right, Interaction i, String type, int direction, Attribute nextSteps) {
        Edge edge = new Edge(i.getIdString());
        edge.setName(this.getFirstElement(i.getName()));
        edge.setShortName(this.getFirstElement(i.getShortName()));
        edge.setType(type);
        edge.setDirection(direction);
        edge.setNextSteps(nextSteps);
        if (right != null) {
            for (String start : left) {
                for (String end : right) {
                    VertexPair pair = new VertexPair();
                    pair.setStart(start);
                    pair.setEnd(end);
                    edge.addVertexPair(pair);
                }
            }
        } else {
            for (int start = 0; start < left.size(); ++start) {
                for (int end = start + 1; end < left.size(); ++end) {
                    VertexPair pair = new VertexPair();
                    pair.setStart(left.get(start));
                    pair.setEnd(left.get(end));
                    edge.addVertexPair(pair);
                }
            }
        }
        return edge;
    }

    public int getDirection(String direction) {
        int value = Edge.EdgeDirection.LEFT.ordinal();
        if ((direction = direction.toLowerCase()).equals("reversible")) {
            value = Edge.EdgeDirection.BOTH.ordinal();
        } else if (direction.equals("physiol-left-to-right") || direction.equals("irreversible-left-to-right")) {
            value = Edge.EdgeDirection.LEFT.ordinal();
        } else if (direction.equals("physiol-right-to-left") || direction.equals("irreversible-right-to-left")) {
            value = Edge.EdgeDirection.RIGHT.ordinal();
        }
        return value;
    }

    public int getPathwaysSize() {
        return this.pathways.size();
    }

    public Graph getPathway(int index) {
        return this.pathways.get(index);
    }

    public static void main(String[] args) throws FileNotFoundException, FileParsingException, InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        PathwayParser parser = new PathwayParser(true);
        parser.parseFile("inoh/BMP2_signaling_TAK1.owl");
    }
}

