/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser;

import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.XmlOwlParser;
import de.berlin.hu.ppi.parser.object.Tag;
import de.berlin.hu.ppi.parser.object.kgml.Entry;
import de.berlin.hu.ppi.parser.object.kgml.Pathway;
import de.berlin.hu.ppi.parser.object.kgml.Reaction;
import de.berlin.hu.ppi.parser.object.kgml.Relation;
import de.berlin.hu.ppi.parser.object.kgml.Subtype;
import de.berlin.hu.ppi.tool.ProgressCounter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;

public class KgmlParser {
    private XmlOwlParser xmlOwlParser;
    private Entry openEntry;
    private Reaction openReaction;
    private Relation openRelation;
    private Pathway pathway;
    private static final int NONE = 0;
    private static final int ENTRY = 1;
    private static final int REACTION = 2;
    private static final int RELATION = 3;
    private static final int SUBSTRATE = 4;
    private static final int PRODUCT = 5;
    private int openTag;
    private int lastOpenTag;
    private String openTagName;
    private ProgressCounter.PATHWAY_PLUGIN_ID ppId;
    private ProgressCounter progressCounter;

    public KgmlParser(Reader reader, boolean withPrefix, ProgressCounter.PATHWAY_PLUGIN_ID ppId) throws FileNotFoundException, FileParsingException {
        this.xmlOwlParser = new XmlOwlParser(withPrefix);
        this.xmlOwlParser.openReader(reader);
        this.pathway = new Pathway();
        this.openTag = 0;
        this.lastOpenTag = 0;
        this.openTagName = "";
        this.ppId = ppId;
        this.progressCounter = ProgressCounter.getInstance();
    }

    protected void createEntity(Tag tag) throws FileParsingException {
        if (tag.getName().equals("Entry")) {
            this.openEntry = new Entry(tag.getAttribute("id"));
            this.openEntry.setName(tag.getAttribute("name"));
            this.openEntry.setType(tag.getAttribute("type"));
            this.openEntry.setReactions(tag.getAttribute("reaction"));
            this.openEntry.setLink(tag.getAttribute("link"));
            this.openTag = 1;
        } else if (tag.getName().equals("Reaction")) {
            this.openReaction = new Reaction();
            this.openReaction.setName(tag.getAttribute("name"));
            this.openReaction.setType(tag.getAttribute("type"));
            this.openTag = 2;
        } else if (tag.getName().equals("Relation")) {
            this.openRelation = new Relation();
            this.openRelation.setEntry1(tag.getAttribute("entry1"));
            this.openRelation.setEntry2(tag.getAttribute("entry2"));
            this.openRelation.setType(tag.getAttribute("type"));
            this.openTag = 3;
        }
        this.openTagName = tag.getName();
    }

    protected void addAttributes(Tag tag) throws NumberFormatException {
        if (tag.getName().equals("Component")) {
            this.openEntry.addComponent(tag.getAttribute("id"));
        } else if (tag.getName().equals("Graphics")) {
            this.openEntry.setX(tag.getAttribute("x"));
            this.openEntry.setY(tag.getAttribute("y"));
        } else if (tag.getName().equals("Substrate")) {
            this.openReaction.addSubstrate(tag.getAttribute("substrate"));
            if (tag.getType() == Tag.TagType.OPENING_TAG) {
                this.lastOpenTag = this.openTag;
                this.openTag = 4;
                this.openTagName = tag.getName();
            }
        } else if (tag.getName().equals("Product")) {
            this.openReaction.addProduct(tag.getAttribute("product"));
            if (tag.getType() == Tag.TagType.OPENING_TAG) {
                this.lastOpenTag = this.openTag;
                this.openTag = 5;
                this.openTagName = tag.getName();
            }
        } else if (tag.getName().equals("Subtype")) {
            Subtype subtype = new Subtype();
            subtype.setName(tag.getAttribute("name"));
            subtype.setValue(tag.getAttribute("value"));
            this.openRelation.addSubtype(subtype);
        } else {
            System.err.println("Unhandled tag: " + tag.toString());
        }
    }

    protected void addEntityToPathway(Tag tag) {
        switch (this.openTag) {
            case 1: {
                this.pathway.addEntry(this.openEntry.getId(), this.openEntry);
                break;
            }
            case 2: {
                this.pathway.addReaction(this.openReaction.getName(), this.openReaction);
                break;
            }
            case 3: {
                this.pathway.addRelation(this.openRelation);
                break;
            }
        }
        if (this.openTag == 4 || this.openTag == 5) {
            this.openTagName = "Reaction";
            this.openTag = this.lastOpenTag;
            this.lastOpenTag = 0;
        } else {
            this.openTag = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateEntries() throws FileParsingException, NumberFormatException {
        Tag tag = this.xmlOwlParser.getNextTag();
        if (!tag.getName().equals("Pathway")) {
            throw new FileParsingException("Expected an open pathway tag");
        }
        this.pathway.setLink(tag.getAttribute("link"));
        this.pathway.setName(tag.getAttribute("name"));
        this.pathway.setNumber(tag.getAttribute("number"));
        this.pathway.setOrg(tag.getAttribute("org"));
        this.pathway.setTitle(tag.getAttribute("title"));
        while (this.xmlOwlParser.hasNextTag()) {
            tag = this.xmlOwlParser.getNextTag();
            if (tag.getType() == Tag.TagType.COMPLETE_TAG) {
                if (this.openTag == 0) {
                    if (!tag.getName().equals("Entry")) {
                        if ((!tag.getName().equals("Relation") || !tag.getAttribute("type").equals("PCrel")) && !tag.getAttribute("type").equals("PPrel")) throw new FileParsingException("Expected an open tag while trying to add tag: " + tag.toString());
                        Relation rel = new Relation();
                        rel.setEntry1(tag.getAttribute("entry1"));
                        rel.setEntry2(tag.getAttribute("entry2"));
                        rel.setType(tag.getAttribute("type"));
                        this.pathway.addRelation(rel);
                    }
                } else {
                    this.addAttributes(tag);
                }
            } else if (tag.getType() == Tag.TagType.OPENING_TAG) {
                if (this.openTag == 0) {
                    this.createEntity(tag);
                } else {
                    this.addAttributes(tag);
                }
            } else if (tag.getType() == Tag.TagType.ENDING_TAG) {
                if (this.openTag == 0) {
                    if (tag.getName().equals("Pathway")) break;
                    throw new FileParsingException("Found the end tag " + tag.toString() + " but no corresponding open tag");
                }
                if (!tag.getName().equals(this.openTagName)) {
                    throw new FileParsingException("Open tag (" + this.openTagName + ") and end tag (" + tag.getName() + ") do not match");
                }
                this.addEntityToPathway(tag);
            } else {
                System.err.println("discovered useless tag: " + tag.toString());
            }
            this.progressCounter.incrementCounter(this.ppId);
        }
        this.xmlOwlParser.close();
    }

    public Pathway getPathway() {
        return this.pathway;
    }

    public static void main(String[] args) throws FileNotFoundException, FileParsingException, NumberFormatException {
        KgmlParser obj = new KgmlParser(new FileReader("kegg.xml"), false, ProgressCounter.PATHWAY_PLUGIN_ID.KEGG);
        obj.generateEntries();
    }
}

