/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser;

import de.berlin.hu.ppi.kegg.KEGGLocator;
import de.berlin.hu.ppi.kegg.KEGGPortType;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.KgmlParser;
import de.berlin.hu.ppi.parser.object.Edge;
import de.berlin.hu.ppi.parser.object.ExternalRef;
import de.berlin.hu.ppi.parser.object.Graph;
import de.berlin.hu.ppi.parser.object.InterConnection;
import de.berlin.hu.ppi.parser.object.Vertex;
import de.berlin.hu.ppi.parser.object.VertexPair;
import de.berlin.hu.ppi.parser.object.kgml.Entry;
import de.berlin.hu.ppi.parser.object.kgml.Pathway;
import de.berlin.hu.ppi.parser.object.kgml.Reaction;
import de.berlin.hu.ppi.parser.object.kgml.Relation;
import de.berlin.hu.ppi.tool.ProgressCounter;
import de.berlin.hu.ppi.tool.ThreadPoolManager;
import de.berlin.hu.ppi.tool.WebSiteParsingException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class KeggParser {
    private Graph pathway;
    private Pathway kgmlPathway;
    private KgmlParser kgmlParser;
    private boolean withPrefix;
    private Map<String, List<Vertex>> compounds;
    private Map<String, List<Vertex>> reactionsCatalysts;
    private Map<String, String> maps;
    private ThreadPoolManager<Task, Result> threads;
    private KEGGPortType serv;
    private static final String NAME = "name";
    private static final String DEFINITION = "definition";
    private static final String POSITION = "position";
    private static final String DBLINKS = "dblinks";
    private static final String AASEQ = "aaseq";
    private static final int MAX_NUMBER_OF_THREADS = 20;
    private static final int MAX_NUMBER_OF_TRIES = 10;
    private int uniqueInteractionId;
    private ProgressCounter.PATHWAY_PLUGIN_ID ppId;
    private ProgressCounter progressCounter;

    public KeggParser(boolean withPrefix, ProgressCounter.PATHWAY_PLUGIN_ID ppId) throws ServiceException {
        KEGGLocator locator = new KEGGLocator();
        this.serv = locator.getKEGGPort();
        this.reactionsCatalysts = new HashMap<String, List<Vertex>>();
        this.compounds = new HashMap<String, List<Vertex>>();
        this.maps = new HashMap<String, String>();
        this.threads = new ThreadPoolManager(20);
        this.withPrefix = withPrefix;
        this.uniqueInteractionId = 0;
        this.ppId = ppId;
        this.progressCounter = ProgressCounter.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePathway(Reader reader) throws FileNotFoundException, FileParsingException, InterruptedException, ExecutionException {
        Object vertex;
        this.kgmlParser = new KgmlParser(reader, this.withPrefix, this.ppId);
        this.kgmlParser.generateEntries();
        this.kgmlPathway = this.kgmlParser.getPathway();
        this.pathway = new Graph(this.kgmlPathway.getTitle());
        this.pathway.setId(this.kgmlPathway.getName());
        this.pathway.setShortName(this.kgmlPathway.getName());
        this.progressCounter.resetCounter(this.ppId);
        this.progressCounter.setLimit(this.ppId, this.kgmlPathway.getEntriesSize() + this.kgmlPathway.getReactionSize() + this.kgmlPathway.getRelationsSize());
        Iterator<String> entries = this.kgmlPathway.getEntries();
        while (entries.hasNext()) {
            Task task = new Task(this.kgmlPathway.getEntry(entries.next()));
            Future<Result> completed = this.threads.addTask(task);
            if (completed != null && (vertex = completed.get().getVertex()) != null) {
                Graph graph = this.pathway;
                synchronized (graph) {
                    this.pathway.addVertex((Vertex)vertex);
                }
            }
            this.progressCounter.incrementCounter(this.ppId);
        }
        this.threads.shutdown();
        while (this.threads.getFuturesSize() > 0) {
            Future<Result> completed = this.threads.popResult();
            Vertex vertex2 = completed.get().getVertex();
            if (vertex2 == null) continue;
            vertex = this.pathway;
            synchronized (vertex) {
                this.pathway.addVertex(vertex2);
            }
        }
        Iterator<String> reactions = this.kgmlPathway.getReactions();
        while (reactions.hasNext()) {
            this.pathway.addAllEdges(this.processReaction(this.kgmlPathway.getReaction(reactions.next())));
            this.progressCounter.incrementCounter(this.ppId);
        }
        for (int i = 0; i < this.kgmlPathway.getRelationsSize(); ++i) {
            Edge edge = this.processRelation(this.kgmlPathway.getRelation(i));
            if (edge != null) {
                this.pathway.addEdge(edge);
            }
            this.progressCounter.incrementCounter(this.ppId);
        }
    }

    protected Edge processRelation(Relation relation) {
        if (relation.getType().equalsIgnoreCase("maplink")) {
            String intermediate;
            String pathwayId;
            if (this.maps.containsKey(relation.getEntry1()) && this.maps.containsKey(relation.getEntry2())) {
                return null;
            }
            if (!this.maps.containsKey(relation.getEntry1()) && !this.maps.containsKey(relation.getEntry2())) {
                return null;
            }
            if (this.maps.containsKey(relation.getEntry1())) {
                pathwayId = this.maps.get(relation.getEntry1());
                intermediate = this.pathway.getVertex(relation.getEntry2()) != null ? relation.getEntry2() : null;
            } else {
                pathwayId = this.maps.get(relation.getEntry2());
                intermediate = this.pathway.getVertex(relation.getEntry1()) != null ? relation.getEntry1() : null;
            }
            InterConnection interConnection = new InterConnection();
            interConnection.setPathway(pathwayId);
            interConnection.setIntermediate(intermediate);
            this.pathway.addInterConnection(interConnection);
            return null;
        }
        Edge edge = new Edge("" + this.uniqueInteractionId++);
        edge.setName(relation.getType());
        if (relation.getType().equalsIgnoreCase("ECrel")) {
            edge.setDirection(Edge.EdgeDirection.LEFT.ordinal());
            edge.setType(relation.getType());
            for (int i = 0; i < relation.getSubtypesSize(); ++i) {
                Vertex end;
                Vertex start = this.pathway.getVertex(relation.getEntry1());
                VertexPair pair = this.getVertexPair(start, end = this.pathway.getVertex(relation.getSubtype(i).getValue()));
                if (pair != null) {
                    edge.addVertexPair(pair);
                }
                if ((pair = this.getVertexPair(start = this.pathway.getVertex(relation.getEntry2()), end = this.pathway.getVertex(relation.getSubtype(i).getValue()))) == null) continue;
                edge.addVertexPair(pair);
            }
        } else if (relation.getType().equalsIgnoreCase("PPrel")) {
            edge.setDirection(Edge.EdgeDirection.LEFT.ordinal());
            for (int i = 0; i < relation.getSubtypesSize(); ++i) {
                VertexPair pair;
                Vertex end;
                Vertex start;
                if (relation.getSubtype(i).getName().equals("compound")) {
                    edge.setType(relation.getType());
                    start = this.pathway.getVertex(relation.getEntry1());
                    end = this.pathway.getVertex(relation.getSubtype(i).getValue());
                    pair = this.getVertexPair(start, end);
                    if (pair != null) {
                        edge.addVertexPair(pair);
                    }
                    if ((pair = this.getVertexPair(start = this.pathway.getVertex(relation.getEntry2()), end = this.pathway.getVertex(relation.getSubtype(i).getValue()))) == null) continue;
                    edge.addVertexPair(pair);
                    continue;
                }
                edge.setType(relation.getSubtype(i).getName());
                start = this.pathway.getVertex(relation.getEntry1());
                end = this.pathway.getVertex(relation.getEntry2());
                pair = this.getVertexPair(start, end);
                if (pair == null) continue;
                edge.addVertexPair(pair);
            }
        } else if (relation.getType().equalsIgnoreCase("GErel")) {
            edge.setDirection(Edge.EdgeDirection.LEFT.ordinal());
            for (int i = 0; i < relation.getSubtypesSize(); ++i) {
                edge.setType(relation.getSubtype(i).getName());
                Vertex start = this.pathway.getVertex(relation.getEntry1());
                Vertex end = this.pathway.getVertex(relation.getEntry2());
                VertexPair pair = this.getVertexPair(start, end);
                if (pair == null) continue;
                edge.addVertexPair(pair);
            }
        } else if (relation.getType().equalsIgnoreCase("PCrel")) {
            edge.setDirection(Edge.EdgeDirection.BOTH.ordinal());
            edge.setType("protein-compound interaction");
            Vertex start = this.pathway.getVertex(relation.getEntry1());
            Vertex end = this.pathway.getVertex(relation.getEntry2());
            VertexPair pair = this.getVertexPair(start, end);
            if (pair != null) {
                edge.addVertexPair(pair);
            }
        }
        return edge;
    }

    protected List<Edge> processReaction(Reaction reaction) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        List<Vertex> catalysts = this.reactionsCatalysts.get(reaction.getName());
        ArrayList<Vertex> substrates = new ArrayList<Vertex>();
        for (int i = 0; i < reaction.getSubstratesSize(); ++i) {
            List<Vertex> possibleCompounds = this.compounds.get(reaction.getSubstrate(i));
            if (possibleCompounds == null) continue;
            substrates.add(this.chooseClosestCompound(possibleCompounds, reaction.getSubstrates(), reaction.getSubstrate(i), catalysts));
        }
        ArrayList<Vertex> products = new ArrayList<Vertex>();
        for (int i = 0; i < reaction.getProductsSize(); ++i) {
            List<Vertex> possibleCompounds = this.compounds.get(reaction.getProduct(i));
            if (possibleCompounds == null) continue;
            products.add(this.chooseClosestCompound(possibleCompounds, reaction.getProducts(), reaction.getProduct(i), catalysts));
        }
        int direction = reaction.isReversible() ? Edge.EdgeDirection.BOTH.ordinal() : Edge.EdgeDirection.LEFT.ordinal();
        edges.add(this.createEdge(substrates, products, "biochemical reaction", reaction.getName(), direction));
        if (catalysts != null) {
            substrates.addAll(products);
            edges.add(this.createEdge(catalysts, substrates, "catalysis", reaction.getName(), Edge.EdgeDirection.LEFT.ordinal()));
        }
        return edges;
    }

    private VertexPair getVertexPair(Vertex start, Vertex end) {
        if (start == null || end == null) {
            return null;
        }
        VertexPair pair = new VertexPair();
        pair.setStart(start.getId());
        pair.setEnd(end.getId());
        return pair;
    }

    protected Edge createEdge(List<Vertex> left, List<Vertex> right, String type, String name, int direction) {
        Edge edge = new Edge(name);
        edge.setType(type);
        edge.setDirection(direction);
        for (Vertex start : left) {
            for (Vertex end : right) {
                VertexPair pair = this.getVertexPair(start, end);
                if (pair == null) continue;
                edge.addVertexPair(pair);
            }
        }
        return edge;
    }

    protected Vertex chooseClosestCompound(List<Vertex> compounds, List<String> otherCompounds, String currentId, List<Vertex> catalysts) {
        if (compounds.size() == 1) {
            return compounds.get(0);
        }
        double minDist = Double.MAX_VALUE;
        Vertex closestCompound = compounds.get(0);
        for (Vertex currentCompound : compounds) {
            double tmpDist = 0.0;
            if (catalysts != null) {
                for (Vertex catalyst : catalysts) {
                    tmpDist += this.distance(currentCompound.getX(), currentCompound.getY(), catalyst.getX(), catalyst.getY());
                }
            }
            for (String other : otherCompounds) {
                if (other.equals(currentId)) continue;
                tmpDist += this.getDistance(currentCompound, other, catalysts);
            }
            if (!(tmpDist < minDist)) continue;
            minDist = tmpDist;
            closestCompound = currentCompound;
        }
        return closestCompound;
    }

    private double getDistance(Vertex current, String other, List<Vertex> catalysts) {
        List<Vertex> otherCompounds = this.compounds.get(other);
        if (otherCompounds == null) {
            return 0.0;
        }
        if (otherCompounds.size() == 1) {
            return this.distance(current.getX(), current.getY(), otherCompounds.get(0).getX(), otherCompounds.get(0).getY());
        }
        if (catalysts != null) {
            Vertex choosen = this.chooseClosestCompound(otherCompounds, new ArrayList<String>(0), null, catalysts);
            return this.distance(current.getX(), current.getY(), choosen.getX(), choosen.getY());
        }
        double minDist = Double.MAX_VALUE;
        for (Vertex otherCompound : otherCompounds) {
            double tmpDist = 0.0;
            tmpDist = this.distance(current.getX(), current.getY(), otherCompound.getX(), otherCompound.getY());
            if (!(tmpDist < minDist)) continue;
            minDist = tmpDist;
        }
        return minDist;
    }

    private double distance(int fromX, int fromY, int toX, int toY) {
        return Math.sqrt((fromX - toX) * (fromX - toX) + (fromY - toY) * (fromY - toY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vertex processNode(Entry entry) {
        Object refs;
        if (entry.getType().equals("map")) {
            Map<String, String> map = this.maps;
            synchronized (map) {
                this.maps.put(entry.getId(), entry.getName());
            }
            return null;
        }
        Vertex vertex = new Vertex(entry.getId());
        vertex.setType(entry.getType());
        if (!entry.getType().equals("group") && entry.getName() != null && entry.getName().contains(":")) {
            refs = entry.getName().split(" ");
            for (int i = 0; i < ((String[])refs).length; ++i) {
                ExternalRef ref = new ExternalRef();
                int position = refs[i].indexOf(":");
                if (position == -1) {
                    String prefix = entry.getName().substring(0, entry.getName().indexOf(":") + 1);
                    refs[i] = prefix + refs[i];
                    position = prefix.length() - 1;
                }
                ref.setDb(refs[i].substring(0, position));
                ref.setId(refs[i].substring(position + 1));
                vertex.addExternalRef(ref);
            }
        }
        if (entry.getType().equals("group")) {
            vertex.setType("complex");
        } else {
            if (entry.getType().equals("compound")) {
                refs = this.compounds;
                synchronized (refs) {
                    List<Vertex> tmp = this.compounds.get(entry.getName());
                    if (tmp == null) {
                        tmp = new ArrayList<Vertex>();
                        this.compounds.put(entry.getName(), tmp);
                    }
                    tmp.add(vertex);
                }
            }
            int countOfTries = 0;
            boolean success = false;
            while (!success && countOfTries < 10) {
                try {
                    this.getAdditionalData(vertex, entry);
                    success = true;
                }
                catch (Exception e) {
                    ++countOfTries;
                }
            }
            if (!success) {
                Logger.getLogger(this.getClass()).warn("Could not fetch details for entry " + entry.getId() + " " + entry.getName());
            }
        }
        if (entry.getX() >= 0) {
            vertex.setX(entry.getX());
        }
        if (entry.getY() >= 0) {
            vertex.setY(entry.getY());
        }
        if (entry.getComponentsSize() != 0) {
            vertex.setComplex(true);
            for (int i = 0; i < entry.getComponentsSize(); ++i) {
                if (this.kgmlPathway.getEntry(entry.getComponent(i)) == null) continue;
                vertex.addComplexPart(entry.getComponent(i));
            }
        }
        for (int i = 0; i < entry.getReactionsSize(); ++i) {
            Map<String, List<Vertex>> map = this.reactionsCatalysts;
            synchronized (map) {
                List<Vertex> tmp = this.reactionsCatalysts.get(entry.getReaction(i));
                if (tmp == null) {
                    tmp = new ArrayList<Vertex>();
                    this.reactionsCatalysts.put(entry.getReaction(i), tmp);
                }
                tmp.add(vertex);
                continue;
            }
        }
        return vertex;
    }

    protected void getAdditionalData(Vertex vertex, Entry entry) throws RemoteException {
        List<String> results = Arrays.asList(this.serv.bget(entry.getName()).trim().toLowerCase().split("///"));
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> references = new ArrayList<String>();
        ArrayList<String> chromsomalPositions = new ArrayList<String>();
        ArrayList<String> aaSeqs = new ArrayList<String>();
        for (String result : results) {
            names.addAll(this.extractValues(result, NAME));
            names.addAll(this.extractValues(result, DEFINITION));
            references.addAll(this.extractValues(result, DBLINKS));
            chromsomalPositions.addAll(this.extractValues(result, POSITION));
            aaSeqs.addAll(this.extractValues(result, AASEQ));
        }
        if (names.size() == 0) {
            vertex.setName(entry.getName());
        } else {
            vertex.setName((String)names.get(0));
            for (int i = 1; i < names.size(); ++i) {
                vertex.addSynonym((String)names.get(i));
            }
        }
        if (references.size() != 0) {
            ArrayList<ExternalRef> externalRefs = new ArrayList<ExternalRef>();
            for (String reference : references) {
                String[] refs = reference.split(":");
                if (refs.length == 1) {
                    if (externalRefs.size() == 0) continue;
                    refs[0].replaceAll("[,;]", " ");
                    ExternalRef xref = (ExternalRef)externalRefs.get(externalRefs.size() - 1);
                    xref.setId(xref.getId() + " " + refs[0].trim());
                    continue;
                }
                refs[1].replaceAll("[,;]", " ");
                externalRefs.add(new ExternalRef(refs[0].trim(), refs[1].trim()));
            }
            for (ExternalRef xref : externalRefs) {
                vertex.addExternalRef(xref);
            }
        }
        if (chromsomalPositions.size() != 0) {
            vertex.setChromosomalPosition((String)chromsomalPositions.get(0));
            for (int i = 1; i < chromsomalPositions.size(); ++i) {
                vertex.setChromosomalPosition(vertex.getChromosomalPosition() + " " + (String)chromsomalPositions.get(i));
            }
        }
        if (aaSeqs.size() != 0) {
            vertex.setSequence((String)aaSeqs.get(0));
            for (int i = 1; i < aaSeqs.size(); ++i) {
                vertex.setSequence(vertex.getSequence() + " " + (String)aaSeqs.get(i));
            }
        }
    }

    private String removePossibleDelimiter(String string) {
        if (string.charAt(string.length() - 1) == ';' || string.charAt(string.length() - 1) == ',') {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private List<String> extractValues(String string, String pattern) {
        ArrayList<String> res = new ArrayList<String>();
        int index = string.indexOf(pattern);
        if (index != -1) {
            int newLineIndex = string.indexOf("\n", index + 1);
            res.add(this.removePossibleDelimiter(string.substring(index + pattern.length(), newLineIndex).trim()));
            while (newLineIndex + 1 < string.length() && (string.charAt(newLineIndex + 1) == '\t' || string.charAt(newLineIndex + 1) == ' ')) {
                index = string.indexOf("\n", newLineIndex + 1);
                res.add(this.removePossibleDelimiter(string.substring(newLineIndex + 1, index).trim()));
                newLineIndex = index;
            }
            if (pattern.equals(AASEQ) || pattern.equals("ntseq")) {
                res.remove(0);
                StringBuilder sequence = new StringBuilder();
                for (String tmp : res) {
                    sequence.append(tmp);
                }
                res = new ArrayList();
                res.add(sequence.toString());
            }
        }
        return res;
    }

    public Graph getPathway() {
        return this.pathway;
    }

    public void printVertex(Vertex vertex) {
        System.out.println("Vertex: " + vertex.getId() + " " + vertex.getName() + " " + vertex.getCellularLocation() + " " + vertex.getChromosomalPosition() + " " + vertex.getSequence());
        for (int i = 0; i < vertex.getSynonymsSize(); ++i) {
            System.out.println("\tSynonym: " + vertex.getSynonym(i));
        }
        Iterator<ExternalRef> refs = vertex.getExternalRefs();
        while (refs.hasNext()) {
            ExternalRef ref = refs.next();
            System.out.println("\tExternalRef: " + ref.getDb() + ":::" + ref.getId());
        }
    }

    public static void main(String[] args) throws WebSiteParsingException, FileParsingException, InterruptedException, FileNotFoundException, ExecutionException, ServiceException {
        long time = System.currentTimeMillis();
        KeggParser obj = new KeggParser(false, ProgressCounter.PATHWAY_PLUGIN_ID.KEGG);
        obj.generatePathway(new FileReader("/vol/fob-vol3/mi02/arnold/workspace/protpath/tmp_kegg_pathway_plugin/kgml/metabolic/organisms/ath/ath00010.xml"));
        Graph pathway = obj.getPathway();
        obj.printVertex(pathway.getVertex("79"));
        time = System.currentTimeMillis() - time;
        System.out.println("Required time (ms): " + time);
    }

    private class Result {
        private Vertex vertex;

        public Result(Vertex vertex) {
            this.vertex = vertex;
        }

        public Vertex getVertex() {
            return this.vertex;
        }
    }

    private class Task
    implements Callable<Result> {
        private Entry entry;

        public Task(Entry entry) {
            this.entry = entry;
        }

        @Override
        public Result call() {
            return new Result(KeggParser.this.processNode(this.entry));
        }
    }
}

