/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.parser;

import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.XmlOwlParser;
import de.berlin.hu.ppi.parser.object.Tag;
import de.berlin.hu.ppi.parser.object.biopax.Attribute;
import de.berlin.hu.ppi.parser.object.biopax.Biochemicalreaction;
import de.berlin.hu.ppi.parser.object.biopax.Catalysis;
import de.berlin.hu.ppi.parser.object.biopax.Complexassembly;
import de.berlin.hu.ppi.parser.object.biopax.Control;
import de.berlin.hu.ppi.parser.object.biopax.Conversion;
import de.berlin.hu.ppi.parser.object.biopax.Entity;
import de.berlin.hu.ppi.parser.object.biopax.Interaction;
import de.berlin.hu.ppi.parser.object.biopax.Modulation;
import de.berlin.hu.ppi.parser.object.biopax.Physicalinteraction;
import de.berlin.hu.ppi.parser.object.biopax.Transport;
import de.berlin.hu.ppi.parser.object.biopax.Transportwithbiochemicalreaction;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class CopyOfBioPaxParser {
    public static final String BIOPAX_PACKAGE_PATH = "de.berlin.hu.ppi.parser.object.biopax.";
    private XmlOwlParser xmlOwlParser;
    private Stack<Tag> openTags = new Stack();
    private Stack<Entity> openEntities = new Stack();
    private List<List<Entity>> items;
    private Map<String, Entity> hashIndex = new HashMap<String, Entity>();
    private static final String rdfResource = "rdf:resource";
    private static final String rdfDatatype = "rdf:datatype";
    private static final String rdfId = "rdf:id";
    public long timeall = 0L;

    public CopyOfBioPaxParser(Reader reader, boolean withPrefix) throws FileNotFoundException, FileParsingException {
        this.items = new ArrayList<List<Entity>>();
        for (int i = 0; i < Entity.BiopaxClass.getCountOfUseableBiopaxClasses(); ++i) {
            ArrayList tmp = new ArrayList();
            this.items.add(tmp);
        }
        this.timeall = Calendar.getInstance().getTimeInMillis();
        this.xmlOwlParser = new XmlOwlParser(withPrefix);
        this.xmlOwlParser.openReader(reader);
    }

    public void generateEntries() throws FileParsingException, InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        do {
            Tag tag;
            if ((tag = this.xmlOwlParser.getNextTag()).getType() != Tag.TagType.USELESS_TAG) {
                Entity entity;
                if (tag.getType() == Tag.TagType.COMPLETE_TAG) {
                    if (tag.containsAttribute(rdfId)) {
                        try {
                            entity = (Entity)Class.forName(BIOPAX_PACKAGE_PATH + tag.getName()).newInstance();
                            entity.setIdString(tag.getAttribute(rdfId));
                            this.items.get(entity.getHashId()).add(entity);
                            this.hashIndex.put(entity.getIdString(), entity);
                            if (this.openTags.empty()) continue;
                            this.openTags.peek().setHasChildren(true);
                        }
                        catch (ClassNotFoundException e) {
                            Logger.getLogger(this.getClass()).error("", e);
                        }
                        continue;
                    }
                    if (tag.containsAttribute(rdfDatatype)) {
                        if (this.openTags.empty()) continue;
                        this.openTags.peek().setHasChildren(true);
                        continue;
                    }
                    this.addAttribute(tag, rdfResource);
                    this.openTags.peek().setHasChildren(true);
                    continue;
                }
                if (tag.getType() == Tag.TagType.OPENING_TAG) {
                    if (tag.containsAttribute(rdfId)) {
                        try {
                            entity = (Entity)Class.forName(BIOPAX_PACKAGE_PATH + tag.getName()).newInstance();
                            entity.setIdString(tag.getAttribute(rdfId));
                            if (!this.openTags.empty()) {
                                Tag attribute = this.openTags.peek();
                                attribute.addAttribute(rdfResource, tag.getAttribute(rdfId));
                            }
                            this.openEntities.push(entity);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    this.openTags.push(tag);
                    continue;
                }
                if (tag.getType() != Tag.TagType.ENDING_TAG) continue;
                if (this.openTags.empty()) {
                    if (tag.getName().equals(":rdf") || tag.getName().equals("Rdf:rdf")) break;
                    throw new FileParsingException("Found the end tag " + tag.toString() + " but no corresponding open tag");
                }
                Tag attribute = this.openTags.pop();
                if (!tag.getName().equals(attribute.getName())) {
                    if (tag.getName().equals(":rdf") || tag.getName().equals("Rdf:rdf")) {
                        throw new FileParsingException("At least one open tag " + attribute.toString() + " without corresponding end tag");
                    }
                    throw new FileParsingException("Open tag (" + attribute.toString() + ") and end tag (" + tag.toString() + ") do not match");
                }
                if (attribute.containsAttribute(rdfId)) {
                    Entity entity2 = this.openEntities.pop();
                    this.items.get(entity2.getHashId()).add(entity2);
                    this.hashIndex.put(entity2.getIdString(), entity2);
                } else if (!attribute.hasChildren()) {
                    String value = this.xmlOwlParser.getPutativeValue();
                    attribute.addAttribute(rdfDatatype, value);
                    this.addAttribute(attribute, rdfDatatype);
                } else {
                    this.addAttribute(attribute, rdfResource);
                }
                if (this.openTags.empty()) continue;
                this.openTags.peek().setHasChildren(true);
                continue;
            }
            if (this.openTags.empty()) continue;
            this.openTags.peek().setHasChildren(true);
        } while (this.xmlOwlParser.hasNextTag());
        this.xmlOwlParser.close();
        if (!this.openTags.empty() || !this.openEntities.empty()) {
            throw new FileParsingException("There were open tag(s) or open entries");
        }
        this.timeall = Calendar.getInstance().getTimeInMillis() - this.timeall;
    }

    private void addAttribute(Tag tag, String attribute) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, FileParsingException {
        if (this.openEntities.empty()) {
            throw new FileParsingException("Expected an open (parent) tag/entry while trying to add tag " + tag.toString() + " - but stack was empty");
        }
        String value = tag.getAttribute(attribute);
        if (!value.equalsIgnoreCase("Nil")) {
            Entity parent = this.openEntities.peek();
            try {
                parent.getClass().getMethod("add" + tag.getName(), String.class).invoke((Object)parent, value);
            }
            catch (NoSuchMethodException e) {
                System.err.println("An invalid attribute was specified: " + e.getMessage() + " for tag " + parent.getIdString());
            }
        }
    }

    public Iterator<Entity> getPathways() {
        return this.items.get(Entity.BiopaxClass.PATHWAY.ordinal()).iterator();
    }

    public Entity getEntity(String id) {
        return this.hashIndex.get(id);
    }

    public Iterator<Entity> getEntitiesOfType(int index) {
        return this.items.get(index).iterator();
    }

    public void findRecursiveInteractionUsage() {
        for (Integer type : Entity.BiopaxClass.interactionTypes) {
            for (Entity entity : this.items.get(type)) {
                Attribute referencedEntities;
                if (entity instanceof Conversion || entity instanceof Biochemicalreaction || entity instanceof Complexassembly || entity instanceof Transport || entity instanceof Transportwithbiochemicalreaction) {
                    Conversion conversion = (Conversion)entity;
                    referencedEntities = conversion.getLeft();
                    referencedEntities.addAll(conversion.getRight());
                    this.markInteractionEntities(referencedEntities);
                    continue;
                }
                if (entity instanceof Control || entity instanceof Catalysis || entity instanceof Modulation) {
                    Control control = (Control)entity;
                    referencedEntities = control.getControlled();
                    referencedEntities.addAll(control.getController());
                    if (entity instanceof Catalysis) {
                        referencedEntities.addAll(((Catalysis)control).getCofactor());
                    }
                    this.markInteractionEntities(referencedEntities);
                    continue;
                }
                if (!(entity instanceof Interaction) && !(entity instanceof Physicalinteraction)) continue;
                Interaction interaction = (Interaction)entity;
                referencedEntities = interaction.getParticipants();
                this.markInteractionEntities(referencedEntities);
            }
        }
    }

    private void markInteractionEntities(Attribute referencedEntities) {
        for (String referencedEntity : referencedEntities) {
            Entity entity = this.hashIndex.get(referencedEntity);
            if (!(entity instanceof Conversion) && !(entity instanceof Biochemicalreaction) && !(entity instanceof Complexassembly) && !(entity instanceof Transport) && !(entity instanceof Transportwithbiochemicalreaction) && !(entity instanceof Control) && !(entity instanceof Catalysis) && !(entity instanceof Modulation) && !(entity instanceof Interaction) && !(entity instanceof Physicalinteraction)) continue;
            entity.setUsedRecursively(true);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, FileParsingException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        CopyOfBioPaxParser obj = new CopyOfBioPaxParser(new FileReader("pathway_commons.owl"), true);
        obj.generateEntries();
        System.out.println("Time: " + obj.timeall + "ms");
    }
}

