/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.net;

import de.berlin.hu.ppi.net.StreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class URLStreamSource
implements StreamSource {
    private URLConnection urlConnection;
    private URL url;
    private static Logger log = Logger.getLogger(URLStreamSource.class);

    public URLStreamSource(String urlString) {
        try {
            this.url = new URL(urlString);
            this.urlConnection = this.url.openConnection();
        }
        catch (MalformedURLException e) {
            log.error("", e);
        }
        catch (IOException e) {
            log.error("", e);
        }
    }

    @Override
    public long getStreamLength() {
        return this.urlConnection.getContentLength();
    }

    @Override
    public InputStream getStream() {
        try {
            return this.urlConnection.getInputStream();
        }
        catch (IOException e) {
            log.error("", e);
            return null;
        }
    }

    @Override
    public String getStreamName() {
        String name = this.getStreamNameFromHeader();
        if (name == null) {
            String[] file = this.url.getFile().split("/");
            name = file[file.length - 1];
        }
        return name;
    }

    public String getStreamNameFromHeader() {
        int i = 0;
        String field = this.urlConnection.getHeaderField(i);
        while (field != null) {
            if (field.contains("filename=")) {
                return field.split("filename=")[1];
            }
            field = this.urlConnection.getHeaderField(++i);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

