/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.net;

import de.berlin.hu.ppi.net.StreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;

public class FTPStreamSource
implements StreamSource {
    FTPClient client;
    String server;
    String file;
    private Logger log = Logger.getLogger(FTPStreamSource.class);

    public FTPStreamSource(String server, String file) throws SocketException, IOException {
        this.server = server;
        this.file = file;
        this.initClient();
    }

    public FTPStreamSource(String urlString) throws SocketException, IOException {
        this.server = this.getServerName(urlString);
        this.file = this.getFileName(urlString);
        this.initClient();
    }

    private void initClient() throws SocketException, IOException {
        this.client = new FTPClient();
        this.client.connect(this.server);
        this.client.login("anonymous", "email@aol.com");
        this.client.setFileType(2);
        this.client.enterLocalPassiveMode();
    }

    private String getFileName(String urlString) {
        String server = this.getServerName(urlString);
        int begin = urlString.lastIndexOf(server) + server.length();
        return urlString.substring(begin);
    }

    private String getServerName(String url) {
        for (String server : url.split("[/]")) {
            if (!server.startsWith("ftp.") && !server.contains(".")) continue;
            return server;
        }
        return url;
    }

    @Override
    public String getStreamName() {
        String[] splittetFile = this.file.split("[/]");
        return splittetFile[splittetFile.length - 1];
    }

    @Override
    public InputStream getStream() {
        try {
            return this.client.retrieveFileStream(this.file);
        }
        catch (IOException e) {
            this.log.error("\n\tServer: " + this.server + "\n\tFile: " + this.file, e);
            return null;
        }
    }

    @Override
    public long getStreamLength() {
        try {
            FTPFile[] arr$ = this.client.listFiles(this.file);
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                FTPFile ftpFile = arr$[i$];
                return ftpFile.getSize();
            }
        }
        catch (IOException e) {
            this.log.error("", e);
        }
        return -1L;
    }

    @Override
    public void close() throws IOException {
        this.client.disconnect();
    }
}

