/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.net;

import de.berlin.hu.ppi.net.StreamSource;
import de.berlin.hu.ppi.net.StreamSourceFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class Downloader {
    private File target;
    private File backupFile;
    private String targetFolderName = ".";
    private String targetFilename = "";
    private ExistanceHandling existanceHandling = ExistanceHandling.BACKUP;
    private AbortHandling abortHandling = AbortHandling.RESTORE;
    private long downloadedBytes = 0L;
    private long contentLenght = -1L;
    private InputStream in;
    private BufferedOutputStream out;
    private int bufferSize = 140000;
    private StreamSourceFactory factory;
    private String urlString;
    private long lastChunkStart;
    private int lastChunkLength;
    private long lastChunkDuration;
    private StreamSource streamSource;
    private static Logger log = Logger.getLogger(Downloader.class);

    public Downloader(String urlString) {
        this(urlString, StreamSourceFactory.getDefault());
    }

    public Downloader(String urlString, StreamSourceFactory factory) {
        this.urlString = urlString;
        this.factory = factory;
    }

    public void setContentLength(long length) {
        if (this.contentLenght == -1L) {
            this.contentLenght = length;
        }
    }

    public boolean setTargetDirectory(File directory) {
        if (directory == null) {
            log.warn("Could not set the target directory, because the file pointer is null.");
            return false;
        }
        if (!directory.exists()) {
            log.warn("Could not set the target directory to \"" + directory.getAbsolutePath() + "\" because it is not existing.");
            return false;
        }
        if (!directory.isDirectory()) {
            log.warn("Could not set the target directory to \"" + directory.getAbsolutePath() + "\" because it is no directory.");
            return false;
        }
        if (!directory.canWrite()) {
            log.warn("Could not set the target directory to \"" + directory.getAbsolutePath() + "\" because the application has not write permission.");
            return false;
        }
        this.targetFolderName = directory.getAbsolutePath();
        return true;
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public boolean setTargetDirectoryPath(String path) {
        return this.setTargetDirectory(new File(path));
    }

    public static String getFileName(URL url) {
        String[] file = url.getFile().split("[" + File.separator + "]");
        return file[file.length - 1];
    }

    public void abort() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        catch (IOException e) {
            log.error("", e);
        }
        switch (this.abortHandling) {
            case KEEP: {
                break;
            }
            case RESTORE: {
                if (!this.target.delete()) {
                    log.warn("Could not delete file " + this.target + ".");
                    break;
                }
                if (this.backupFile == null) break;
                this.backupFile.renameTo(this.target);
                break;
            }
            default: {
                log.warn("Illegal abort handling method.");
            }
        }
    }

    public double getProgress() {
        return this.contentLenght > 0L ? (double)this.downloadedBytes / (double)this.contentLenght : 0.0;
    }

    public long getDownloadedBytes() {
        return this.downloadedBytes;
    }

    public long getContentLength() {
        return this.contentLenght;
    }

    public boolean isDone() {
        if (this.contentLenght != -1L) {
            return this.downloadedBytes == this.contentLenght;
        }
        return this.download() == -1 && this.target.exists() && this.target.length() > 0L;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setExistanceHandling(ExistanceHandling id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        switch (id) {
            case REPLACE: 
            case BACKUP: 
            case SKIP: {
                this.existanceHandling = id;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal existance handling method id.");
            }
        }
    }

    public void setAbortHandling(AbortHandling id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        switch (id) {
            case KEEP: 
            case RESTORE: {
                this.abortHandling = id;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal abort handling method id.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeDownload() {
        try {
            this.streamSource = this.factory.getStreamSource(this.urlString);
            long length = this.streamSource.getStreamLength();
            if (length != -1L) {
                this.contentLenght = length;
                log.info("Content length: " + this.contentLenght);
            }
            this.targetFilename = this.streamSource.getStreamName();
            this.target = new File(this.targetFolderName + File.separatorChar + this.targetFilename);
            log.info("Download target: " + this.target);
            if (this.target.exists()) {
                if (this.existanceHandling == ExistanceHandling.SKIP) return;
                this.handleExistance();
            } else if (!this.target.createNewFile()) {
                log.error("could not create file \"" + this.target.getAbsolutePath());
            }
            this.out = new BufferedOutputStream(new FileOutputStream(this.target));
            log.info("Opening Input Stream...");
            this.in = this.streamSource.getStream();
            return;
        }
        catch (IOException e) {
            log.error("", e);
        }
    }

    public int download() {
        long tmp = this.lastChunkStart;
        this.lastChunkStart = System.currentTimeMillis();
        this.lastChunkDuration = this.lastChunkStart - tmp;
        try {
            byte[] buffer = new byte[this.bufferSize];
            int len = this.in.read(buffer);
            if (len != -1) {
                this.lastChunkLength = len;
                this.downloadedBytes += (long)len;
                this.out.write(buffer, 0, len);
                return len;
            }
            if (this.existanceHandling == ExistanceHandling.REPLACE && this.backupFile != null && this.backupFile.exists() && !this.backupFile.delete()) {
                log.warn("Could not delete " + this.backupFile.getAbsolutePath());
            }
            this.out.flush();
            this.out.close();
            this.in.close();
            this.streamSource.close();
        }
        catch (Exception e) {
            log.error("", e);
        }
        return -1;
    }

    public double getBytesPerSecond() {
        if (this.lastChunkLength > 0 && this.lastChunkDuration > 0L) {
            return (double)this.lastChunkLength / (double)this.lastChunkDuration;
        }
        return 0.0;
    }

    private void handleExistance() {
        switch (this.existanceHandling) {
            case BACKUP: {
                this.backupFile = new File(this.target.getAbsolutePath() + Downloader.getTimeStamp("_yyyy.MM.dd_HH:mm"));
                this.target.renameTo(this.backupFile);
                try {
                    if (this.target.createNewFile()) break;
                    log.warn("Could not create file " + this.target);
                }
                catch (IOException e) {
                    log.warn("Could not create file " + this.target, e);
                }
                break;
            }
            case REPLACE: {
                this.backupFile = new File(this.target.getAbsolutePath() + ".bak");
                this.target.renameTo(this.backupFile);
                try {
                    if (this.target.createNewFile()) break;
                    log.warn("Could not create file " + this.target);
                    break;
                }
                catch (IOException e) {
                    log.warn("Could not create file " + this.target, e);
                }
            }
        }
    }

    public static String getTimeStamp(String pattern) {
        return new SimpleDateFormat(pattern).format(new Date());
    }

    public File getTargetFile() {
        if (this.target != null && this.target.exists()) {
            return this.target;
        }
        log.warn("Target file does not exist or has not been downloaded.");
        return null;
    }

    public static String getFileName(URLConnection connection) {
        int i = 0;
        String field = "";
        while (field != null) {
            if (field.contains("filename=")) {
                return field.split("filename=")[1];
            }
            field = connection.getHeaderField(i++);
        }
        return null;
    }

    public static enum AbortHandling {
        KEEP,
        RESTORE;

    }

    public static enum ExistanceHandling {
        BACKUP,
        REPLACE,
        SKIP;

    }
}

