/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator.dbx;

import de.berlin.hu.ppi.mediator.dbx.DBConstants;
import de.berlin.hu.ppi.mediator.dbx.DBLookupProtein;
import de.berlin.hu.ppi.mediator.dbx.DBProtein;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DBProteinService
implements DBConstants {
    Logger log = Logger.getLogger(DBProteinService.class);
    Connection con;
    static final String QUERY_SELECT_PROTEIN_VIA_UNIPROT_ID = "SELECT * FROM molecule WHERE primary_uniprot_id = ?";
    static final String QUERY_SELECT_PROTEIN_VIA_ID = "SELECT * FROM molecule WHERE id = ?";
    static final String QUERY_INSERT_REFERENCE = "INSERT INTO reference VALUES (?, ?, ?)";
    static final String QUERY_INSERT_REACTOME_REL = "INSERT INTO reactome_rel VALUES (?,?)";
    static final String QUERY_INSERT_MOLECULE = "INSERT INTO molecule VALUES (NULL, ?, ?, ?, ?, ?, NULL)";
    static final String QUERY_INSERT_GO_REL_EVIDENCE = "INSERT INTO go_rel_evidence VALUES (?,?,?,?)";
    static final String QUERY_INSERT_GO_REL = "INSERT INTO go_rel VALUES (?,?)";
    static final String QUERY_INSERT_INTERPRO_REL = "INSERT INTO interpro_rel VALUES (?,?)";
    static final String QUERY_INSERT_SEQUENCE = "INSERT INTO sequence VALUES (?,?)";
    static final String QUERY_INSERT_CHROMOSOMAL_LOCATION = "INSERT INTO chromosomal_location VALUES (?,?)";
    static final String QUERY_SELECT_PROTEIN_ID_BY_PRIMARY_UNIPROT_ID = "SELECT id FROM molecule WHERE primary_uniprot_id = ?";
    PreparedStatement selectMoleculeViaId;
    PreparedStatement selectMoleculteViaUniprotId;
    PreparedStatement insertReference;
    PreparedStatement insertMolecule;
    PreparedStatement insertInterProRel;
    PreparedStatement insertGo;
    PreparedStatement insertGoEvidence;
    PreparedStatement insertReactome;
    PreparedStatement insertSequence;
    PreparedStatement insertChromosomalLocation;
    PreparedStatement selectProteinIdByPrimaryUniprotId;

    public DBProteinService(Connection con) {
        try {
            this.con = con;
            this.selectMoleculeViaId = con.prepareStatement(QUERY_SELECT_PROTEIN_VIA_ID);
            this.selectMoleculteViaUniprotId = con.prepareStatement(QUERY_SELECT_PROTEIN_VIA_UNIPROT_ID);
            this.insertInterProRel = con.prepareStatement(QUERY_INSERT_INTERPRO_REL);
            this.insertGo = con.prepareStatement(QUERY_INSERT_GO_REL);
            this.insertGoEvidence = con.prepareStatement(QUERY_INSERT_GO_REL_EVIDENCE);
            this.insertMolecule = con.prepareStatement(QUERY_INSERT_MOLECULE, 1);
            this.insertReactome = con.prepareStatement(QUERY_INSERT_REACTOME_REL);
            this.insertReference = con.prepareStatement(QUERY_INSERT_REFERENCE);
            this.insertSequence = con.prepareStatement(QUERY_INSERT_SEQUENCE);
            this.insertChromosomalLocation = con.prepareStatement(QUERY_INSERT_CHROMOSOMAL_LOCATION);
            this.selectProteinIdByPrimaryUniprotId = con.prepareStatement(QUERY_SELECT_PROTEIN_ID_BY_PRIMARY_UNIPROT_ID);
        }
        catch (SQLException e) {
            this.log.error("Couldn't instantiate DBProteinService: " + e);
            return;
        }
    }

    public DBProtein newDBProtein() {
        return new DBProtein(this.con, this);
    }

    public DBProtein newDBProtein(DBLookupProtein dlp) {
        return new DBProtein(dlp, this);
    }

    public DBProtein find(int protein_id) throws SQLException {
        this.selectMoleculeViaId.setInt(1, protein_id);
        ResultSet rs = this.selectMoleculeViaId.executeQuery();
        if (!rs.next()) {
            return null;
        }
        DBProtein found_protein = new DBProtein(this.con, this);
        this.populateProtein(found_protein, rs);
        rs.close();
        return found_protein;
    }

    public int findIdByPrimaryUniprotId(String uniprot_id) throws SQLException {
        this.selectProteinIdByPrimaryUniprotId.setString(1, uniprot_id);
        ResultSet rs = this.selectProteinIdByPrimaryUniprotId.executeQuery();
        if (!rs.next()) {
            return -1;
        }
        int proteinId = rs.getInt(1);
        rs.close();
        return proteinId;
    }

    public DBProtein findByPrimaryUniprotId(String uniprot_id) throws SQLException {
        this.selectMoleculteViaUniprotId.setString(1, uniprot_id);
        ResultSet rs = this.selectMoleculteViaUniprotId.executeQuery();
        if (!rs.next()) {
            return null;
        }
        DBProtein found_protein = new DBProtein(this.con, this);
        this.populateProtein(found_protein, rs);
        rs.close();
        return found_protein;
    }

    private void populateProtein(DBProtein found_protein, ResultSet rs) throws SQLException {
        String[] items = new String[]{"id", "primary_uniprot_id", "tax_id"};
        for (int i = 0; i < items.length; ++i) {
            String prop = rs.getString(items[i]);
            if (prop == null) continue;
            found_protein.setProperty(items[i], prop);
        }
    }
}

