/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator.dbx;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.db.DbConstants;
import de.berlin.hu.ppi.mediator.dbx.DBConstants;
import de.berlin.hu.ppi.mediator.dbx.DBLookupProtein;
import de.berlin.hu.ppi.mediator.dbx.DBProteinService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;

public class DBProtein
implements DBConstants,
DbConstants,
PpiConstants {
    Logger log = Logger.getLogger(DBProtein.class);
    Properties properties;
    Connection con = null;
    String[] required_properties;
    DBProteinService service;
    private int proteinId = -1;
    private String experimentalRole;
    private UniProtEntry entry;

    public DBProtein(Connection con, DBProteinService service) {
        this.con = con;
        this.service = service;
        this.properties = new Properties();
    }

    public DBProtein(DBLookupProtein dbLookupProtein, DBProteinService service) {
        this.con = dbLookupProtein.getConnection();
        this.service = service;
        this.properties = dbLookupProtein.getProperties();
        this.experimentalRole = dbLookupProtein.getExperimentaRole();
    }

    public String getExperimentalRole() {
        return this.experimentalRole;
    }

    public int insert() throws SQLException {
        if (this.isPersistent()) {
            return this.getProteinId();
        }
        int type = PpiConstants.MOLECULE_TYPE.PROTEIN.ordinal();
        String name = this.getProperty("protein_name");
        String shortName = this.getProperty("protein_short_name");
        String primaryUniprotId = this.getProperty("primary_uniprot_id");
        int taxId = Integer.parseInt(this.getProperty("species"));
        this.proteinId = this.insertMolecule(type, name, shortName, primaryUniprotId, taxId);
        if (this.proteinId != -1) {
            String omimIds;
            String keggIds;
            String[] keys;
            this.log.info("inserting interpro");
            String interpro_ids = this.getProperty("interpro_ids");
            if (interpro_ids != null) {
                String[] ip_ids = interpro_ids.split(";");
                this.service.insertInterProRel.setInt(2, this.proteinId);
                for (int k = 0; k < ip_ids.length; ++k) {
                    this.service.insertInterProRel.setString(1, ip_ids[k]);
                    try {
                        this.service.insertInterProRel.addBatch();
                        continue;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.service.insertInterProRel.executeBatch();
            }
            this.log.info("inserting go");
            String gon_ids = this.getProperty("go_ids");
            if (gon_ids != null) {
                String[] go_ids = gon_ids.split(";");
                this.service.insertGo.setInt(2, this.proteinId);
                this.service.insertGoEvidence.setInt(2, this.proteinId);
                for (int k = 0; k < go_ids.length; ++k) {
                    String go_id = go_ids[k].split("\\(")[0];
                    String evidence = go_ids[k].split("\\(")[1];
                    evidence = evidence.split("\\)")[0];
                    this.service.insertGo.setString(1, go_id);
                    this.service.insertGo.addBatch();
                    this.service.insertGoEvidence.setString(1, go_id);
                    this.service.insertGoEvidence.setString(3, evidence);
                    this.service.insertGoEvidence.setInt(4, PpiConstants.DB_ID.UNIPROT.ordinal());
                    this.service.insertGoEvidence.addBatch();
                }
            }
            this.service.insertGo.executeBatch();
            this.service.insertGoEvidence.executeBatch();
            this.log.info("inserting reactome");
            String reactome_ids = this.getProperty("reactome_ids");
            if (reactome_ids != null) {
                String[] re_ids = reactome_ids.split(";");
                this.service.insertReactome.setInt(2, this.proteinId);
                for (int k = 0; k < re_ids.length; ++k) {
                    this.service.insertReactome.setString(1, re_ids[k]);
                    this.service.insertReactome.executeUpdate();
                }
            }
            this.log.info("inserting sequence");
            String sequence = this.getProperty("sequence");
            this.service.insertSequence.setInt(1, this.proteinId);
            this.service.insertSequence.setString(2, sequence);
            this.service.insertSequence.executeUpdate();
            this.log.info("inserting refs for protein " + this.proteinId);
            for (String key : keys = new String[]{"ec_number", "gene_id", "org_specific_id", "ref_seq"}) {
                String value = this.getProperty(key);
                if (value == null || value.trim().isEmpty()) continue;
                this.service.insertReference.setInt(1, this.proteinId);
                this.service.insertReference.setString(2, key);
                this.service.insertReference.setString(3, value);
                this.service.insertReference.addBatch();
            }
            String secondaryUniprotIds = this.getProperty("secondary_uniprot_ids");
            if (secondaryUniprotIds != null) {
                this.log.info("Found sec uniprot ids: " + secondaryUniprotIds);
                for (String id : secondaryUniprotIds.split(";")) {
                    if (id == null || id.trim().isEmpty()) continue;
                    this.service.insertReference.setInt(1, this.proteinId);
                    this.service.insertReference.setString(2, "secondary_uniprot_id");
                    this.service.insertReference.setString(3, id);
                    this.service.insertReference.addBatch();
                }
            }
            if ((keggIds = this.getProperty("kegg_ids")) != null) {
                this.log.info("Found kegg ids: " + keggIds);
                for (String id : keggIds.split(";")) {
                    if (id == null || id.trim().isEmpty()) continue;
                    this.service.insertReference.setInt(1, this.proteinId);
                    this.service.insertReference.setString(2, "kegg_id");
                    this.service.insertReference.setString(3, id);
                    this.service.insertReference.addBatch();
                }
            }
            if ((omimIds = this.getProperty("omim_genotype")) != null) {
                for (String id : omimIds.split(";")) {
                    if (id == null || id.trim().isEmpty()) continue;
                    this.service.insertReference.setInt(1, this.proteinId);
                    this.service.insertReference.setString(2, "omim_genotype");
                    this.service.insertReference.setString(3, id);
                    this.service.insertReference.addBatch();
                }
            }
            this.service.insertReference.executeBatch();
            this.log.info("... inserted into DB with protein_id " + this.proteinId);
        }
        return this.proteinId;
    }

    private int insertMolecule(int type, String name, String shortName, String primaryUniprotId, int taxId) throws SQLException {
        int protein_id = -1;
        this.service.insertMolecule.setInt(1, type);
        this.service.insertMolecule.setString(2, name);
        this.service.insertMolecule.setString(3, shortName);
        this.service.insertMolecule.setString(4, primaryUniprotId);
        this.service.insertMolecule.setInt(5, taxId);
        this.service.insertMolecule.executeUpdate();
        ResultSet result = this.service.insertMolecule.getGeneratedKeys();
        if (result.next()) {
            protein_id = result.getInt(1);
        } else {
            this.log.error("Query did not return automatically generated key.");
        }
        return protein_id;
    }

    public boolean isPersistent() throws SQLException {
        if (this.proteinId != -1) {
            return true;
        }
        int found_id = this.service.findIdByPrimaryUniprotId(this.getProperty("primary_uniprot_id"));
        if (found_id != -1) {
            this.proteinId = found_id;
            return true;
        }
        return false;
    }

    public int getProteinId() throws SQLException {
        return this.proteinId;
    }

    public Connection getConnection() {
        return this.con;
    }

    public String setProperty(String key, String value) {
        return (String)this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String default_value) {
        return this.properties.getProperty(key, default_value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean checkRequired() {
        if (this.required_properties == null) {
            return true;
        }
        for (int i = 0; i < this.required_properties.length; ++i) {
            if (this.getProperty(this.required_properties[i]) != null) continue;
            return false;
        }
        return true;
    }

    public UniProtEntry getEntry() {
        return this.entry;
    }

    public void setEntry(UniProtEntry entry) {
        this.entry = entry;
    }
}

