/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator.dbx;

import de.berlin.hu.ppi.mediator.dbx.DBConstants;
import de.berlin.hu.ppi.mediator.dbx.DBLookupProtein;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBLookupProteinService
implements DBConstants {
    private static final String QUERY_DELETE_UNIPROT_ID = "DELETE FROM lookup_uniprot_id WHERE uniprot_id = ?";
    private static final String QUERY_INSERT_LOOKUP_UNIPROT_ID = "INSERT IGNORE INTO lookup_uniprot_id VALUES (?,?)";
    private static final String QUERY_INSERT_LOOKUP_PROTEIN = "INSERT INTO lookup_protein VALUES (?,?,?,?,?,?,?,?,?,NULL,?,?,?)";
    private static final String QUERY_SELECT_NEW_UNIPROT_ID = "SELECT new_id FROM lookup_uniprot_demerged WHERE old_id = ?";
    private static final String QUERY_SELECT_LOOKUP_PROTEIN_VIA_ANY_UNIPROT_ID = "SELECT lookup_protein.* FROM lookup_protein, lookup_uniprot_id WHERE secondary_uniprot_id = ? AND lookup_uniprot_id.primary_uniprot_id = lookup_protein.primary_uniprot_id";
    private static final String QUERY_SELECT_LOOKUP_PROTEIN_VIA_PRIMARY_UNIPROT_ID = "SELECT * FROM lookup_protein WHERE primary_uniprot_id = ?";
    Logger log = Logger.getLogger(DBLookupProteinService.class);
    Connection con = null;
    protected PreparedStatement selectDemergedQuery;
    protected PreparedStatement selectByPrimaryUniprotIdQuery;
    protected PreparedStatement selectByAnyUniprotIdQuery;
    protected PreparedStatement insertProteinQuery;
    protected PreparedStatement insertUniprotIdQuery;
    protected PreparedStatement deleteUniprotIdQuery;

    public DBLookupProteinService(Connection con) {
        try {
            this.con = con;
            this.selectByPrimaryUniprotIdQuery = con.prepareStatement(QUERY_SELECT_LOOKUP_PROTEIN_VIA_PRIMARY_UNIPROT_ID);
            this.selectByAnyUniprotIdQuery = con.prepareStatement(QUERY_SELECT_LOOKUP_PROTEIN_VIA_ANY_UNIPROT_ID);
            this.selectDemergedQuery = con.prepareStatement(QUERY_SELECT_NEW_UNIPROT_ID);
            this.insertProteinQuery = con.prepareStatement(QUERY_INSERT_LOOKUP_PROTEIN);
            this.insertUniprotIdQuery = con.prepareStatement(QUERY_INSERT_LOOKUP_UNIPROT_ID);
            this.deleteUniprotIdQuery = con.prepareStatement(QUERY_DELETE_UNIPROT_ID);
        }
        catch (SQLException e) {
            this.log.error("Couldn't instantiate DBLookupProteinService: " + e);
            return;
        }
    }

    public DBLookupProtein newDBLookupProtein() {
        return new DBLookupProtein(this.con, this);
    }

    public DBLookupProtein newDBLookupProtein(Properties properties) {
        DBLookupProtein new_prot = new DBLookupProtein(this.con, this);
        new_prot.setProperties(properties);
        return new_prot;
    }

    public String findId(String uniprot_id) throws SQLException {
        this.selectByPrimaryUniprotIdQuery.setString(1, uniprot_id);
        ResultSet rs = this.selectByPrimaryUniprotIdQuery.executeQuery();
        if (!rs.next()) {
            return null;
        }
        String upId = rs.getString(1);
        rs.close();
        return upId;
    }

    public DBLookupProtein[] find(String uniprot_id) throws SQLException {
        this.selectByAnyUniprotIdQuery.setString(1, uniprot_id);
        ResultSet rs = this.selectByAnyUniprotIdQuery.executeQuery();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        rs.beforeFirst();
        DBLookupProtein[] foundProteins = new DBLookupProtein[count];
        count = 0;
        while (rs.next()) {
            DBLookupProtein foundProtein = new DBLookupProtein(this.con, this);
            this.populateProtein(foundProtein, rs);
            foundProteins[count++] = foundProtein;
        }
        rs.close();
        return foundProteins;
    }

    public String[] findDemerged(String uniprotid) throws SQLException {
        this.selectDemergedQuery.setString(1, uniprotid);
        ResultSet rs = this.selectDemergedQuery.executeQuery();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] foundIDs = new String[count];
        rs.beforeFirst();
        count = 0;
        while (rs.next()) {
            foundIDs[count++] = rs.getString("new_id");
        }
        rs.close();
        return foundIDs;
    }

    public void findDemergedNew(String uniProtId, List<String> results) throws SQLException {
        this.selectDemergedQuery.setString(1, uniProtId);
        ResultSet rs = this.selectDemergedQuery.executeQuery();
        while (rs.next()) {
            String uid = rs.getString("new_id");
            results.add(uid);
        }
        rs.close();
    }

    private void populateProtein(DBLookupProtein found_protein, ResultSet rs) throws SQLException {
        String[] items = new String[]{"primary_uniprot_id", "sequence", "species", "protein_name", "gene_id", "ref_seq", "org_specific_id", "kegg_id", "ec_number", "interpro_ids", "go_ids", "reactome_ids"};
        for (int i = 0; i < items.length; ++i) {
            String prop = rs.getString(items[i]);
            if (prop == null) continue;
            found_protein.setProperty(items[i], prop);
        }
    }
}

