/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator.dbx;

import de.berlin.hu.ppi.mediator.dbx.DBConstants;
import de.berlin.hu.ppi.mediator.dbx.DBLookupProteinService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBLookupProtein
implements DBConstants {
    Logger log;
    Properties properties;
    Connection con = null;
    String[] required_properties;
    String proteinRel = "lookup_protein";
    String uniprotidRel = "lookup_uniprot_id";
    private String experimentaRole = null;
    DBLookupProteinService service;

    public DBLookupProtein(Connection con, DBLookupProteinService service) {
        this.con = con;
        this.service = service;
        this.properties = new Properties();
        this.log = Logger.getLogger(DBLookupProtein.class);
    }

    public String insert() throws SQLException {
        String up_id = this.service.findId(this.getProperty("primary_uniprot_id"));
        if (up_id != null) {
            return this.getProperty("primary_uniprot_id");
        }
        this.service.insertProteinQuery.setString(1, this.getProperty("primary_uniprot_id"));
        this.service.insertProteinQuery.setString(2, this.getProperty("protein_name", ""));
        this.service.insertProteinQuery.setString(3, this.getProperty("sequence"));
        this.service.insertProteinQuery.setString(4, this.getProperty("species"));
        this.service.insertProteinQuery.setString(5, this.getProperty("gene_id"));
        this.service.insertProteinQuery.setString(6, this.getProperty("ref_seq"));
        this.service.insertProteinQuery.setString(7, this.getProperty("org_specific_id"));
        this.service.insertProteinQuery.setString(8, this.getProperty("kegg_id"));
        this.service.insertProteinQuery.setString(9, this.getProperty("ec_number"));
        this.service.insertProteinQuery.setString(10, this.getProperty("interpro_ids"));
        this.service.insertProteinQuery.setString(11, this.getProperty("go_ids"));
        this.service.insertProteinQuery.setString(12, this.getProperty("reactome_ids"));
        int inserted = this.service.insertProteinQuery.executeUpdate();
        if (inserted != 1) {
            throw new SQLException("Insertion of new LookupProtein didn't return '1'");
        }
        String primary_up_id = this.getProperty("primary_uniprot_id");
        this.service.insertUniprotIdQuery.setString(1, primary_up_id);
        this.service.insertUniprotIdQuery.setString(2, primary_up_id);
        this.service.insertUniprotIdQuery.executeUpdate();
        String[] sec_accessions = this.getProperty("secondary_uniprot_ids").split(";");
        for (int i = 0; i < sec_accessions.length; ++i) {
            if (sec_accessions[i] == "") continue;
            this.service.insertUniprotIdQuery.setString(1, primary_up_id);
            this.service.insertUniprotIdQuery.setString(2, sec_accessions[i]);
            this.service.insertUniprotIdQuery.executeUpdate();
        }
        this.log.info("... inserted into DB");
        return primary_up_id;
    }

    public Connection getConnection() {
        return this.con;
    }

    public String setProperty(String key, String value) {
        return (String)this.properties.setProperty(key, value);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String default_value) {
        return this.properties.getProperty(key, default_value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean checkRequired() {
        if (this.required_properties == null) {
            return true;
        }
        for (int i = 0; i < this.required_properties.length; ++i) {
            if (this.getProperty(this.required_properties[i]) != null) continue;
            return false;
        }
        return true;
    }

    public void setExperimentaRole(String experimentaRole) {
        this.experimentaRole = experimentaRole;
    }

    public String getExperimentaRole() {
        return this.experimentaRole;
    }
}

