/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator.dbx;

import de.berlin.hu.ppi.mediator.dbx.DBInteraction;
import de.berlin.hu.ppi.mediator.dbx.DBProtein;
import de.berlin.hu.ppi.mediator.dbx.DBProteinService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBInteractionService {
    Logger log = Logger.getLogger(DBInteractionService.class);
    Connection con = null;
    DBProteinService dbProteinService;
    protected PreparedStatement selectInteractionQuery;
    protected PreparedStatement insertInteractionQuery;
    protected PreparedStatement deleteInteractionQuery;
    protected PreparedStatement deleteExperimentQuery;
    protected PreparedStatement insertExperimentQuery;

    public DBInteractionService(Connection con, DBProteinService dbProteinService) {
        try {
            this.con = con;
            this.dbProteinService = dbProteinService;
            this.selectInteractionQuery = con.prepareStatement("SELECT * FROM protein_interaction WHERE ((protein_id_a = ? AND protein_id_b = ?) OR (protein_id_a = ? AND protein_id_b = ?)) AND db_source_id = ?");
            this.insertInteractionQuery = con.prepareStatement("INSERT INTO protein_interaction VALUES(NULL,?,?,?,?,?,?,?,?,?,?)", 1);
            this.insertExperimentQuery = con.prepareStatement("INSERT IGNORE INTO experiment VALUES(?,?,?)");
            this.deleteInteractionQuery = con.prepareStatement("DELETE FROM protein_interaction WHERE interaction_id = ?");
            this.deleteExperimentQuery = con.prepareStatement("DELETE FROM experiment WHERE interaction_id = ?");
        }
        catch (Exception e) {
            this.log.error("Couldn't instantiate DBInteractionService: " + e);
            return;
        }
    }

    public DBInteraction newDBInteraction() {
        return new DBInteraction(this.con, this);
    }

    public DBInteraction newDBInteraction(Properties properties) {
        DBInteraction new_int = new DBInteraction(this.con, this);
        new_int.setProperties(properties);
        return new_int;
    }

    public boolean exists(int protein_id_a, int protein_id_b, String db_source_id) throws SQLException {
        this.selectInteractionQuery.setInt(1, protein_id_a);
        this.selectInteractionQuery.setInt(2, protein_id_b);
        this.selectInteractionQuery.setInt(3, protein_id_b);
        this.selectInteractionQuery.setInt(4, protein_id_a);
        this.selectInteractionQuery.setInt(5, Integer.parseInt(db_source_id));
        ResultSet rs = this.selectInteractionQuery.executeQuery();
        if (!rs.next()) {
            return false;
        }
        rs.close();
        return true;
    }

    public DBInteraction find(int protein_id_a, int protein_id_b, String db_source_id) throws SQLException {
        this.selectInteractionQuery.setInt(1, protein_id_a);
        this.selectInteractionQuery.setInt(2, protein_id_b);
        this.selectInteractionQuery.setInt(3, protein_id_b);
        this.selectInteractionQuery.setInt(4, protein_id_a);
        this.selectInteractionQuery.setInt(5, Integer.parseInt(db_source_id));
        ResultSet rs = this.selectInteractionQuery.executeQuery();
        if (!rs.next()) {
            return null;
        }
        DBProtein protein_a = this.dbProteinService.find(protein_id_a);
        DBProtein protein_b = this.dbProteinService.find(protein_id_b);
        if (protein_a == null || protein_b == null) {
            rs.close();
            return null;
        }
        DBInteraction found_interaction = new DBInteraction(this.con, this);
        found_interaction.setProteins(protein_a, protein_b);
        found_interaction.setProperty("db_source_id", rs.getString("db_source_id"));
        String interactionType = rs.getString("interaction_type");
        if (interactionType != null) {
            found_interaction.setProperty("interaction_type", interactionType);
        }
        found_interaction.setProperty("predicted", rs.getString("predicted"));
        found_interaction.setProperty("complex_ppi", rs.getString("complex_ppi"));
        found_interaction.setProperty("disease_ppi", rs.getString("disease_ppi"));
        found_interaction.setProperty("demerged", rs.getString("demerged"));
        found_interaction.setProperty("interaction_id", rs.getString("interaction_id"));
        rs.close();
        return found_interaction;
    }
}

