/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator.dbx;

import de.berlin.hu.ppi.mediator.dbx.DBConstants;
import de.berlin.hu.ppi.mediator.dbx.DBInteractionService;
import de.berlin.hu.ppi.mediator.dbx.DBProtein;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBInteraction
implements DBConstants {
    Logger log;
    Properties properties;
    Connection con = null;
    DBInteractionService dbInteractionService;
    String[] required_properties;
    PreparedStatement selectInteractionQuery;
    PreparedStatement insertInteractionQuery;
    PreparedStatement insertExperimentQuery;
    PreparedStatement deleteInteractionQuery;
    PreparedStatement deleteExperimentQuery;
    DBProtein dbProtein_a;
    DBProtein dbProtein_b;

    public DBInteraction(Connection con, DBInteractionService dbInteractionService) {
        this.con = con;
        this.dbInteractionService = dbInteractionService;
        this.properties = new Properties();
        this.init();
        this.log = Logger.getLogger(DBInteraction.class);
    }

    private void init() {
        this.dbProtein_a = null;
        this.dbProtein_b = null;
        this.selectInteractionQuery = this.dbInteractionService.selectInteractionQuery;
        this.insertInteractionQuery = this.dbInteractionService.insertInteractionQuery;
        this.insertExperimentQuery = this.dbInteractionService.insertExperimentQuery;
        this.deleteInteractionQuery = this.dbInteractionService.deleteInteractionQuery;
        this.deleteExperimentQuery = this.dbInteractionService.deleteExperimentQuery;
    }

    public void setProteins(DBProtein prot_a, DBProtein prot_b) {
        this.dbProtein_a = prot_a;
        this.dbProtein_b = prot_b;
    }

    public void setProteinA(DBProtein prot_a) {
        this.dbProtein_a = prot_a;
    }

    public void setProteinB(DBProtein prot_b) {
        this.dbProtein_b = prot_b;
    }

    public DBProtein getProteinA() {
        return this.dbProtein_a;
    }

    public DBProtein getProteinB() {
        return this.dbProtein_b;
    }

    public void insert() throws SQLException {
        int proteinBId;
        if (this.dbProtein_a == null || this.dbProtein_b == null) {
            throw new SQLException("Need to set both interactors before performing an insert of the interaction!");
        }
        int proteinAId = this.dbProtein_a.insert();
        if (this.dbInteractionService.exists(proteinAId, proteinBId = this.dbProtein_b.insert(), this.getProperty("db_source_id"))) {
            if (this.getProperty("complex_ppi").equals("1")) {
                return;
            }
            DBInteraction old_interaction = this.dbInteractionService.find(proteinAId, proteinBId, this.getProperty("db_source_id"));
            if (!"1".equals(old_interaction.getProperty("complex_ppi"))) {
                return;
            }
            this.deleteExperimentQuery.setInt(1, Integer.parseInt(old_interaction.getProperty("interaction_id")));
            this.deleteInteractionQuery.setInt(1, Integer.parseInt(old_interaction.getProperty("interaction_id")));
            this.deleteExperimentQuery.executeUpdate();
            this.deleteInteractionQuery.executeUpdate();
            this.log.info("complex ppi removed from db to favour pairwise interaction:");
        }
        this.log.info("+++ Inserting new interaction! ");
        this.insertInteractionQuery.setInt(1, proteinAId);
        this.insertInteractionQuery.setInt(2, proteinBId);
        this.insertInteractionQuery.setInt(3, Integer.parseInt(this.getProperty("db_source_id")));
        String inteactionType = this.getProperty("interaction_type");
        if (inteactionType.trim().isEmpty()) {
            this.insertInteractionQuery.setString(4, null);
        } else {
            this.insertInteractionQuery.setString(4, this.getProperty("interaction_type"));
        }
        this.insertInteractionQuery.setString(5, this.getProperty("predicted"));
        this.insertInteractionQuery.setString(6, this.getProperty("complex_ppi"));
        this.insertInteractionQuery.setString(7, this.getProperty("disease_ppi"));
        this.insertInteractionQuery.setString(8, this.getProperty("demerged"));
        this.insertInteractionQuery.setString(9, this.dbProtein_a.getExperimentalRole());
        this.insertInteractionQuery.setString(10, this.dbProtein_b.getExperimentalRole());
        if (this.insertInteractionQuery.executeUpdate() != 1) {
            throw new SQLException("Insertion of new Interaction didn't return '1'");
        }
        int interaction_id = 0;
        ResultSet r1 = this.insertInteractionQuery.getGeneratedKeys();
        if (!r1.next()) {
            this.log.error("Couldn't get Interaction PK!");
            return;
        }
        interaction_id = r1.getInt(1);
        this.log.info(" (PK: " + interaction_id + " )");
        String experimentsValue = this.getProperty("experiments");
        if (experimentsValue != null) {
            String[] experiments = experimentsValue.split("[|]");
            for (int i = 0; i < experiments.length; ++i) {
                String[] properties = experiments[i].split("---");
                String detectionMethod = properties[0];
                String pubMedId = properties[1];
                this.insertExperimentQuery.setInt(1, interaction_id);
                this.insertExperimentQuery.setString(2, "null".equals(detectionMethod) ? null : detectionMethod);
                this.insertExperimentQuery.setString(3, "null".equals(pubMedId) ? null : pubMedId);
                this.insertExperimentQuery.executeUpdate();
            }
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    public String setProperty(String key, String value) {
        return (String)this.properties.setProperty(key, value);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean checkRequired() {
        if (this.required_properties == null) {
            return true;
        }
        for (int i = 0; i < this.required_properties.length; ++i) {
            if (this.getProperty(this.required_properties[i]) != null) continue;
            return false;
        }
        return true;
    }
}

